/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerComputingThread
extends Thread {
    private Map<String, Computor> _computors;
    private RequestStock _stock;
    private CECILIAServer _serveur;
    private Request _currentReq;
    private Computor _currentProcess;
    private List<String> _autorizedComputors;
    private ComputeInfo _computeInfo = ComputeInfo.NORMAL;

    public ServerComputingThread(CECILIAServer serveur) {
        super("COMPUTOR");
        this.setPriority(1);
        this._serveur = serveur;
        this._stock = serveur.getRequestStock();
        this._computors = new HashMap<String, Computor>();
        this._autorizedComputors = new ArrayList<String>();
    }

    public void addComputor(String name, Computor computor) {
        if (this._computors.get(name) == null) {
            this._computors.put(name, computor);
            this._autorizedComputors.add(name);
        }
    }

    @Override
    public void run() {
        boolean hasComputedInPreviousLoop = false;
        try {
            while (true) {
                if (this._computeInfo == ComputeInfo.LAST) {
                    this._computeInfo = ComputeInfo.FINISHED;
                    break;
                }
                Request req = this._stock.getNextRequestToCompute();
                try {
                    ServerComputingThread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (req == null) {
                    if (hasComputedInPreviousLoop) {
                        this._serveur.sendInfo();
                    }
                    hasComputedInPreviousLoop = false;
                    continue;
                }
                StringBuffer found = new StringBuffer();
                found.append("Found request  : ");
                found.append(req.getAllID());
                Loggeur.log(this.getClass(), Loggeur.DEBUG, found.toString());
                if (!this.isEngineOK(req)) {
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.WAIT_COMPUTING_2_SERVER_DOESNTT_HAVE_ENGINE);
                    continue;
                }
                if (!this.areFilesReady(req)) {
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.WAIT_COMPUTING_2_MISSING_FILE_TO_COMPUTE);
                    continue;
                }
                Computor computor = this._computors.get(req.getEngine());
                StringBuffer sb = new StringBuffer(128);
                sb.append(req.getEngine());
                sb.append(" : ");
                sb.append(ResJXTA.getString("ENGINE_LAUNGING"));
                sb.append(" ");
                sb.append(req.getAllID());
                Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
                this._currentReq = req;
                this._serveur.sendInfo();
                this._currentProcess = computor;
                ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.WAIT_COMPUTING_2_COMPUTING);
                if (computor.compute(req)) {
                    this._serveur.printInfo("fin du calcul " + req.getAllID());
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.COMPUTING_2_COMPUTE_FINISHED);
                } else {
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.COMPUTING_2_ENGINE_ERROR);
                    this._serveur.printInfo("le calcul de la requete a renvoye' faux !" + req.getAllID());
                }
                this._currentReq = null;
                StringBuffer removal = new StringBuffer();
                removal.append("Request removed from computor : ");
                removal.append(req.getAllID());
                Loggeur.log(this.getClass(), Loggeur.DEBUG, removal.toString());
                hasComputedInPreviousLoop = true;
            }
        }
        catch (ReqAutomatonException reqe) {
            reqe.printStackTrace();
            reqe.getRequest().setInfo("ServeurComputingThread" + reqe.getMessage());
            ReqAutomatonServer.fireEvent(reqe.getRequest(), ReqAutomatonServer.EvtServer.CANCEL_BY_SOFTWARE);
            this._computeInfo = ComputeInfo.FINISHED;
        }
        catch (Exception e) {
            e.printStackTrace();
            Loggeur.log(this.getClass(), Loggeur.FATAL, e.getMessage());
            this._computeInfo = ComputeInfo.FINISHED;
        }
    }

    public boolean stopComputing(Request req) {
        if (this._currentReq == req) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop Req... " + req.getAllID());
            this._currentProcess.stop();
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop OK");
            return true;
        }
        return false;
    }

    public boolean stopComputing() {
        Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop ... " + (this._currentReq != null ? this._currentReq.getID() : ""));
        if (this._currentProcess != null) {
            if (this._currentProcess.stop()) {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop OK");
            } else {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop KO");
            }
        } else {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Nothing to stop");
        }
        return true;
    }

    public boolean stopComputing(String clientID) {
        if (this._currentReq == null) {
            return false;
        }
        if (this._currentReq.getClientID().equals(clientID)) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop Client ... " + this._currentReq.getID() + " " + clientID);
            if (this._currentProcess.stop()) {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop OK");
            } else {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, "Stop KO");
            }
            return true;
        }
        return false;
    }

    public void shutDownComputor() {
        if (this._computeInfo != ComputeInfo.FINISHED) {
            this._computeInfo = ComputeInfo.LAST;
        }
        this._computors.clear();
    }

    public boolean isFinished() {
        return this._computeInfo == ComputeInfo.FINISHED;
    }

    protected boolean verifyNeededFiles(Request req) {
        for (String uniqueFileName : req.getNeededFiles()) {
            File neededFile = new File(JXTAProperties.getTempDir(), uniqueFileName);
            if (neededFile.exists()) continue;
            return false;
        }
        return true;
    }

    protected boolean areFilesReady(Request req) {
        if (this.verifyNeededFiles(req)) {
            return true;
        }
        try {
            ServerComputingThread.sleep(6000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.verifyNeededFiles(req);
    }

    protected boolean isEngineOK(Request req) {
        String engine = req.getEngine();
        Computor computor = this._computors.get(engine);
        return computor != null && this._autorizedComputors.contains(engine);
    }

    public Computor getComputor(String computor) {
        return this._computors.get(computor);
    }

    public List<String> getEnginesList() {
        return new ArrayList<String>(this._computors.keySet());
    }

    public List<String> getAuthorizedEnginesList() {
        return this._autorizedComputors;
    }

    public void setAuthorizedEnginesList(List<String> autorized) {
        this._autorizedComputors = autorized;
    }

    public Request getCurrentReq() {
        return this._currentReq;
    }

    public AppPeer getCeciliaPeer() {
        return this._serveur;
    }

    private static enum ComputeInfo {
        NORMAL,
        LAST,
        FINISHED;

    }
}

