/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.ihm.BoxWaiting;
import com.dassault.cecilia.lib.distrib.ihm.ButtonEditor;
import com.dassault.cecilia.lib.distrib.ihm.ButtonTableCellRenderer;
import com.dassault.cecilia.lib.distrib.ihm.DistribAbstractAction;
import com.dassault.cecilia.lib.distrib.ihm.InfoServersAppTableModel;
import com.dassault.cecilia.lib.distrib.ihm.JTableHightLight;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.StockClientTableModel;
import com.dassault.cecilia.lib.distrib.ihm.TrashTableModel;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class IHMClient
extends JDialog {
    private JTable _tableReq;
    private JTable _tableSrv;
    private JTable _tableTrash;
    private StockClientTableModel _modelReqs;
    private InfoServersAppTableModel _modelSrvs;
    private TrashTableModel _modelTrash;
    private CECILIAClient _client;
    private ArrayList<DistribAbstractAction> _menuRequetes;
    private ArrayList<DistribAbstractAction> _menuNetWork;
    private ArrayList<DistribAbstractAction> _menuDistrib;
    private JTabbedPane _tabPanne;

    public IHMClient(JFrame arg0) {
        super(arg0);
    }

    public IHMClient(JDialog arg0) {
        super(arg0);
    }

    public void init(CECILIAClient client) {
        this.setLayout(new BorderLayout());
        this._client = client;
        this._menuRequetes = new ArrayList();
        this._menuNetWork = new ArrayList();
        this._menuDistrib = new ArrayList();
        this.createActions();
        this.setJMenuBar(this.createMenuBar());
        this.add((Component)this.createToolBar(), "North");
        this._tabPanne = new JTabbedPane();
        this._tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_REQS"), this.createRequestsTab());
        this._tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_SERVEURS"), this.createServeursTab());
        this._tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_TRASH"), this.createTrashTab());
        this.add((Component)this._tabPanne, "Center");
        this.pack();
        this.setTitle(this._client.getPeerJXTA().getPeerName());
    }

    private void createActions() {
        DistribAbstractAction actionCancelAll = new DistribAbstractAction("cancelAll.gif", "MENU_CANCEL_CANCEL_ALL", "MENU_CANCEL_CANCEL_ALL"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionCancelAll();
            }
        };
        DistribAbstractAction actionEmptyTrash = new DistribAbstractAction("trash.gif", "MENU_CANCEL_TRASH", "MENU_CANCEL_TRASH"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionTrash();
            }
        };
        this._menuRequetes.add(actionCancelAll);
        this._menuRequetes.add(actionEmptyTrash);
        DistribAbstractAction actionRefresh = new DistribAbstractAction("search.gif", "MENU_NETWORK_REFRESH", "MENU_NETWORK_REFRESH"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionRefreshNetwork();
            }
        };
        DistribAbstractAction actiondetailedCard = new DistribAbstractAction("card.gif", "MENU_NETWORK_SERVER_CARD", "MENU_NETWORK_SERVER_CARD"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionDetailedCard();
            }
        };
        DistribAbstractAction refusedConnections = new DistribAbstractAction("noAccess.gif", "MENU_NETWORK_REFUSED_CONNECTIONS", "MENU_NETWORK_REFUSED_CONNECTIONS"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionShowRefusedConnections();
            }
        };
        this._menuNetWork.add(actionRefresh);
        this._menuNetWork.add(actiondetailedCard);
        this._menuNetWork.add(refusedConnections);
        DistribAbstractAction actionPause = new DistribAbstractAction("pause.gif", "MENU_DISTRIBUTION_PAUSE", "MENU_DISTRIBUTION_PAUSE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionPause();
            }
        };
        DistribAbstractAction actionResume = new DistribAbstractAction("resume.gif", "MENU_DISTRIBUTION_RESUME", "MENU_DISTRIBUTION_RESUME"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionResume();
            }
        };
        DistribAbstractAction actionRelaunchAll = new DistribAbstractAction("relaunchAll.gif", "MENU_DISTRIBUTION_RELAUNCH_ALL", "MENU_DISTRIBUTION_RELAUNCH_ALL"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionRelaunchAll();
            }
        };
        DistribAbstractAction actionRelaunchOne = new DistribAbstractAction("relaunchOne.gif", "MENU_DISTRIBUTION_RELAUNCH_ONE", "MENU_DISTRIBUTION_RELAUNCH_ONE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMClient.this.actionRelaunchOne();
            }
        };
        this._menuDistrib.add(actionPause);
        this._menuDistrib.add(actionResume);
        this._menuDistrib.add(actionRelaunchAll);
        this._menuDistrib.add(actionRelaunchOne);
    }

    protected JComponent createServeursTab() {
        JPanel panelSrvs = new JPanel(new GridBagLayout());
        this._modelSrvs = new InfoServersAppTableModel(this._client.getServersApp(), this._client.getPeerJXTA());
        this._tableSrv = new JTableHightLight(this._modelSrvs);
        this._modelSrvs.resizeCols(this._tableSrv);
        this._tableSrv.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                IHMClient.this.actionDetailedCard();
            }
        });
        panelSrvs.add((Component)new JScrollPane(this._tableSrv), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panelSrvs;
    }

    protected JComponent createRequestsTab() {
        JPanel panelReq = new JPanel(new GridBagLayout());
        this._modelReqs = new StockClientTableModel(this._client, this._client.getRequestStock());
        this._tableReq = new JTableHightLight(this._modelReqs);
        this._modelReqs.resizeCols(this._tableReq);
        TableColumn histoColumn = this._tableReq.getColumnModel().getColumn(3);
        histoColumn.setCellRenderer(new ButtonTableCellRenderer());
        histoColumn.setCellEditor(new ButtonEditor(this._modelReqs, this._client.getPeerJXTA()));
        panelReq.add((Component)new JScrollPane(this._tableReq), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        TimerTask display = new TimerTask(){

            @Override
            public void run() {
                IHMClient.this._modelReqs.fireTableDataChanged();
            }
        };
        Timer timer = new Timer("UPDATE REQ TABLE", true);
        timer.schedule(display, 1000L, 1000L);
        return panelReq;
    }

    protected JComponent createTrashTab() {
        JPanel paneltrash = new JPanel(new GridBagLayout());
        this._modelTrash = new TrashTableModel(this._client.getRequestTrash(), this._client);
        this._tableTrash = new JTableHightLight(this._modelTrash);
        TableColumn histoColumn = this._tableTrash.getColumnModel().getColumn(3);
        histoColumn.setCellRenderer(new ButtonTableCellRenderer());
        histoColumn.setCellEditor(new ButtonEditor(this._modelTrash, this._client.getPeerJXTA()));
        this._modelTrash.resizeCols(this._tableTrash);
        paneltrash.add((Component)new JScrollPane(this._tableTrash), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return paneltrash;
    }

    protected JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        for (DistribAbstractAction action : this._menuRequetes) {
            bar.add(action.createButton());
        }
        bar.add(Box.createHorizontalStrut(5));
        for (DistribAbstractAction action : this._menuDistrib) {
            bar.add(action.createButton());
        }
        bar.add(Box.createHorizontalStrut(5));
        for (DistribAbstractAction action : this._menuNetWork) {
            bar.add(action.createButton());
        }
        return bar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuCancel = new JMenu(ResJXTAIHM.getString("GLOBAL_REQS"));
        for (DistribAbstractAction action : this._menuRequetes) {
            menuCancel.add(new JMenuItem(action));
        }
        JMenu menuDistrib = new JMenu(ResJXTAIHM.getString("MENU_DISTRIBUTION"));
        for (DistribAbstractAction action : this._menuDistrib) {
            menuDistrib.add(new JMenuItem(action));
        }
        JMenu menuNet = new JMenu(ResJXTAIHM.getString("MENU_NETWORK"));
        for (DistribAbstractAction action : this._menuNetWork) {
            menuNet.add(new JMenuItem(action));
        }
        menuBar.add(menuCancel);
        menuBar.add(menuDistrib);
        menuBar.add(menuNet);
        return menuBar;
    }

    private void actionRefreshNetwork() {
        int res;
        if (this._client.getRequestStock().size() > 0 && (res = JOptionPane.showConfirmDialog(this, ResJXTAIHM.getString("DLG_REFRESH_STOCK_NOT_EMPTY"), "", 0)) == 1) {
            return;
        }
        BoxWaiting wait = new BoxWaiting(this){

            @Override
            protected String getBoxTitle() {
                return ResJXTAIHM.getString("MENU_NETWORK_REFRESH");
            }

            @Override
            protected void waintingAction() {
                IHMClient.this._client.refreshNetwork();
                IHMClient.this._modelSrvs.serveurListChange();
            }
        };
        wait.start();
    }

    private void actionCancelAll() {
        this._client.cancelAllRequest(true);
    }

    private void actionTrash() {
        this._client.getRequestTrash().clear();
    }

    private void actionPause() {
        this._client.pauseDistribution();
    }

    private void actionResume() {
        this._client.resumeDistribution();
    }

    private void actionRelaunchAll() {
        ArrayList<Request> reqs = this._client.getRequestStock().getCopy();
        for (Request request : reqs) {
            this._client.relaunchRequest(request);
        }
    }

    private void actionRelaunchOne() {
        String reqNum = JOptionPane.showInputDialog(this, (Object)ResJXTAIHM.getString("DLG_REQUEST_NUMBER_RELAUNCH"));
        if (reqNum == null || reqNum.equals("")) {
            return;
        }
        String reqID = "";
        try {
            reqID = Request.createName(this._client.getShortID(), Integer.parseInt(reqNum));
        }
        catch (NumberFormatException e) {
            return;
        }
        Request req = this._client.getRequestStock().getRequest(reqID);
        if (req == null) {
            return;
        }
        this._client.relaunchRequest(req);
    }

    private void actionDetailedCard() {
        this._tabPanne.setSelectedIndex(1);
        int row = this._tableSrv.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this, ResJXTAIHM.getString("DLG_SELECT_SERVER"));
            return;
        }
        InfoServerApp server = this._client.getServersApp().get(row);
        boolean toBeUsed = this._modelSrvs.displayDetails(server, this);
        server.setToBeUSed(toBeUsed);
        this._modelSrvs.fireTableRowsUpdated(row, row);
    }

    private void actionShowRefusedConnections() {
        StringBuffer sb = new StringBuffer();
        List<InfoPeerJXTA> peers = this._client.getConnexionRefusedPeer();
        for (InfoPeerJXTA infoPeerJXTA : peers) {
            sb.append(infoPeerJXTA.getName());
            sb.append(" : version=\"");
            sb.append(infoPeerJXTA.getVersion());
            sb.append("\" types=\"");
            List<String> types = infoPeerJXTA.getAuthorizedTypes();
            boolean first = true;
            for (String string : types) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(string);
            }
            sb.append("\"");
        }
        JTextArea ctrlMess = new JTextArea();
        ctrlMess.setLineWrap(false);
        ctrlMess.setWrapStyleWord(false);
        ctrlMess.setEditable(false);
        ctrlMess.setTabSize(4);
        ctrlMess.setText(sb.toString());
        JTable table = new JTable(new RefusedConnectionTableModel(this._client.getConnexionRefusedPeer()));
        JScrollPane scrMess = new JScrollPane(table);
        scrMess.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(this, scrMess);
    }

    @Override
    public void dispose() {
        this._modelSrvs.dispose();
        this._modelTrash.dispose();
        super.dispose();
    }

    class RefusedConnectionTableModel
    extends AbstractTableModel {
        private static final int IDX_PEERNAME = 0;
        private static final int IDX_HOSTNAME = 1;
        private static final int IDX_VERSION = 2;
        private static final int IDX_TYPE = 3;
        private List<InfoPeerJXTA> _connexionRefusedPeer;

        public RefusedConnectionTableModel(List<InfoPeerJXTA> connexionRefusedPeer) {
            this._connexionRefusedPeer = connexionRefusedPeer;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this._connexionRefusedPeer.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResJXTAIHM.getString("GLOBAL_SERVEUR");
                }
                case 1: {
                    return ResJXTAIHM.getString("GLOBAL_HOSTNAME");
                }
                case 2: {
                    return ResJXTAIHM.getString("GLOBAL_VERSION");
                }
                case 3: {
                    return ResJXTAIHM.getString("GLOBAL_TYPES");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            InfoPeerJXTA peer = this._connexionRefusedPeer.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return peer.getName();
                }
                case 1: {
                    return peer.getHostName();
                }
                case 2: {
                    return peer.getVersion();
                }
                case 3: {
                    return peer.getAuthorizedTypes();
                }
            }
            return "";
        }
    }
}

