/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.ihm.BoxInfoServerAdmin;
import com.dassault.cecilia.lib.distrib.ihm.ButtonEditor;
import com.dassault.cecilia.lib.distrib.ihm.ButtonTableCellRenderer;
import com.dassault.cecilia.lib.distrib.ihm.DistribAbstractAction;
import com.dassault.cecilia.lib.distrib.ihm.JTableHightLight;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.StockServerTableModel;
import com.dassault.cecilia.lib.distrib.ihm.TrashTableModel;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;

public class IHMServer
extends JDialog {
    private JTable _tableReq;
    private JTable _tableTrash;
    private StockServerTableModel _modelReqs;
    private TrashTableModel _modelTrash;
    private CECILIAServer _server;
    private ArrayList<DistribAbstractAction> _menuRequetes;

    public IHMServer(Dialog owner) {
        super(owner);
    }

    public IHMServer(Frame owner) {
        super(owner);
    }

    public void init(CECILIAServer client) {
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IHMServer.this.actionStop();
            }
        });
        this._server = client;
        this._menuRequetes = new ArrayList();
        this.createActions();
        this.setJMenuBar(this.createMenuBar());
        this.add((Component)this.createToolBar(), "North");
        JTabbedPane tabPanne = new JTabbedPane();
        tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_REQS"), this.createRequestsTab());
        tabPanne.addTab(ResJXTAIHM.getString("GLOBAL_TRASH"), this.createTrashTab());
        this.add((Component)tabPanne, "Center");
        this.pack();
        this.setTitle(this._server.getPeerJXTA().getPeerName());
    }

    private void createActions() {
        DistribAbstractAction actionEmptyTrash = new DistribAbstractAction("trash.gif", "MENU_CANCEL_TRASH", "MENU_CANCEL_TRASH"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMServer.this.actionTrash();
            }
        };
        this._menuRequetes.add(actionEmptyTrash);
        DistribAbstractAction actiondetailedCard = new DistribAbstractAction("card.gif", "MENU_NETWORK_SERVER_CARD", "MENU_NETWORK_SERVER_CARD"){

            @Override
            public void actionPerformed(ActionEvent e) {
                IHMServer.this.actionDetailedCard();
            }
        };
        this._menuRequetes.add(actiondetailedCard);
    }

    protected JComponent createRequestsTab() {
        JPanel panelReq = new JPanel(new GridBagLayout());
        this._modelReqs = new StockServerTableModel(this._server, this._server.getRequestStock());
        this._tableReq = new JTableHightLight(this._modelReqs);
        this._modelReqs.resizeCols(this._tableReq);
        panelReq.add((Component)new JScrollPane(this._tableReq), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        TimerTask display = new TimerTask(){

            @Override
            public void run() {
                IHMServer.this._modelReqs.fireTableDataChanged();
            }
        };
        Timer timer = new Timer("UPDATE REQUEST TABLE", true);
        timer.schedule(display, 1000L, 1000L);
        return panelReq;
    }

    protected JComponent createTrashTab() {
        JPanel paneltrash = new JPanel(new GridBagLayout());
        this._modelTrash = new TrashTableModel(this._server.getRequestTrash(), this._server);
        this._tableTrash = new JTableHightLight(this._modelTrash);
        TableColumn histoColumn = this._tableTrash.getColumnModel().getColumn(3);
        histoColumn.setCellRenderer(new ButtonTableCellRenderer());
        histoColumn.setCellEditor(new ButtonEditor(this._modelTrash, this._server.getPeerJXTA()));
        this._modelTrash.resizeCols(this._tableTrash);
        paneltrash.add((Component)new JScrollPane(this._tableTrash), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return paneltrash;
    }

    protected JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        for (DistribAbstractAction action : this._menuRequetes) {
            bar.add(action.createButton(true));
        }
        return bar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuCancel = new JMenu(ResJXTAIHM.getString("MENU_CANCEL"));
        for (DistribAbstractAction action : this._menuRequetes) {
            menuCancel.add(new JMenuItem(action));
        }
        menuBar.add(menuCancel);
        return menuBar;
    }

    private void displayRequestInfo(Request req) {
        JOptionPane.showMessageDialog(this._tableTrash, req.getHistoString(this._server.getPeerJXTA()));
    }

    public void displayHisto(int row) {
        Request req = this._modelTrash.getRequest(row);
        if (req == null) {
            return;
        }
        this.displayRequestInfo(req);
    }

    private void actionStop() {
        this._server.shutdown();
        System.exit(0);
    }

    private void actionTrash() {
        this._server.getRequestTrash().clear();
    }

    private void actionDetailedCard() {
        BoxInfoServerAdmin card = new BoxInfoServerAdmin(this);
        assert (card != null);
        card.setServerMode(true);
        card.version = "1.8.6";
        card.cpufreq = 0;
        card.desc = System.getProperty("cecilia.jxta.desc");
        card.engines = this._server.getComputor().getEnginesList().toArray(new String[0]);
        card.authorizedEngines = this._server.getComputor().getAuthorizedEnginesList().toArray(new String[0]);
        try {
            card.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            card.hostname = "";
        }
        card.mem = 0;
        card.name = this._server.getPeerJXTA().getPeerName();
        card.peerID = this._server.getPeerJXTA().getPeerIDString();
        card.stockSize = this._server.getRequestStock().size();
        if (card.doModal()) {
            this._server.setAuthorizedEngine(Arrays.asList(card.authorizedEngines));
        }
    }

    @Override
    public void dispose() {
        this._modelTrash.dispose();
        super.dispose();
    }
}

