/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServersApp;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.entityinfo.RemoteServerChangeListener;
import com.dassault.cecilia.lib.distrib.ihm.BoxInfoServer;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.UtilTableModel;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class InfoServersAppTableModel
extends UtilTableModel
implements RemoteServerChangeListener,
PeerChangeListener {
    protected InfoServersApp _serveurs;
    protected PeerJXTA _localJXTA;

    public InfoServersAppTableModel(InfoServersApp serveurs, PeerJXTA localJXTA) {
        this._serveurs = serveurs;
        this._serveurs.addListener(this);
        this._localJXTA = localJXTA;
    }

    public void dispose() {
        this._serveurs.removeListener(this);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this._serveurs.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InfoServerApp srv = this._serveurs.get(rowIndex);
        if (srv == null) {
            if (columnIndex == 3) {
                return Boolean.FALSE;
            }
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return srv.getName();
            }
            case 1: {
                return srv.getStockSize();
            }
            case 2: {
                return Request.convertToUserFriendly(srv.getCurrentReqID(), this._localJXTA);
            }
            case 3: {
                return srv.shouldBeUsed();
            }
        }
        return "err";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            InfoServerApp srv = this._serveurs.get(rowIndex);
            Boolean toBeUsed = (Boolean)aValue;
            srv.setToBeUSed(toBeUsed);
        }
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResJXTAIHM.getString("GLOBAL_SERVEUR");
            }
            case 1: {
                return ResJXTAIHM.getString("GLOBAL_STOCK_SIZE");
            }
            case 2: {
                return ResJXTAIHM.getString("GLOBAL_REQ");
            }
            case 3: {
                return ResJXTAIHM.getString("GLOBAL_USE");
            }
        }
        return "err";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public int getColumnSize(int col) {
        switch (col) {
            case 0: {
                return 60;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 40;
            }
        }
        return 30;
    }

    @Override
    public boolean engineErrorCountChange(String peerID, int oldCount, int newCount) {
        this.updateServer(peerID);
        return true;
    }

    @Override
    public void serveurListChange() {
        int i = 0;
        while (i < this._serveurs.size()) {
            this._serveurs.get(i).getPeerJXTA().addChangeListener(this);
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void stockSizeChange(String peerID, int oldSize, int newSize) {
        this.updateServer(peerID);
    }

    @Override
    public void peerStatusChange(String peerID, int oldStatus, int newStatus, PeerChangeListener.Reason reason) {
        this.updateServer(peerID);
    }

    private void updateServer(String serverID) {
        InfoServerApp server = this._serveurs.getServer(serverID);
        if (server == null) {
            return;
        }
        int idx = this._serveurs.getIndexOf(server);
        this.fireTableRowsUpdated(idx, idx);
    }

    public boolean displayDetails(InfoServerApp server, Window parent) {
        BoxInfoServer card = null;
        if (parent instanceof JFrame) {
            card = new BoxInfoServer((JFrame)parent);
        } else if (parent instanceof JDialog) {
            card = new BoxInfoServer((JDialog)parent);
        }
        assert (card != null);
        card.version = server.getVersion();
        card.authorized = server.isAuthorized();
        card.cpufreq = server.getCpuFrequency();
        card.currentReq = Request.convertToUserFriendly(server.getCurrentReqID(), this._localJXTA);
        card.desc = server.getUserDesc();
        card.engines = server.getAuthorizedEngines();
        card.hostname = server.getHostName();
        card.mem = server.getMemory();
        card.name = server.getName();
        card.online = server.isOnline();
        card.connected = server.isBound();
        card.peerID = server.getPeerID();
        card.stockSize = server.getStockSize();
        card.toBeUsed = server.shouldBeUsed();
        card.lastTimeInfo = server.getLastInfoTime();
        card.doModal();
        return card.toBeUsed;
    }

    @Override
    public boolean mustBeHighlightedRed(int row) {
        InfoServerApp srv = this._serveurs.get(row);
        if (srv == null) {
            return true;
        }
        return !srv.isOnline() || !srv.isAuthorized();
    }
}

