/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.jxtautility;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.jxtautility.ConfigHelper;
import com.dassault.cecilia.lib.distrib.jxtautility.LockUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkStartUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.xmlutility.AdvertisementAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.PeerAdvHandler;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.NetworkManager;
import net.jxta.protocol.PeerAdvertisement;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class NetworkManager25
extends NetworkManager {
    public static final String RELAY_FILE = "discovered.peer";
    private ConfigHelper _configHelper;
    private boolean _stopped25 = false;
    private static NetworkManager25 _singleton = null;
    private static ThreadLocal<Boolean> __singletonLocal = new ThreadLocal();
    private static short __singletonShutdown = 0;

    public NetworkManager25(ConfigHelper config) throws IOException {
        super(config.getMode(), config.getPeerInstanceName(), config.getInstanceHomeURI());
        this._configHelper = config;
    }

    public synchronized PeerGroup startNetwork() throws PeerGroupException, IOException {
        return super.startNetwork();
    }

    public synchronized void stopNetwork() {
        try {
            super.stopNetwork();
            Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.ERROR, ResJXTA.getString("NETWORK_STOP_OK"));
            this._stopped25 = true;
        }
        catch (Exception e) {
            Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.ERROR, ResJXTA.getString("NETWORK_STOP_ERROR"));
            System.err.println(ResJXTA.getString("NETWORK_STOP_ERROR"));
            this._stopped25 = true;
        }
    }

    public boolean isStopped() {
        return this._stopped25;
    }

    public ConfigHelper getConfigHelper() {
        return this._configHelper;
    }

    public void publishBasicPeerAdv() {
        DiscoveryService discoverySvc = this.getNetPeerGroup().getDiscoveryService();
        try {
            PeerAdvertisement peerAdv = this.getNetPeerGroup().getPeerAdvertisement();
            peerAdv.setDescription(InetAddress.getLocalHost().getHostName());
            discoverySvc.publish((Advertisement)this.getNetPeerGroup().getPeerAdvertisement());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Advertisement> searchForPeerAdvertisements() {
        DiscoveryService discoverySvc = this.getNetPeerGroup().getDiscoveryService();
        discoverySvc.getRemoteAdvertisements(null, 0, null, null, 100);
        ArrayList<Advertisement> advertisments = new ArrayList<Advertisement>();
        try {
            Thread.sleep(NetworkUtility.getTimeOutForSearch());
            Enumeration tmps = discoverySvc.getLocalAdvertisements(0, null, null);
            while (tmps.hasMoreElements()) {
                advertisments.add((Advertisement)tmps.nextElement());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return advertisments;
    }

    public PeerAdvertisement searchForPeerAdvertisements(String peerID) {
        DiscoveryService discoverySvc = this.getNetPeerGroup().getDiscoveryService();
        discoverySvc.getRemoteAdvertisements(peerID, 0, null, null, 10);
        Enumeration advertisments = null;
        try {
            Thread.sleep(NetworkUtility.getTimeOutForSearch());
            advertisments = discoverySvc.getLocalAdvertisements(0, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (advertisments != null && advertisments.hasMoreElements()) {
            return (PeerAdvertisement)advertisments.nextElement();
        }
        return null;
    }

    public void createRemotePeerList(PeerJXTA localPeer, List<Advertisement> advertisments) {
        for (Advertisement adv : advertisments) {
            if (adv instanceof PeerAdvertisement) {
                PeerAdvertisement peerAdv = (PeerAdvertisement)adv;
                if (peerAdv.getPeerID().equals(localPeer.getPeerID())) continue;
                AdvertisementAnalyser advAnalyser = new AdvertisementAnalyser(peerAdv);
                String type = advAnalyser.getDescription("PEERTYPE");
                if (type != null) {
                    InfoPeerJXTA newPeerInfo = new InfoPeerJXTA(peerAdv);
                    if (!advAnalyser.updatePeerInfo(newPeerInfo) || localPeer.getRemotePeer(newPeerInfo.getPeerIDString()) != null) continue;
                    localPeer.addRemotePeer(newPeerInfo);
                    continue;
                }
                Hashtable paramMap = peerAdv.getServiceParams();
                SAXParserFactory fabrique = SAXParserFactory.newInstance();
                PeerAdvHandler advHandler = new PeerAdvHandler();
                try {
                    Collection collection = paramMap.values();
                    Iterator iter = collection.iterator();
                    while (iter.hasNext()) {
                        String param = iter.next().toString();
                        SAXParser parseur = fabrique.newSAXParser();
                        parseur.parse(new InputSource(new StringReader(param)), (DefaultHandler)advHandler);
                    }
                    if (!advHandler.isRDV()) continue;
                    InfoPeerJXTA infoRDV = new InfoPeerJXTA(peerAdv);
                    infoRDV.setAdvDesc(advAnalyser.getDesc());
                    infoRDV.setType("RDV");
                    localPeer.addRemotePeer(infoRDV);
                }
                catch (Exception se) {}
                continue;
            }
            Loggeur.log(NetworkManager25.class, Loggeur.INFO, adv.toString());
        }
    }

    public void searchForPeers(PeerJXTA localPeer) {
        Loggeur.log(NetworkManager25.class, Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_BEGIN"));
        List<Advertisement> advertisments = this.searchForPeerAdvertisements();
        if (advertisments == null) {
            Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_ERROR"));
            return;
        }
        Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_ANALYSE"));
        this.createRemotePeerList(localPeer, advertisments);
        NetworkUtility.updateRemoteStatus(localPeer);
        NetworkUtility.searchServerAdvBloquing(localPeer);
        Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.INFO, localPeer.printRemote());
        Loggeur.log(NetworkManager25.class, Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_FINISHED"));
    }

    public void displayPeers() {
        Loggeur.log(NetworkManager25.class, Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_BEGIN"));
        DiscoveryService discoverySvc = this.getNetPeerGroup().getDiscoveryService();
        discoverySvc.getRemoteAdvertisements(null, 0, null, null, 100);
        Enumeration advertisments = null;
        try {
            Thread.sleep(NetworkUtility.getTimeOutForSearch() * 2);
            advertisments = discoverySvc.getLocalAdvertisements(0, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer detected = new StringBuffer();
        while (advertisments.hasMoreElements()) {
            block8: {
                PeerAdvertisement peerAdv = null;
                Advertisement adv = (Advertisement)advertisments.nextElement();
                try {
                    peerAdv = (PeerAdvertisement)adv;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                detected.append(peerAdv.getName());
                Hashtable paramMap = peerAdv.getServiceParams();
                SAXParserFactory fabrique = SAXParserFactory.newInstance();
                PeerAdvHandler advHandler = new PeerAdvHandler();
                try {
                    Collection collection = paramMap.values();
                    Iterator iter = collection.iterator();
                    while (iter.hasNext()) {
                        String param = iter.next().toString();
                        SAXParser parseur = fabrique.newSAXParser();
                        parseur.parse(new InputSource(new StringReader(param)), (DefaultHandler)advHandler);
                    }
                    if (!advHandler.isRDV()) break block8;
                    detected.append(" : RDV");
                }
                catch (Exception se) {
                    detected.append("\n");
                    continue;
                }
            }
            if (!advertisments.hasMoreElements()) continue;
            detected.append("\n");
        }
        Loggeur.log(NetworkManager25.class, Loggeur.INFO, detected.toString());
        Loggeur.log(NetworkManager25.class, Loggeur.INFO, ResJXTA.getString("NETWORK_SCAN_FINISHED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NetworkManager25 getSingleton() throws IOException {
        if (__singletonLocal.get() != null) return _singleton;
        Class<NetworkManager25> clazz = NetworkManager25.class;
        synchronized (NetworkManager25.class) {
            if (_singleton == null) {
                LockUtility.createLock(true);
                Loggeur.log(NetworkManager25.class, Loggeur.INFO, ResJXTA.getString("CONFIG_START"));
                _singleton = NetworkStartUtility.createManager();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        _singleton.shutdown();
                    }
                });
            }
            __singletonLocal.set(Boolean.TRUE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.DEBUG, "NetwokManager shutdown call");
        Class<NetworkManager25> clazz = NetworkManager25.class;
        synchronized (NetworkManager25.class) {
            if (__singletonShutdown == 0) {
                Loggeur.log(((Object)((Object)this)).getClass(), Loggeur.DEBUG, "NetwokManager stop network");
                __singletonShutdown = 1;
                _singleton.stopNetwork();
                LockUtility.removeLock();
            }
            __singletonShutdown = (short)2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        JXTAProperties.initLaunchIni();
        try {
            try {
                _singleton = NetworkManager25.getSingleton();
                _singleton.startNetwork();
                TimerTask display = new TimerTask(){

                    @Override
                    public void run() {
                        _singleton.displayPeers();
                    }
                };
                Timer timerDisplayPeers = new Timer("DISPLAY PEER", true);
                timerDisplayPeers.schedule(display, 1000L, 60000L);
                while (!_singleton.isStopped()) {
                    Thread.sleep(1000L);
                }
                timerDisplayPeers.cancel();
            }
            catch (IOException e) {
                e.printStackTrace();
                Loggeur.log(NetworkManager25.class, Loggeur.SEVERE, ResJXTA.getString("NETWORK_ERROR"));
                LockUtility.removeLock();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                LockUtility.removeLock();
            }
            catch (PeerGroupException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                LockUtility.removeLock();
            }
        }
        finally {
            LockUtility.removeLock();
        }
    }

    public static void stop() {
        if (_singleton != null) {
            _singleton.shutdown();
        }
    }
}

