/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.log;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import java.io.File;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;

public class HandlerUtility {
    protected static String getPattern(String clName) {
        String pattStr;
        String pattern = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".pattern");
        if (pattern != null) {
            pattStr = pattern.toString();
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("./");
            sb.append(HandlerUtility.getSimpleName(clName));
            sb.append(".log");
            pattStr = sb.toString();
        }
        return HandlerUtility.convertPattern(pattStr);
    }

    protected static int getLimit(String clName) {
        String limit = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".limit");
        if (limit == null) {
            return 1;
        }
        try {
            return Integer.parseInt(limit.toString());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    protected static int getCount(String clName) {
        String count = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".count");
        if (count == null) {
            return 1;
        }
        try {
            return Integer.parseInt(count.toString());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    protected static boolean getAppend(String clName) {
        String limit = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".append");
        if (limit == null) {
            return false;
        }
        return Boolean.parseBoolean(limit.toString());
    }

    protected static Formatter getFormatter(String clName) {
        String formatter = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".formatter");
        if (formatter == null) {
            return null;
        }
        try {
            Class<?> cl = HandlerUtility.class.getClassLoader().loadClass(formatter.toString());
            Object obj = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof Formatter) {
                return (Formatter)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static Filter getFilter(String clName) {
        String filter = LogManager.getLogManager().getProperty(String.valueOf(clName) + ".filter");
        if (filter == null) {
            return null;
        }
        try {
            Class<?> cl = HandlerUtility.class.getClassLoader().loadClass(filter.toString());
            Object obj = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof Filter) {
                return (Filter)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String convertPattern(String pattern) {
        if (JXTAProperties.getBoolProperty("cecilia.jxta.log.relativ") && HandlerUtility.isRelativ(pattern)) {
            StringBuffer sb = new StringBuffer();
            sb.append(JXTAProperties.getDistributedDir());
            sb.append(File.separator);
            sb.append(pattern);
            return sb.toString();
        }
        return pattern;
    }

    private static boolean isRelativ(String pattern) {
        if (pattern.startsWith(".")) {
            return true;
        }
        return !pattern.contains("\\") && !pattern.contains("/");
    }

    private static String getSimpleName(String fullClassName) {
        try {
            Class<?> classs = ClassLoader.getSystemClassLoader().loadClass(fullClassName);
            return classs.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            return "ClassNotFound";
        }
    }
}

