/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.BidiPipeServer;
import com.dassault.cecilia.lib.distrib.peers.PeerServer;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.JxtaServerPipe;

public class ConnectionsListennerThread
extends Thread {
    private PeerServer _server;
    private JxtaServerPipe _serverPipe;

    public ConnectionsListennerThread(PeerServer server) {
        super("CONNECTION_LISTENER");
        this._serverPipe = server.getServerPipe();
        this._server = server;
        try {
            this._serverPipe.setPipeTimeout(30000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (!this._serverPipe.isClosed()) {
                    JxtaBiDiPipe bipipe = this._serverPipe.accept();
                    if (bipipe == null) continue;
                    BidiPipeServer bidiServer = new BidiPipeServer(bipipe, this._server);
                    bidiServer.start();
                }
            }
            catch (SocketTimeoutException ste) {
                continue;
            }
            catch (IOException e) {
                if (this._serverPipe.isClosed()) break;
                e.printStackTrace();
            }
            break;
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("NETWORK_PIPE_STOP_LISTENNING"));
    }

    public void closeConnection() {
        if (this._serverPipe != null) {
            try {
                this._serverPipe.close();
            }
            catch (Exception e) {
                Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("NETWORK_PIPE_STOP_LISTENNING")) + " E");
            }
        }
    }
}

