/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;

public abstract class AbstractReqSurveyor
extends Thread {
    protected Request _reqToSurvey;
    protected int _waitTime;
    protected boolean _speed = false;
    protected ReqAssertion _assertion;
    protected String _failtxt;
    protected static final int NBRTRIESTOTEST = 10;

    public AbstractReqSurveyor(Request req, int timeToWait) {
        this(req, timeToWait, "SURVEYOR " + req.getShortNumber() + " " + timeToWait);
    }

    public AbstractReqSurveyor(Request req, int timeToWait, String name) {
        super(name);
        this.setDaemon(true);
        this.setPriority(1);
        this._reqToSurvey = req;
        this._waitTime = timeToWait;
    }

    protected abstract void success();

    protected abstract void fail();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        if (this._assertion == null) {
            throw new RuntimeException("AbstractReqSurveyor : _assertion == null");
        }
        if (this._speed) {
            i = 0;
            while (i < 10) {
                try {
                    AbstractReqSurveyor abstractReqSurveyor = this;
                    synchronized (abstractReqSurveyor) {
                        this.wait(this._waitTime / 10);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this._assertion.assertForSurvey()) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            i = 0;
            while (i < 10) {
                try {
                    AbstractReqSurveyor e = this;
                    synchronized (e) {
                        this.wait(this._waitTime / 10);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this._reqToSurvey.isFinished()) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        try {
            if (this._assertion.assertForSurvey()) {
                this.success();
            } else {
                this.fail();
            }
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
        }
    }

    public void setFailText(String string) {
        this._failtxt = string;
    }

    abstract class ReqAssertion {
        ReqAssertion() {
        }

        public abstract boolean assertForSurvey();
    }
}

