/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.request;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class CommandFileWriter {
    protected StringBuffer _sb;
    protected CECILIAClient _client;
    private File _file;
    protected Request _req;

    public CommandFileWriter(CECILIAClient client, Request req) throws IOException {
        this._req = req;
        this._sb = new StringBuffer();
        this._client = client;
        this._file = File.createTempFile("Req" + this._req.getShortNumber(), ".cmd", JXTAProperties.getTempDir());
        this._file.deleteOnExit();
    }

    public void writeText(String s) {
        this._sb.append(s);
    }

    public void writeInputFile(File f) {
        String uniqueName = this._client.makeUniqueFileID(f.getAbsolutePath(), false);
        this._req.addNeededFile(uniqueName);
        this._sb.append(uniqueName);
    }

    public void writeOutputFile(File f) {
        String uniqueName = this._client.makeUniqueFileID(f.getAbsolutePath(), false);
        this._req.addResultFile(uniqueName);
        this._sb.append(uniqueName);
    }

    public void flushAndClose() throws IOException {
        FileWriter fw = new FileWriter(this._file);
        fw.write(this._sb.toString());
        fw.flush();
        fw.close();
    }

    public String getTrueFileName() {
        return this._file.getAbsolutePath();
    }

    public String getUniqueFileName() {
        return this._client.makeUniqueFileID(this.getTrueFileName(), false);
    }
}

