/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServersApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAAdmin;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManagerClient;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminMessageCreator;
import java.text.MessageFormat;

public class AdminManagerAdmin
extends AdminManagerClient {
    public AdminManagerAdmin(CECILIAAdmin peer) {
        super(peer);
    }

    @Override
    protected void remoteStopAllRequest(InfoPeerJXTA server) {
        assert (server != null);
        Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS_ON_SERVEUR")) + server.getName());
        AdminMessageCreator admMess = new AdminMessageCreator(24, "", this._appPeer.getPeerJXTA().getPeerIDString());
        server.sendMessage(admMess.createMessage());
    }

    public void remoteShutDown(InfoPeerJXTA server) {
        assert (server != null);
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("ADMIN_ADMIN_PLEASE_SHUT_DOWN"), server.getName()));
        AdminMessageCreator admMess = new AdminMessageCreator(26, "", this._appPeer.getPeerJXTA().getPeerIDString());
        server.sendMessage(admMess.createMessage());
    }

    public void remoteStopAllRequestClient(InfoPeerJXTA client) {
        assert (client != null);
        Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("ADMIN_CANCEL_ALL_REQUESTS_OF_CLIENT")) + client.getName());
        AdminMessageCreator admMess = new AdminMessageCreator(23, client.getPeerIDString(), this._appPeer.getPeerJXTA().getPeerIDString());
        InfoServersApp serveurs = ((CECILIAAdmin)this._appPeer).getServersApp();
        int i = 0;
        while (i < serveurs.size()) {
            serveurs.get(i).getPeerJXTA().sendMessage(admMess.createMessage());
            ++i;
        }
    }

    @Override
    public void remoteStopRequest(Request req) {
        AdminMessageCreator admMess = new AdminMessageCreator(22, req.getID(), this._appPeer.getPeerJXTA().getPeerIDString());
        InfoServerApp serverApp = (InfoServerApp)this._appPeer.getRemoteAppList().getRemoteInfoPeerApp(req.getServerID());
        if (serverApp != null && serverApp.canBeUsedForComputation()) {
            serverApp.getPeerJXTA().sendMessage(admMess.createMessage());
        }
    }

    public void remoteChangePriorityClient(InfoPeerJXTA client, int newPrio) {
        assert (client != null);
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("PRIORITY_CHANGE_CLIENT"), client.getName(), String.valueOf(newPrio)));
        AdminMessageCreator admMess = new AdminMessageCreator(25, client.getPeerIDString(), this._appPeer.getPeerJXTA().getPeerIDString());
        admMess.addAttribut("PRIO", String.valueOf(newPrio));
        InfoServersApp serveurs = ((CECILIAAdmin)this._appPeer).getServersApp();
        int i = 0;
        while (i < serveurs.size()) {
            serveurs.get(i).getPeerJXTA().sendMessage(admMess.createMessage());
            ++i;
        }
    }

    public void remoteChangeServerEngine(InfoPeerJXTA serveur, String[] newEngines) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < newEngines.length) {
            sb.append(newEngines[i]);
            if (i < newEngines.length - 1) {
                sb.append("|");
            }
            ++i;
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        AdminMessageCreator admMess = new AdminMessageCreator(27, serveur.getPeerIDString(), this._appPeer.getPeerJXTA().getPeerIDString());
        admMess.addAttribut("NEWENGINES", sb.toString());
        serveur.sendMessage(admMess.createMessage());
    }
}

