/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManager;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminMessageCreator;
import com.dassault.cecilia.lib.distrib.xmlutility.StatAnalyser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;

public class AdminManagerClient
extends AdminManager {
    public AdminManagerClient(AppPeer peer) {
        super(peer);
    }

    protected ArrayList<InfoServerApp> getUsableServers() {
        ArrayList<InfoServerApp> servers = new ArrayList<InfoServerApp>();
        Iterator<? extends InfoPeerApp> it = this._appPeer.getRemoteAppList().iterator();
        while (it.hasNext()) {
            InfoServerApp peer = (InfoServerApp)it.next();
            if (!peer.canBeUsedForComputation() || servers.contains(peer)) continue;
            servers.add(peer);
        }
        return servers;
    }

    @Override
    protected void localAnalyseInfo(InfoPeerApp peerApp, MessageElement statElt) {
        InfoServerApp server = (InfoServerApp)peerApp;
        server.setLastInfoTime(System.currentTimeMillis());
        StatAnalyser statAnalyser = new StatAnalyser(statElt);
        String engines = statAnalyser.getAttribut("AUTHORIZEDENGINES");
        StringTokenizer st = new StringTokenizer(engines, ",");
        ArrayList<String> enginesList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String engine = st.nextToken();
            enginesList.add(engine);
        }
        server.flushEngines();
        server.addEngines(enginesList);
        String taille = statAnalyser.getAttribut("STOCKSIZE");
        try {
            int stockSize = Integer.parseInt(taille);
            server.setStockSize(stockSize);
        }
        catch (NumberFormatException nfe) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "Invalid StokSize");
            return;
        }
        String reqID = statAnalyser.getAttribut("CURRENTREQUEST");
        if (reqID != null) {
            server.setCurrentReqID(reqID);
        }
        String shutingDown = statAnalyser.getAttribut("SHUTINGDOWN");
        boolean shuting = false;
        try {
            shuting = Boolean.parseBoolean(shutingDown);
        }
        catch (NumberFormatException e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Invalid ShutingDown");
        }
        if (shuting && this._appPeer instanceof CECILIAClient) {
            CECILIAClient client = (CECILIAClient)this._appPeer;
            server.flushEngines();
            server.setShutingDown();
            client.getRequestStock().tagRequests(server.getPeerID(), MessageFormat.format(ResJXTA.getString("ADMIN_SERVEUR_SHUTING_DOWN"), server.getName()));
            if (reqID == null || !client.getShortID().equals(Request.retrievePeerID(reqID))) {
                client.redistribReqOfServer(server);
            } else {
                ArrayList<Request> reqs = client.getRequestStock().getServerRequests(server.getPeerID());
                for (Request request : reqs) {
                    if (reqID.equals(request.getID())) continue;
                    request.relaunch();
                }
            }
        }
    }

    @Override
    protected void localAdminShutDown() {
    }

    public void remoteStopAllRequest(InfoServerApp serverApp) {
        if (serverApp.isOnline() && serverApp.isAuthorized()) {
            this.remoteStopAllRequest(serverApp.getPeerJXTA());
        }
    }

    protected void remoteStopAllRequest(InfoPeerJXTA server) {
        assert (server != null);
        AdminMessageCreator admMess = new AdminMessageCreator(8, "", this._appPeer.getPeerJXTA().getPeerIDString());
        server.sendMessage(admMess.createMessage());
    }

    public void remoteStopAllRequest() {
        for (InfoServerApp serveur : this.getUsableServers()) {
            this.remoteStopAllRequest(serveur.getPeerJXTA());
        }
    }

    public void remoteStopRequest(Request req) {
        AdminMessageCreator admMess = new AdminMessageCreator(1, req.getID(), this._appPeer.getPeerJXTA().getPeerIDString());
        InfoServerApp serverApp = (InfoServerApp)this._appPeer.getRemoteAppList().getRemoteInfoPeerApp(req.getServerID());
        if (serverApp != null && serverApp.canBeUsedForComputation()) {
            serverApp.getPeerJXTA().sendMessage(admMess.createMessage());
        }
    }

    @Override
    protected void remoteSendInfo(String peerToInform) {
        InfoServerApp serverApp = ((CECILIAClient)this._appPeer).getServersApp().getServer(peerToInform);
        if (serverApp != null && serverApp.canTalkWith()) {
            this.remoteSendInfo(serverApp.getPeerJXTA());
        } else if (serverApp != null) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(ResJXTA.getString("ADMIN_UNKNOWN_PEER_FOR_INFO")) + serverApp.getName());
        } else {
            Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(ResJXTA.getString("ADMIN_UNKNOWN_PEER_FOR_INFO")) + " null");
        }
    }

    private void remoteSendInfo(InfoPeerJXTA remotePeer) {
        AdminMessageCreator admMessage = new AdminMessageCreator(6, "", this._peerJXTA.getPeerIDString());
        Message message = admMessage.createMessage();
        message.addMessageElement(((CECILIAClient)this._appPeer).createInfoElement());
        remotePeer.sendMessage(message);
    }

    public void removeDiffusedFiles(String uniqueFileName) {
        Iterator<? extends InfoPeerApp> it = this._appPeer.getRemoteAppList().iterator();
        while (it.hasNext()) {
            InfoServerApp peerApp = (InfoServerApp)it.next();
            if (!peerApp.canBeUsedForComputation()) continue;
            AdminMessageCreator admMessage = new AdminMessageCreator(9, uniqueFileName, this._peerJXTA.getPeerIDString());
            peerApp.getPeerJXTA().sendMessage(admMessage.createMessage());
        }
    }
}

