/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileSender;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.request.RequestHisto;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestConsigne;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStockServer;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLEscape;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.Message;

public class DistributorServer
extends Thread {
    RequestStockServer _stock;
    CECILIAServer _serveur;
    Map<String, RequestConsigne> _consignes;
    private DistributionInfo _distributionInfo = DistributionInfo.NORMAL;

    public DistributorServer(CECILIAServer serveur) {
        super("RESULT_DISTRIBUTOR");
        this._serveur = serveur;
        this._stock = serveur.getRequestStock();
        this._consignes = serveur.getRequestsConsigne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                DistributorServer distributorServer = this;
                synchronized (distributorServer) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this._distributionInfo == DistributionInfo.STOPPING) break;
            this.distribute();
        }
        this._distributionInfo = DistributionInfo.FINISHED;
    }

    public void stopDistribution() {
        this._distributionInfo = DistributionInfo.STOPPING;
    }

    public void distribute() {
        try {
            Request req = null;
            while ((req = this._stock.getNextComputedRequest()) != null) {
                Loggeur.log(this.getClass(), Loggeur.DEBUG, String.valueOf(req.getShortNumber()) + " --> Client");
                InfoClientApp clientApp = this._serveur.getClientsApp().getClient(req.getClientID());
                if (clientApp == null) {
                    Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(ResJXTA.getString("REQUEST_INVALID_CLIENT_ID")) + req.getClientID());
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_SOFTWARE);
                    continue;
                }
                if (!clientApp.isAuthorized()) {
                    Loggeur.log(this.getClass(), Loggeur.ERROR, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_FORBIDEN"), String.valueOf(clientApp.getName()) + " " + clientApp.getVersion()));
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_SOFTWARE);
                    continue;
                }
                Thread.sleep(50L);
                RequestConsigne consigne = this._consignes.get(clientApp.getPeerID());
                if (consigne != null) {
                    this._stock.removeRequest(req);
                    consigne.addRequest(req);
                    continue;
                }
                ReqState state = req.getState();
                if (state == ReqState.COMPUTE_FINISHED || state == ReqState.RESULTS_TRANSFERT_ERROR) {
                    this.sendResult(req, clientApp);
                    continue;
                }
                this.sendIssue(req, clientApp);
                this._stock.removeRequest(req);
                this._serveur.getRequestTrash().add(req);
                req.deleteNeededFile();
                req.deleteResultFiles();
            }
        }
        catch (ReqAutomatonException rae) {
            Request req = rae.getRequest();
            req.setInfo("DistributorServeur" + rae.getMessage());
            ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_SOFTWARE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Loggeur.log(this.getClass(), Loggeur.FATAL, e.getMessage());
        }
    }

    private void sendIssue(Request req, InfoClientApp clientapp) {
        this.sendIssue(req, clientapp.getPeerJXTA());
    }

    private void sendIssue(Request req, InfoPeerJXTA client) {
        Computor comp = this._serveur.getComputor().getComputor(req.getEngine());
        if (comp != null && comp.sendResultIfError()) {
            for (String uniqueFileName : req.getResultFiles()) {
                File file = new File(JXTAProperties.getTempDir(), uniqueFileName);
                try {
                    ByteFileSender.sendFileTo(file, uniqueFileName, this._serveur.getPeerJXTA().getPeerIDString(), client, req.getID());
                }
                catch (DistribException distribException) {
                    // empty catch block
                }
            }
        }
        Loggeur.log(this.getClass(), Loggeur.DEBUG, "Envoie du message d'erreur pour " + req.getShortNumber());
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("MESSAGETYPE", "ISSUE");
        attMap.put("UID", req.getID());
        attMap.put("STATUS", String.valueOf((Object)req.getState()));
        attMap.put("REQINFO", XMLEscape.toXML(String.valueOf(req.getInfo())));
        attMap.put("ERRORS", String.valueOf(req.getNumberOfErr()));
        Message issueMessage = MessageUtility.createMessageWithInfo(attMap, this._serveur.getPeerJXTA().getPeerIDString());
        client.sendMessage(issueMessage);
    }

    private void sendResult(final Request req, InfoClientApp clientapp) {
        InfoPeerJXTA client = clientapp.getPeerJXTA();
        if (req.getState() == ReqState.COMPUTE_FINISHED) {
            if (Long.getLong("cecilia.jxta.wait.before.send.result", -1L) > 0L) {
                RequestHisto histo = req.getHisto();
                Date begin = null;
                Date end = new Date();
                int i = histo.size() - 1;
                while (i >= 0 && begin == null) {
                    switch (histo.getIemeState(i)) {
                        case COMPUTE_FINISHED: {
                            break;
                        }
                        default: {
                            if (begin != null) break;
                            begin = histo.getIemeDate(i);
                        }
                    }
                    --i;
                }
                long delay = end.getTime() - begin.getTime();
                long wait = Long.getLong("cecilia.jxta.wait.before.send.result", -1L);
                if (wait > 0L && delay < wait) {
                    Loggeur.log(this.getClass(), Loggeur.DEBUG, "Wait before send result because compute is too fast");
                    try {
                        if (delay < 0L) {
                            Thread.sleep(wait);
                        } else {
                            Thread.sleep(wait - delay);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.COMPUTE_FINISHED_2_SENDING_RESULT);
        } else {
            ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.RESULT_TRANSFERT_ERROR_2_SENDING_RESULT);
        }
        this._serveur.printInfo(MessageFormat.format(ResJXTA.getString("DISTRIBUTION_SENDING_RESULT_TO_CLIENT"), req.getID(), client.getName()));
        for (String uniqueFileName : req.getResultFiles()) {
            File file = new File(JXTAProperties.getTempDir(), uniqueFileName);
            try {
                ByteFileSender.sendFileTo(file, uniqueFileName, this._serveur.getPeerJXTA().getPeerIDString(), client, req.getID());
            }
            catch (DistribException e) {
                if (e.getMessage().equals("Problem while reading file")) {
                    req.setInfo(file.getAbsolutePath());
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.SENDING_RESULT_2_WRONG_RESULT);
                } else {
                    e.getMessage().equals("Problem while communicating with peer");
                }
                return;
            }
        }
        client.sendMessage(DistributorServer.createResponseMessage(req, this._serveur.getPeerJXTA().getPeerIDString()));
        TimerTask verifTimeOut = new TimerTask(){

            @Override
            public void run() {
                if (req.getState() == ReqState.SENDING_RESULT) {
                    InfoClientApp infoClientApp = DistributorServer.this._serveur.getClientsApp().getClient(req.getClientID());
                    if (infoClientApp == null) {
                        return;
                    }
                    infoClientApp.getPeerJXTA().setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_LACK_OF_INFO_REPONSE);
                    DistributorServer.this._stock.removeRequest(req);
                    ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.SENDING_RESULT_2_RESULT_TRANSFERT_ERROR);
                    RequestConsigne consigne = DistributorServer.this._consignes.get(infoClientApp.getPeerID());
                    if (!$assertionsDisabled && consigne == null) {
                        throw new AssertionError();
                    }
                    consigne.addRequest(req);
                }
            }
        };
        new Timer("TransfertTimeOut waiting", true).schedule(verifTimeOut, Integer.getInteger("cecilia.jxta.filetransfert.timeout", 1800000).intValue());
    }

    public static Message createResponseMessage(Request req, String senderID) {
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("MESSAGETYPE", "CECILIARESPONSE");
        attMap.put("UID", req.getID());
        return MessageUtility.createMessageWithInfo(attMap, senderID);
    }

    public void remoteSendRequestStatus(Request req) {
        InfoClientApp client = this._serveur.getClientsApp().getClient(req.getClientID());
        if (client == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "Can't send state");
        } else if (client.canTalkWith()) {
            ReqState newState = req.getState();
            try {
                switch (newState) {
                    case COMPUTING: {
                        while (!req.flagWaitComputingReported) {
                            Thread.sleep(10L);
                        }
                        break;
                    }
                    case COMPUTE_FINISHED: {
                        while (!req.flagComputingReported) {
                            Thread.sleep(10L);
                        }
                        break;
                    }
                    case SENDING_RESULT: {
                        while (!req.flagComputFinishedReported) {
                            Thread.sleep(10L);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> attMap = new HashMap<String, String>();
            attMap.put("MESSAGETYPE", "REQSTATE");
            attMap.put("UID", req.getID());
            attMap.put("STATUS", String.valueOf((Object)newState));
            Message stateMsg = MessageUtility.createMessageWithInfo(attMap, this._serveur.getPeerJXTA().getPeerIDString());
            client.sendMessage(stateMsg);
            req.fireStateReportedToRemote(newState);
        } else {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "not authorized to send state");
        }
    }

    public static enum DistributionInfo {
        NORMAL,
        STOPPING,
        FINISHED;

    }
}

