/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RequestConsigne {
    private List<Request> _requests;
    private InfoPeerJXTA _client;

    public RequestConsigne(InfoPeerJXTA client) {
        this._client = client;
    }

    public void addRequest(Request req) {
        ReqState state;
        if (this._requests == null) {
            this._requests = new LinkedList<Request>();
        }
        if (ReqAutomatonServer.isErrorState(state = req.getState()) || state == ReqState.COMPUTE_FINISHED || state == ReqState.RESULTS_TRANSFERT_ERROR) {
            Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.msgFormat("DISTRIBUTION_ADD_IN_CONSIGNE", req.getAllID(), this._client.getName()));
            this._requests.add(req);
        } else {
            Loggeur.log(this.getClass(), Loggeur.FATAL, "Request in consigne must have the status : " + ReqState.RESULTS_TRANSFERT_ERROR.name());
        }
    }

    public Request getRequest(String ID2) {
        if (this._requests == null) {
            return null;
        }
        for (Request req : this._requests) {
            if (!req.getID().equals(ID2)) continue;
            return req;
        }
        return null;
    }

    public List<Request> flush() {
        if (this._requests == null) {
            return new ArrayList<Request>();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ResJXTA.msgFormat("DISTRIBUTION_FLUSH_CONSIGNE", this._client.getName()));
        sb.append("\n -> ");
        for (Request req : this._requests) {
            sb.append(req.getShortNumber());
            sb.append(" ");
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
        List<Request> list = this._requests;
        this._requests = null;
        return list;
    }
}

