/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class RequestStock {
    protected LinkedList<Request> _requests = new LinkedList();

    public Request getRequest(String reqID) {
        for (Request req : this._requests) {
            if (!req.getID().equals(reqID)) continue;
            return req;
        }
        return null;
    }

    public synchronized ArrayList<Request> getCopy() {
        ArrayList<Request> copy = new ArrayList<Request>();
        Iterator it = this._requests.iterator();
        while (it.hasNext()) {
            copy.add((Request)it.next());
        }
        return copy;
    }

    public synchronized void addRequest(Request request) {
        Request req = this.getRequest(request.getID());
        if (req != null) {
            this.removeRequest(req);
        }
        this._requests.add(request);
    }

    public synchronized void removeRequest(Request req) {
        this._requests.remove(req);
        StringBuffer sb = new StringBuffer();
        sb.append(req.getID());
        sb.append(" (");
        sb.append("HISTO");
        sb.append(")");
        sb.append("\n");
        sb.append(req.getHisto().toString());
        Loggeur.log(this.getClass(), Loggeur.INFO, sb.toString());
    }

    public synchronized Request getNextRequest(ReqState state) {
        Request req2 = null;
        for (Request req2 : this._requests) {
            if (req2.getState() != state) continue;
            return req2;
        }
        return null;
    }

    public synchronized Request getNextRequestToCompute() {
        Request reqToCompute = null;
        Request req2 = null;
        for (Request req2 : this._requests) {
            if (req2.getState() != ReqState.WAIT_COMPUTING) continue;
            if (reqToCompute == null) {
                reqToCompute = req2;
                continue;
            }
            if (req2.getPriority() <= reqToCompute.getPriority()) continue;
            reqToCompute = req2;
        }
        return reqToCompute;
    }

    public synchronized Request getNextRequest() {
        if (this._requests.size() > 0) {
            return this._requests.get(0);
        }
        return null;
    }

    public synchronized Request getNextRequestToRedistribute(String serverID) {
        Request req2 = null;
        for (Request req2 : this._requests) {
            boolean c3;
            boolean c1 = req2.getState() == ReqState.WAIT_COMPUTING;
            boolean c2 = !req2.getServerID().equals(serverID);
            boolean bl = c3 = !req2.isRedistributed();
            if (!c1 || !c2 || !c3) continue;
            return req2;
        }
        return null;
    }

    public synchronized int getNbOfRequest(ReqState state) {
        Request req = null;
        Iterator it = this._requests.iterator();
        int i = 0;
        while (it.hasNext()) {
            req = (Request)it.next();
            if (req.getState() != state) continue;
            ++i;
        }
        return i;
    }

    public int size() {
        return this._requests.size();
    }

    public Request get(int index) {
        try {
            return this._requests.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

