/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.test;

import com.dassault.cecilia.lib.distrib.request.Command;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.test.TestJXTAClient;
import com.dassault.cecilia.lib.distrib.test.TestRessources;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class TestClientAralia
extends TestJXTAClient {
    protected int count = 0;

    @Test
    public void testCeciliaBDD() {
        Request req = this.createCeciliaBDDRequest();
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
    }

    public Request createCeciliaBDDRequest() {
        File fileMCS;
        File filePr = new File(".\\CeciliaBDD_Prb_" + this.count + ".res");
        if (filePr.exists()) {
            Assert.assertTrue((boolean)filePr.delete());
        }
        if ((fileMCS = new File(".\\CeciliaBDD_MCS_" + this.count + ".res")).exists()) {
            Assert.assertTrue((boolean)fileMCS.delete());
        }
        Request req = this._client.getNewRequest();
        req.setEngine("CECILIABDD");
        File inputFile = TestRessources.getRessource("Calcul-CeciliaBDD.dag");
        String inputUniqueName = this._client.makeUniqueFileID(inputFile.getAbsolutePath(), false);
        req.addNeededFile(inputUniqueName);
        Command command = this._client.getCommandWriter(req);
        command.append("compute BDD to good-BDD 'ESSAI'; \n");
        command.append("compute ZQC from good-BDD to good-ZQC 'ESSAI'; \n");
        command.append("compute Pr from good-BDD * > \"");
        command.addOutputFile(filePr);
        command.append("\"; \n");
        command.append("display products good-ZQC 'ESSAI' > \"");
        command.addOutputFile(fileMCS);
        command.append("\"; \n");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        ++this.count;
        return req;
    }

    @Test
    public void testAralia2() {
        Request req = this.createAralia2();
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
    }

    public Request createAralia2() {
        File fileMCS;
        File filePr = new File(".\\Aralia2_Prb_" + this.count + ".res");
        if (filePr.exists()) {
            Assert.assertTrue((boolean)filePr.delete());
        }
        if ((fileMCS = new File(".\\Aralia2_MCS_" + this.count + ".res")).exists()) {
            Assert.assertTrue((boolean)fileMCS.delete());
        }
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("Calcul-Aralia.dag"));
        command.append("\";");
        command.append("\n");
        command.append("compute BDD 'ESSAI';");
        command.append("\n");
        command.append("compute q-cuts 'ESSAI';");
        command.append("\n");
        command.append("compute probability * at 1.000E00>");
        command.append("\"");
        command.addOutputFile(filePr);
        command.append("\";");
        command.append("\n");
        command.append("display products q-cuts 'ESSAI' {compute at 1.000E00 sort literals $< :>name sort products < :>order display :> probability}>");
        command.append("\"");
        command.addOutputFile(fileMCS);
        command.append("\";");
        command.append("\n");
        command.append("exit;");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        ++this.count;
        return req;
    }

    @Test
    public void testAralia4() {
        File fileMCS;
        File filePr = new File(".\\Aralia4_Prb_" + this.count + ".res");
        if (filePr.exists()) {
            Assert.assertTrue((boolean)filePr.delete());
        }
        if ((fileMCS = new File(".\\Aralia4_MCS_" + this.count + ".res")).exists()) {
            Assert.assertTrue((boolean)fileMCS.delete());
        }
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("Calcul-Aralia.dag"));
        command.append("\";\n");
        command.append("timer new Temps;\n");
        command.append("timer reset Temps;\n");
        command.append("timer start Temps;\n");
        command.append("compute ZQC to good-ZQC 'ESSAI';\n");
        command.append("timer stop Temps;\n");
        command.append("timer print Temps;\n");
        command.append("compute BDD to good-BDD *;\n");
        command.append("compute Pr from good-BDD * at 1.000E00> \"");
        command.addOutputFile(filePr);
        command.append("\";\n");
        command.append("compute SoP from good-ZQC to good-SoP 'ESSAI';\n");
        command.append("sort literals < :>name good-SoP 'ESSAI';\n");
        command.append("sort products < :>name good-SoP 'ESSAI';\n");
        command.append("sort products < :>order good-SoP 'ESSAI';\n");
        command.append("display products good-SoP 'ESSAI' {compute at 1 display :>Pr(1)} > \"");
        command.addOutputFile(fileMCS);
        command.append("\";\n");
        command.append("timer stop Temps;\n");
        command.append("exit;\n");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
    }

    @Test
    public void testAralia4Mem() {
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("memory.dag"));
        command.append("\";\n");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(TOO_MANY_ERROR_DIRECT));
    }

    @Test
    public void testAralia4MemLowStart() {
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("memory_lowstart.dag"));
        command.append("\";\n");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(TOO_MANY_ERROR_DIRECT));
    }

    @Test
    public void testAralia4Time() {
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("time.dag"));
        command.append("\";\n");
        command.append("display products ZQC roots(*) > ");
        command.addOutputFile(new File(".\\Time.res"));
        command.append("\";\n");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        this._client.addRequestToStock(req);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(TOO_MANY_ERROR_DIRECT));
    }

    @Test
    public void testAraliaDiffuse() {
        File dag = TestRessources.getRessource("Calcul-Aralia.dag");
        String nameOfcalcul14578 = this._client.makeUniqueFileID(dag.getAbsolutePath(), true);
        this._client.diffuseFile(dag, nameOfcalcul14578);
        Request[] reqs = new Request[10];
        int i = 0;
        while (i < 10) {
            Request req0;
            reqs[i] = req0 = this._client.getNewRequest();
            req0.setEngine("ARALIA");
            Command command = this._client.getCommandWriter(req0);
            command.append("load \"");
            command.append(nameOfcalcul14578);
            command.append("\";");
            command.append("\n");
            command.append("compute q-cuts 'ESSAI';");
            command.append("\n");
            command.append("compute probability * at 1.000E00>");
            command.append("\"");
            command.addOutputFile(new File(".\\probabilityDiffuse.res"));
            command.append("\";");
            command.append("\n");
            command.append("display products q-cuts 'ESSAI' {compute at 1.000E00 sort literals $< :>name sort products < :>order display :> probability}>");
            command.append("\"");
            command.addOutputFile(new File(".\\coupesDiffuse.dat"));
            command.append("\";");
            command.append("\n");
            command.append("exit;");
            req0.setCmdFileName(command.getFileName());
            req0.setParsed(true);
            this._client.addRequestToStock(req0);
            ++i;
        }
        this.waitEmptyStock();
        this._client.removeDiffusedFiles(nameOfcalcul14578);
        i = 0;
        while (i < 10) {
            Assert.assertTrue((String)reqs[i].getHistoString(this._client.getPeerJXTA()), (boolean)reqs[i].getHisto().compareToList(GOOD_LIST));
            ++i;
        }
    }

    @Override
    public void waitEmptyStock() {
        this._client.waitEmptyStock();
    }

    @Override
    public void waitEmptyTrash() {
        this._client.waitEmptyTrash();
    }
}

