/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.xmlutility;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLUtility
extends DefaultHandler {
    protected Locator _locator;
    protected Map<String, String> _attMap = new HashMap<String, String>();
    protected String _curEntity;
    protected InputSource source;
    protected String _keyEntity;
    protected String _keyAttribute;
    protected String _foundAttribute;
    protected String _characters;
    protected StringBuffer _charactersBuffer;
    protected boolean _found;
    protected boolean _searchingForAttribut;

    public XMLUtility(InputSource XMLFile) {
        this._locator = new LocatorImpl();
        this.source = XMLFile;
        this._found = false;
        this._charactersBuffer = new StringBuffer();
    }

    public String findAttribute(String entity, String att) {
        this._keyEntity = entity;
        this._keyAttribute = att;
        this._foundAttribute = null;
        this._searchingForAttribut = true;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser secondParser = factory.newSAXParser();
            secondParser.parse(this.source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        return this._foundAttribute;
    }

    public String findCharacters(String entity) {
        this._keyEntity = entity;
        this._found = false;
        this._searchingForAttribut = false;
        this._charactersBuffer = new StringBuffer();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser secondParser = factory.newSAXParser();
            secondParser.parse(this.source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        return this._characters;
    }

    public Map findEntity(String entity) {
        this._keyEntity = entity;
        this._found = false;
        this._searchingForAttribut = true;
        this._charactersBuffer = new StringBuffer();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser secondParser = factory.newSAXParser();
            secondParser.parse(this.source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXParseException ioe) {
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        return this._attMap;
    }

    public boolean hasEntity(String entity) {
        this._keyEntity = entity;
        this._found = false;
        this._searchingForAttribut = false;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        return this._found;
    }

    @Override
    public void setDocumentLocator(Locator value) {
        this._locator = value;
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        this._curEntity = localName;
        if ("".equals(this._curEntity)) {
            this._curEntity = rawName;
        }
        if (this._curEntity.equals(this._keyEntity)) {
            this._found = true;
            if (this._searchingForAttribut) {
                this._attMap = this.createAttributsMap(attributs);
                if (this._attMap.get(this._keyAttribute) != null) {
                    this._foundAttribute = this._attMap.get(this._keyAttribute).toString();
                }
            }
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        this._curEntity = localName;
        if ("".equals(this._curEntity)) {
            this._curEntity = rawName;
        }
        if (this._curEntity.equals(this._keyEntity)) {
            this._characters = this._charactersBuffer.toString();
            this._attMap.put("@Char", this._characters);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._found) {
            this._charactersBuffer.append(new String(ch, start, length));
        }
    }

    public static void main(String[] args) {
    }

    protected String createRealName(String localName, String rawName) {
        if (localName.length() > 0) {
            return localName;
        }
        return rawName;
    }

    protected Map<String, String> createAttributsMap(Attributes attributs) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        while (index < attributs.getLength()) {
            String att = attributs.getLocalName(index);
            if (att.length() == 0) {
                att = attributs.getQName(index);
            }
            map.put(att, attributs.getValue(index));
            ++index;
        }
        return map;
    }
}

