/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.translator.PluginSimulTranslator;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PluginStepperTranslator
extends PluginSimulTranslator
implements PluginMStepper {
    public static final String PROP_STEPPER_TRANSLATE_FORCELOAD = "cecilia.mbsa.plugin.translator.StepperForceLoad";
    StepperOptsPanel _opts = null;
    private static String _KEY_STEPPER = "T.Flatness";

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_STEPPER_TRANS_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTrans.getString("PLUG_STEPPER_TRANS_DESC");
        }
        if (key.equals("type")) {
            return "PluginStepper";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A1-02.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new StepperOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    protected String getNameOfBanScript() {
        if (Boolean.getBoolean(PROP_STEPPER_TRANSLATE_FORCELOAD)) {
            return "BanScriptStepperTest.xml";
        }
        return "BanScriptStepper.xml";
    }

    protected String getKeyStepper() {
        return _KEY_STEPPER;
    }

    protected boolean generateControlOptions(Plugable launcher, StringBuffer optionsGenerate, StringBuffer optionsControl) {
        String verify;
        if (TranslateOptions.withTranslateCCF(launcher)) {
            optionsGenerate.append("TranslateWithCCF");
        }
        if (TranslateOptions.withDataFlowVerify(launcher)) {
            optionsControl.append("DataFlowWithSimul");
        }
        if ((verify = TranslateOptions.listVerifyBefore(launcher, 2)).length() > 0) {
            if (optionsControl.length() > 0) {
                optionsControl.append(",");
            }
            optionsControl.append(verify);
        }
        if ((verify = TranslateOptions.listVerifyAfter(launcher, 2)).length() > 0) {
            if (optionsControl.length() > 0) {
                optionsControl.append(",");
            }
            optionsControl.append(verify);
        }
        return true;
    }

    protected static Collection<String> convertCollection(String options, Collection<String> results) {
        if (options == null) {
            return results;
        }
        StringTokenizer st = new StringTokenizer(options, ", ");
        while (st.hasMoreTokens()) {
            results.add(st.nextToken());
        }
        return results;
    }

    protected boolean checkGenerateOptions(String compilOptions, String currentOptions) {
        Collection<String> currentStrings;
        Collection<String> compilStrings = PluginStepperTranslator.convertCollection(compilOptions, new TreeSet<String>());
        boolean result = compilStrings.equals(currentStrings = PluginStepperTranslator.convertCollection(currentOptions, new TreeSet<String>()));
        if (!result) {
            ResTrans.LOG.finer("Compil stepper don't compatible with current generate preference: " + compilOptions);
        }
        return result;
    }

    protected boolean checkVerifyOptions(String compilOptions, String currentOptions) {
        Collection<String> compilStrings = PluginStepperTranslator.convertCollection(compilOptions, new HashSet<String>());
        Collection<String> currentStrings = PluginStepperTranslator.convertCollection(currentOptions, new HashSet<String>());
        for (String curOpt : currentStrings) {
            if (compilStrings.contains(curOpt)) continue;
            ResTrans.LOG.finer("Compil stepper don't compatible with current verify preference: " + curOpt);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stepper createStepper(Plugable launcher, Object parameters) {
        try {
            ResTrans.LOG.finer("[PluginTranslatorStepper.createStepper] Start " + Integer.toHexString(super.hashCode()));
            if (parameters instanceof AbstractPluginWithStepper.InfoStepper) {
                InfoDatum idatum;
                AbstractPluginWithStepper.InfoStepper iStepper = (AbstractPluginWithStepper.InfoStepper)parameters;
                String keyDatum = "Stepper." + this.getKeyStepper();
                String strConfig = iStepper.getModel().getConfig();
                if (strConfig != null && !strConfig.isEmpty()) {
                    keyDatum = keyDatum + "@" + strConfig;
                }
                if ((idatum = launcher.getDatum(keyDatum)) != null) {
                    Stepper stepper = this.createStepper(launcher, idatum, (Object)iStepper.getParameters());
                    return stepper;
                }
            } else {
                InfoDatum idatum = launcher.getDatum("Stepper." + this.getKeyStepper());
                if (idatum != null) {
                    Stepper stepper = this.createStepper(launcher, idatum, parameters);
                    return stepper;
                }
            }
            Stepper stepper = null;
            return stepper;
        }
        finally {
            ResTrans.LOG.finer("[PluginTranslatorStepper.createStepper] End " + Integer.toHexString(super.hashCode()));
        }
    }

    private Stepper createStepper(Plugable launcher, IModel model, Object parameters) {
        File compilFile = this.createCompilFile(launcher);
        if (compilFile == null) {
            return null;
        }
        BanEntry ban = this.executeBanCreateStepper(launcher, model, compilFile, parameters);
        if (ban == null) {
            return null;
        }
        return (Stepper)ban.getIdObject("stepper-id");
    }

    private Stepper createStepper(Plugable launcher, InfoDatum idatum, Object parameters) {
        Stepper result = null;
        if (idatum.getModel() == null) {
            return null;
        }
        StringBuffer optionsGenerate = new StringBuffer();
        StringBuffer optionsControl = new StringBuffer();
        boolean saveCompiledSimul = this.generateControlOptions(launcher, optionsGenerate, optionsControl);
        File compilFile = (File)idatum.getInputFiles().get("compil.zip");
        if (compilFile != null && compilFile.exists()) {
            if (this.checkGenerateOptions((String)idatum.getParameters().get("simul.options.generate"), optionsGenerate.toString()) && this.checkVerifyOptions((String)idatum.getParameters().get("simul.options.verify"), optionsControl.toString())) {
                result = this.createCompiledStepper(launcher, compilFile, parameters, idatum.getModel());
            }
            if (result == null) {
                compilFile.delete();
                compilFile = null;
            }
        } else {
            ResTrans.LOG.finer("No compil file into idatum");
        }
        if (result == null) {
            if (launcher.getAppl().isReader()) {
                JOptionCecilia.showMessageDialog((Component)launcher.getWindow(), (String)ResTrans.getString("READER_ERR_DATA"), (String)this.getInfo("plugin.name"), (int)0);
                return null;
            }
            if (!this.findPrerequisites(launcher)) {
                return null;
            }
            compilFile = this.createCompilFile(launcher);
            if (compilFile == null) {
                return null;
            }
            BanEntry ban = this.executeBanCreateStepper(launcher, idatum.getModel(), compilFile, parameters);
            if (ban == null) {
                return null;
            }
            if (compilFile.exists() && saveCompiledSimul) {
                InfoDatum iCompute = idatum.createCopy();
                iCompute.getInputFiles().put("compil.zip", compilFile);
                iCompute.getParameters().put("simul.options.generate", optionsGenerate.toString());
                iCompute.getParameters().put("simul.options.verify", optionsControl.toString());
                launcher.setDatum(iCompute, launcher);
            }
            result = (Stepper)ban.getIdObject("stepper-id");
        }
        return result;
    }

    protected boolean findPrerequisites(Plugable launcher) {
        return true;
    }

    private File createCompilFile(Plugable launcher) {
        File compilFile = null;
        try {
            compilFile = File.createTempFile("SimulTrans", ".zip");
            compilFile.deleteOnExit();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResTrans.getString("ERR_TMP_FILE"), ResTrans.getString("DEF_TITLE"), 0);
            return null;
        }
        return compilFile;
    }

    private BanEntry executeBanCreateStepper(Plugable launcher, IModel model, File compilFile, Object parameters) {
        File inputFile = model.getFile();
        if (inputFile == null || !inputFile.exists()) {
            return null;
        }
        BanEntry ban = this.banExecute(launcher, null, new Object[]{model, compilFile, parameters});
        return ban;
    }

    protected void prepareBanEntry(Plugable launcher, Object ... objects) {
        this.prepareCompilBanEntry(launcher, (IModel)objects[0], (File)objects[1], objects[2]);
    }

    protected void catchBanException(Plugable launcher, BanProcessException e, Object ... objects) {
        this.catchProcessBanException(launcher, e, (IModel)objects[0]);
    }

    class StepperOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlDeterminist;
        JCheckBox _ctrlConflict;
        JComboBox _ctrlChangeMax;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlDeterminist.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)PluginSimulTranslator.OPT_DETERMINIST, (boolean)false));
            this._ctrlConflict.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)PluginSimulTranslator.OPT_EXC_CONFLICT, (boolean)false));
            this._ctrlChangeMax.setSelectedItem(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)PluginSimulTranslator.OPT_FIXPOINT_LOOP_MAX, (String)"5"));
        }

        public StepperOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResTrans.getString("DLG_OPT_STEPPER")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this._ctrlDeterminist = new JCheckBox(ResTrans.getString("DLG_OPT_STEPPER_DETERMINIST"));
            this._ctrlDeterminist.setHorizontalTextPosition(2);
            this._ctrlDeterminist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_DETERMINIST, StepperOptsPanel.this._ctrlDeterminist.isSelected() ? "true" : "false");
                }
            });
            root.add((Component)this._ctrlDeterminist, new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlConflict = new JCheckBox(ResTrans.getString("DLG_OPT_STEPPER_CONFLICT"));
            this._ctrlConflict.setHorizontalTextPosition(2);
            this._ctrlConflict.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_EXC_CONFLICT, StepperOptsPanel.this._ctrlConflict.isSelected() ? "true" : "false");
                }
            });
            root.add((Component)this._ctrlConflict, new GridBagConstraints(0, 1, 2, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JCRLabel lbl = new JCRLabel(ResTrans.getString("DLG_OPT_STEPPER_LOOPMAX"));
            root.add((Component)lbl, new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlChangeMax = new JComboBox<String>(new String[]{"3", "5", "10", "20"});
            this._ctrlChangeMax.setEditable(true);
            this._ctrlChangeMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chgMax = StepperOptsPanel.this._ctrlChangeMax.getSelectedItem().toString();
                    try {
                        int val = Integer.parseInt(chgMax);
                        if (val > 0 && val < 1000) {
                            StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_FIXPOINT_LOOP_MAX, chgMax);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)StepperOptsPanel.this), ResTrans.getString("DLG_OPT_STEPPER_LOOPMAX_ERR"), ResTrans.getString("DLG_OPT_STEPPER"), 0);
                    StepperOptsPanel.this._ctrlChangeMax.requestFocus();
                }
            });
            root.add((Component)this._ctrlChangeMax, new GridBagConstraints(1, 2, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            JButton defVal = new JButton(ResTrans.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepperOptsPanel.this._ctrlDeterminist.setSelected(true);
                    StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_DETERMINIST, "true");
                    StepperOptsPanel.this._ctrlConflict.setSelected(true);
                    StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_EXC_CONFLICT, "true");
                    StepperOptsPanel.this._ctrlChangeMax.setSelectedItem("5");
                    StepperOptsPanel.this._launcher.setOption(PluginSimulTranslator.OPT_FIXPOINT_LOOP_MAX, "5");
                }
            });
            root.add((Component)defVal, new GridBagConstraints(1, 3, 1, 1, 100.0, 100.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginStepperTranslator.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

