/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.txtsimul;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.SortFilterModel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableModelTransitionStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableModelVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererTrDelay;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererTrInfo;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.txtsimul.DlgAbout;
import com.dassault.cecilia.plugin.mbsa.txtsimul.ResSimul;
import com.dassault.cecilia.plugin.mbsa.txtsimul.SimulStepper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PanelSimul
extends JPanel
implements PlugPanel,
ViewListener {
    private JSplitPane _splitPanel;
    private JTable _trTable;
    private JTable _stTable;
    private JTable _flTable;
    private JLabel _loopTxt;
    private JLabel _timeTxt;
    private AbstractAction _initAction;
    private AbstractAction _nextAction;
    private AbstractAction _prevAction;
    private AbstractAction _shedulerAction;
    private AbstractAction _optAction;
    private SimulStepper _stepper = new SimulStepper();
    private ViewTransition _selectedTr = null;
    private Window _owner = null;

    public PanelSimul(Stepper stepper) throws StepperException {
        super(new BorderLayout());
        this._stepper.setParentComponent(this);
        this.initialize();
        this._stepper.open(stepper);
        this._initAction.setEnabled(true);
        this._shedulerAction.setEnabled(true);
        this._optAction.setEnabled(true);
    }

    public void trash() {
        this._stepper.close();
        this._stepper = null;
        System.gc();
    }

    protected Window getOwner() {
        if (this._owner == null) {
            this._owner = SwingUtilities.getWindowAncestor(this);
        }
        return this._owner;
    }

    public void setSelectTransition(ViewTransition tr) {
        this._selectedTr = tr;
        this._nextAction.setEnabled(this._selectedTr != null && this._selectedTr.isValid());
    }

    public void goForward() {
        if (!this._stepper.isConnected()) {
            return;
        }
        if (this._selectedTr == null) {
            return;
        }
        if (!this._selectedTr.isValid()) {
            return;
        }
        this.goForward(this._selectedTr);
    }

    public void goForward(ViewTransition tr) {
        this._stepper.goForward(tr);
    }

    public void altaModelChanged(ViewStepper acastep) {
    }

    public void altaTransitionUpdate(ViewTransition tr) {
    }

    public void altaStateUpdate(ViewVariable state) {
    }

    public void altaFlowUpdate(ViewVariable flow) {
    }

    public void altaOtherUpdate(int type, Object data) {
        switch (type) {
            case 2: {
                this._loopTxt.setText((String)data);
                break;
            }
            case 1: {
                this._timeTxt.setText((String)data);
                break;
            }
            case 3: {
                this._prevAction.setEnabled((Integer)data > 0);
            }
        }
    }

    protected void initialize() {
        this._stepper.addAltaListener(this);
        this._initAction = new AbstractAction(ResSimul.getString("PAN_STEP_RESET"), ResIcoAbstract.getIconRes((URL)this.getClass().getResource("Simul-03.svg"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelSimul.this._stepper.goInitialState();
            }
        };
        this._initAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_RESET"));
        this._initAction.setEnabled(false);
        this._nextAction = new AbstractAction(ResSimul.getString("PAN_STEP_FORWARD"), ResIcoAbstract.getIconRes((URL)this.getClass().getResource("Simul-05.svg"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSimul.this.goForward();
            }
        };
        this._nextAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_FORWARD"));
        this._nextAction.setEnabled(false);
        this._prevAction = new AbstractAction(ResSimul.getString("PAN_STEP_BACKWARD"), ResIcoAbstract.getIconRes((URL)this.getClass().getResource("Simul-04.svg"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSimul.this._stepper.goBackward(1);
            }
        };
        this._prevAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_BACKWARD"));
        this._prevAction.setEnabled(false);
        this._shedulerAction = new AbstractAction(ResSimul.getString("PAN_STEP_SHEDULER"), ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A4-02.svg"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSimul.this._stepper.shedulerViewer(PanelSimul.this.getOwner());
            }
        };
        this._shedulerAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_SHEDULER"));
        this._shedulerAction.setEnabled(false);
        this._optAction = new AbstractAction(ResSimul.getString("PAN_STEP_OPTIONS"), ResIcoCore.getImageIcon((String)"PREF_OPTIONS")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSimul.this._stepper.changeOption(PanelSimul.this.getOwner(), true);
            }
        };
        this._optAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_OPTIONS"));
        this._optAction.setEnabled(false);
        AbstractAction aboutAction = new AbstractAction(ResSimul.getString("PAN_STEP_ABOUT"), ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-06.svg"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgAbout dlg = new DlgAbout(PanelSimul.this.getOwner());
                dlg.setVisible(true);
            }
        };
        aboutAction.putValue("ShortDescription", ResSimul.getString("PAN_STEP_ABOUT"));
        JToolBar box = new JToolBar();
        box.add(this._initAction);
        box.addSeparator();
        box.add(this._prevAction);
        box.add(this._nextAction);
        box.addSeparator();
        box.add(this._shedulerAction);
        box.add(this._optAction);
        box.add(Box.createGlue());
        box.add(aboutAction);
        box.setFloatable(false);
        this.add((Component)box, "North");
        JPanel trPanel = new JPanel();
        trPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResSimul.getString("PAN_STEP_TRANSS")));
        trPanel.setLayout(new BorderLayout());
        TableModelTransitionStepper trModel = new TableModelTransitionStepper();
        this._stepper.addAltaListener((ViewListener)trModel);
        SortFilterModel sortTrModel = new SortFilterModel((TableModel)trModel);
        this._trTable = new JTable((TableModel)sortTrModel);
        sortTrModel.connectTable(this._trTable);
        this._trTable.setDefaultRenderer(String.class, (TableCellRenderer)new TableRendererTrInfo(false));
        this._trTable.setDefaultRenderer(Double.class, (TableCellRenderer)new TableRendererTrDelay(false));
        this._trTable.getColumnModel().getColumn(0).setMaxWidth(10);
        trPanel.add((Component)new JScrollPane(this._trTable), "Center");
        this._trTable.getSelectionModel().setSelectionMode(0);
        this._trTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                ViewTransition tr = null;
                if (!lsm.isSelectionEmpty()) {
                    tr = (ViewTransition)PanelSimul.this._trTable.getValueAt(lsm.getMinSelectionIndex(), -1);
                }
                PanelSimul.this.setSelectTransition(tr);
            }
        });
        this._trTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    PanelSimul.this.goForward();
                }
            }
        });
        this._trTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                PanelSimul.this.goForward();
            }
        });
        JPanel stPanel = new JPanel();
        stPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResSimul.getString("PAN_STEP_STATES")));
        stPanel.setLayout(new BorderLayout());
        TableModelVariable stModel = new TableModelVariable(2);
        this._stepper.addAltaListener((ViewListener)stModel);
        SortFilterModel sortStModel = new SortFilterModel((TableModel)stModel);
        this._stTable = new JTable((TableModel)sortStModel);
        sortStModel.connectTable(this._stTable);
        this._stTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        stPanel.add((Component)new JScrollPane(this._stTable), "Center");
        JPanel flPanel = new JPanel();
        flPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResSimul.getString("PAN_STEP_FLOWS")));
        flPanel.setLayout(new BorderLayout());
        TableModelVariable flModel = new TableModelVariable(1);
        this._stepper.addAltaListener((ViewListener)flModel);
        SortFilterModel sortFlModel = new SortFilterModel((TableModel)flModel);
        this._flTable = new JTable((TableModel)sortFlModel);
        sortFlModel.connectTable(this._flTable);
        this._flTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        flPanel.add((Component)new JScrollPane(this._flTable), "Center");
        JPanel varPanel = new JPanel();
        varPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        varPanel.setLayout(new GridLayout(1, 2, 5, 5));
        varPanel.add(stPanel);
        varPanel.add(flPanel);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tmpPanel.setLayout(new GridLayout(1, 1, 5, 5));
        tmpPanel.add(trPanel);
        this._splitPanel = new JSplitPane(1, tmpPanel, varPanel);
        this._splitPanel.setResizeWeight(0.4);
        this.add((Component)this._splitPanel, "Center");
        JPanel infoPanel = new JPanel();
        this._loopTxt = new JLabel(ResMsgCore.msgFormat((String)"PAN_STEP_CYCLE", (Object[])new Object[]{"???"}));
        infoPanel.add(this._loopTxt);
        this._timeTxt = new JLabel(ResMsgCore.msgFormat((String)"PAN_STEP_TIME", (Object[])new Object[]{"???"}));
        infoPanel.add(this._timeTxt);
        this.add((Component)infoPanel, "South");
    }

    public Component getPanel() {
        return this;
    }

    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return ResSimul.getString("PAN_STEP_TITLE");
        }
        if (key.equals("ppanel.default.width")) {
            return "800";
        }
        if (key.equals("ppanel.default.height")) {
            return "500";
        }
        return null;
    }

    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-06.svg"));
        }
        return null;
    }
}

