/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.examples;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.io.File;
import java.io.InputStream;

public class BanCreateJStepper {
    public static final String _ID_STEPPER = "BanCreateJStepper.IDStepper";

    public static Stepper createStepper(File jarFile) throws BanLicenseException {
        BanEntry ban = new BanEntry();
        ban.setUserProperty("jstepper.input.jar", jarFile.getAbsolutePath());
        ban.setUserProperty("jstepper.output.id", _ID_STEPPER);
        InputStream inputStream = BanCreateJStepper.class.getResourceAsStream("BanCreateJStepper.xml");
        BanInputStream banStream = new BanInputStream(inputStream, "BanCreateJStepper.xml");
        try {
            ban.execute(banStream);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (BanProcessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BanProcessException(e);
        }
        catch (Error e) {
            throw new BanProcessException(e);
        }
        Object result = ban.getIdObject(_ID_STEPPER);
        if (result != null && !(result instanceof Stepper)) {
            throw new BanProcessException("BanCreateJStepper : Result is not a Stepper");
        }
        return (Stepper)result;
    }

    private static void printStepper(Stepper stepper) throws StepperException {
        int i;
        if (!stepper.goInitialState()) {
            System.out.println("No initial state - stop print stepper");
            return;
        }
        int nbr = stepper.getNbrState();
        System.out.println("Number state : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("St" + i + "\t" + stepper.getNameOfState(i) + "\t" + stepper.getValueStringOfState(i));
        }
        nbr = stepper.getNbrFlow();
        System.out.println("Number flow : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("Fl" + i + "\t" + stepper.getNameOfFlow(i) + "\t" + stepper.getValueStringOfFlow(i));
        }
        nbr = stepper.getNbrTransition();
        System.out.println("Number Transition : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("Tr" + i + "\t" + stepper.getNameOfTransition(i) + "\t" + stepper.isValidTransition(i) + "\t" + stepper.getDescOfTransition(i));
        }
    }

    private static int Main(String[] args) {
        if (args.length < 1) {
            System.err.println("BanCreateJStepper : syntax launch error");
            return 1;
        }
        File jarFile = new File(args[0]);
        if (!(jarFile.exists() && jarFile.isFile() && jarFile.canRead())) {
            System.err.println("BanCreateJStepper : jarFile file error");
            return 1;
        }
        Stepper stepper = null;
        try {
            stepper = BanCreateJStepper.createStepper(jarFile);
        }
        catch (BanLicenseException e) {
            System.err.println("BanCreateJStepper : License exception\n[" + e.getMessage() + "]");
            return 2;
        }
        catch (BanProcessException e) {
            System.err.println("BanCreateJStepper : process exception\n[" + e.getMessage() + "]");
            return 3;
        }
        if (stepper == null) {
            return 4;
        }
        try {
            BanCreateJStepper.printStepper(stepper);
        }
        catch (StepperException e) {
            System.err.println("BanCreateJStepper : print exception\n[" + e.getMessage() + "]");
            return 5;
        }
        return 0;
    }

    public static void main(String[] args) {
        int result = BanCreateJStepper.Main(args);
        System.gc();
        System.exit(result);
    }
}

