/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.examples;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.examples.BanUseExample;
import java.awt.FlowLayout;
import java.io.File;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class BanProgressUseExample
extends BanUseExample {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int Main(String[] args) {
        if (args.length < 1) {
            System.err.println("BanUseExample : syntax launch error");
            return 2;
        }
        File script = new File(args[0]);
        if (!(script.exists() && script.isFile() && script.canRead())) {
            System.err.println("BanUseExample : script file error");
            return 2;
        }
        BanEntry ban = null;
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            System.err.println("BanUseExample : License exception\n[" + e.getMessage() + "]");
            return 5;
        }
        int result = BanProgressUseExample.readArgs(ban, args);
        if (result != 0) {
            return result;
        }
        class ProgressFrame
        extends JFrame {
            JProgressBar _bar = new JProgressBar(0, 0, 1000);

            ProgressFrame() {
                super("Suivi du process Ban");
                this.getRootPane().setLayout(new FlowLayout());
                this.getRootPane().add(this._bar);
                this.pack();
                this.setLocationRelativeTo(null);
            }
        }
        ProgressFrame frm = new ProgressFrame();
        frm.setVisible(true);
        class BanExecute
        implements Runnable {
            BanEntry _ban;
            File _script;
            int _result;

            BanExecute(BanEntry lban, File lscript) {
                this._ban = lban;
                this._script = lscript;
                this._result = 0;
            }

            @Override
            public void run() {
                try {
                    this._ban.execute(this._script);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("BanUseExample : No Error");
                }
                catch (BanProcessException e) {
                    System.err.println("BanUseExample : process exception\n[" + e.getMessage() + "]");
                    this._result = 1;
                }
                catch (Exception e) {
                    System.err.println("BanUseExample : unknow exception\n[" + e.getMessage() + "]");
                    this._result = 3;
                }
                catch (Error e) {
                    System.err.println("BanUseExample : unknow error\n[" + e.getMessage() + "]");
                    this._result = 3;
                }
            }

            public int getResult() {
                return this._result;
            }
        }
        BanExecute banExec = new BanExecute(ban, script);
        Thread banThread = new Thread((Runnable)banExec, "BanExecute");
        banThread.start();
        try {
            while (banThread.isAlive()) {
                Thread.sleep(250L);
                String p1000 = ban.getInfo("process.p1000");
                if (p1000 == null || p1000.length() <= 0 || p1000.equals("-1")) continue;
                try {
                    int current = Integer.parseInt(p1000);
                    if (current < 0) {
                        current = 0;
                    } else if (current > 1000) {
                        current = 1000;
                    }
                    frm._bar.setValue(current);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
            frm.setVisible(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (banExec.getResult() != 0) {
            return banExec.getResult();
        }
        System.out.println("\nObjects");
        Iterator<String> iter = ban.listIdObject().iterator();
        while (iter.hasNext()) {
            System.out.println("\t=> " + iter.next());
        }
        return 0;
    }

    public static void main(String[] args) {
        int result = BanProgressUseExample.Main(args);
        System.gc();
        System.exit(result);
    }
}

