/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.parser;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.parser.XmlElement;
import com.dassault.cecilia.lib.ban.parser.XmlHandler;
import com.dassault.cecilia.lib.ban.parser.XmlHandlerUnit;
import com.dassault.cecilia.lib.ban.parser.XmlLocator;
import com.dassault.cecilia.lib.ban.parser.XmlRootHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParseHelper {
    private static final XmlHandler __mainHandler = new MainHandler();
    private static final XmlHandler __processHandler = new ProcessHandler();

    public void parse(BanProcess process, File xmlFile) {
        String uri = "file:" + xmlFile.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource input = new InputSource(uri);
        this.parse(process, input);
    }

    public void parse(BanProcess process, InputSource input) {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            fabrique.setNamespaceAware(true);
            XmlRootHandler handler = new XmlRootHandler(__mainHandler, process);
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
            handler = null;
        }
        catch (SAXParseException exc) {
            exc.printStackTrace();
            XmlLocator locator = new XmlLocator(exc.getSystemId(), exc.getLineNumber(), exc.getColumnNumber());
            Exception t = exc.getException();
            if (t instanceof BanProcessException) {
                BanProcessException pe = (BanProcessException)t;
                if (pe.getLocator() == null) {
                    pe.setLocator(locator);
                }
                throw pe;
            }
            if (t == null) {
                t = exc;
            }
            throw new BanProcessException(exc.getMessage(), t, locator);
        }
        catch (SAXException exc) {
            Exception t = exc.getException();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            if (t == null) {
                t = exc;
            }
            throw new BanProcessException(exc.getMessage(), t);
        }
        catch (ParserConfigurationException exc) {
            throw new BanProcessException(exc);
        }
        catch (FileNotFoundException exc) {
            throw new BanProcessException(exc);
        }
        catch (UnsupportedEncodingException exc) {
            throw new BanProcessException("Encoding of project file is invalid.", exc);
        }
        catch (IOException exc) {
            throw new BanProcessException("Error reading project file : " + exc.getMessage(), exc);
        }
    }

    public static class ProcessHandler
    extends XmlHandlerUnit {
        @Override
        public void onStartElement(XmlElement element, XmlRootHandler context) throws SAXParseException {
            String baseDir = null;
            BanProcess process = context.getProcess();
            for (Map.Entry<String, String> attr : element.getAttrs().entrySet()) {
                String key = attr.getKey();
                if (key.equals("name")) {
                    process.setUserProperty("ban.process.name", attr.getValue());
                    process.setIdObject(attr.getValue(), process);
                    process.setProgress(attr.getValue());
                    continue;
                }
                if (key.equals("id")) {
                    process.setIdObject(attr.getValue(), process);
                    continue;
                }
                if (key.equals("basedir")) {
                    baseDir = attr.getValue();
                    continue;
                }
                throw new SAXParseException("Unexpected attribute [" + key + "]", context.getLocator());
            }
            if (baseDir != null) {
                process.setBaseDir(new File(baseDir));
            } else {
                process.setBaseDir(new File("."));
            }
        }
    }

    public static class MainHandler
    extends XmlHandler {
        @Override
        public XmlHandler onStartChild(XmlElement parent, XmlElement child, XmlRootHandler context) throws SAXParseException {
            if (child.getName().equals("process")) {
                child.setBanObject(context.getProcess().getRootUnit());
                return __processHandler;
            }
            throw new SAXParseException("Unexpected element [" + child.getName() + "]", context.getLocator());
        }
    }
}

