/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.type.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PatternSet
extends BanProcessComponent {
    String _includes;
    String _excludes;
    List<Pattern> _includeList = new ArrayList<Pattern>();
    List<Pattern> _excludeList = new ArrayList<Pattern>();

    public void setIncludes(String value) {
        this._includes = value;
    }

    public void setExcludes(String value) {
        this._excludes = value;
    }

    protected boolean convertAttributes() {
        Pattern pattern;
        StringTokenizer st;
        if (this._includes != null) {
            st = new StringTokenizer(this._includes, ", \t\r\n");
            while (st.hasMoreTokens()) {
                pattern = this.createInclude();
                pattern.setProcess(this.getProcess());
                pattern.setName(st.nextToken());
            }
            this._includes = null;
        }
        if (this._excludes != null) {
            st = new StringTokenizer(this._excludes, ", \t\r\n");
            while (st.hasMoreTokens()) {
                pattern = this.createExclude();
                pattern.setProcess(this.getProcess());
                pattern.setName(st.nextToken());
            }
            this._excludes = null;
        }
        return this._includeList.size() + this._excludeList.size() > 0;
    }

    public void endValid() {
        this.convertAttributes();
    }

    public Pattern createInclude() {
        Pattern pattern = new Pattern();
        this._includeList.add(pattern);
        return pattern;
    }

    public Pattern createExclude() {
        Pattern pattern = new Pattern();
        this._excludeList.add(pattern);
        return pattern;
    }

    public void prepare() {
        for (Pattern pattern : this._includeList) {
            pattern.prepare();
        }
        for (Pattern pattern : this._excludeList) {
            pattern.prepare();
        }
    }

    public boolean accept(String path) {
        boolean accept = this._includeList.size() == 0;
        for (Pattern pattern : this._includeList) {
            accept |= pattern.accept(path);
        }
        if (accept) {
            for (Pattern pattern : this._excludeList) {
                accept &= !pattern.accept(path);
            }
        }
        return accept;
    }
}

