/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.files;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.unitdefs.files.Zip;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Jar
extends Zip {
    manifest _manifest;

    public manifest createManifest() {
        if (this._manifest != null) {
            throw new BanProcessException("manifest already define");
        }
        this._manifest = new manifest();
        return this._manifest;
    }

    private void addCreatedBy(StringBuffer sb) {
        sb.append("Created-By: Dassault ");
        sb.append(this.expanse("${ban.version}"));
        sb.append("\n");
    }

    private String constructManifestStream() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Manifest-Version: 1.0\n");
        if (this._manifest != null) {
            this._manifest.appendToManifest(sb);
        } else {
            this.addCreatedBy(sb);
        }
        return sb.toString();
    }

    @Override
    protected void addExternalEntry(ZipOutputStream zout) throws IOException {
        byte[] tmp = new byte[1024];
        ZipEntry ze = new ZipEntry("META-INF/MANIFEST.MF");
        zout.putNextEntry(ze);
        String manifest2 = this.constructManifestStream();
        ByteArrayInputStream sin = new ByteArrayInputStream(manifest2.getBytes());
        BufferedInputStream fin = new BufferedInputStream(sin);
        int size = 0;
        while ((size = fin.read(tmp)) != -1) {
            zout.write(tmp, 0, size);
        }
        fin.close();
        zout.closeEntry();
    }

    public class manifest
    extends BanProcessComponent {
        List<attribute> _attrs = new ArrayList<attribute>();
        List<section> _sections = new ArrayList<section>();

        public attribute createAttribute() {
            attribute result = new attribute();
            this._attrs.add(result);
            return result;
        }

        public section createSection() {
            section result = new section();
            this._sections.add(result);
            return result;
        }

        public void appendToManifest(StringBuffer sb) {
            for (attribute attr : this._attrs) {
                attr.appendToManifest(sb);
            }
            Jar.this.addCreatedBy(sb);
            for (section sect : this._sections) {
                sect.appendToManifest(sb);
            }
        }
    }

    public class section
    extends BanProcessComponent {
        String _name;
        List<attribute> _attrs = new ArrayList<attribute>();

        public void setName(String value) {
            this._name = value;
        }

        public attribute createAttribute() {
            attribute result = new attribute();
            this._attrs.add(result);
            return result;
        }

        public void endValid() {
            if (this._name == null) {
                throw new BanProcessException("Attribute 'name' not define");
            }
            if (this._attrs.size() == 0) {
                throw new BanProcessException("section without attribute");
            }
        }

        public void appendToManifest(StringBuffer sb) {
            sb.append("\nName: ");
            sb.append(this.expanse(this._name));
            sb.append("\n");
            for (attribute attr : this._attrs) {
                attr.appendToManifest(sb);
            }
        }
    }

    public class attribute
    extends BanProcessComponent {
        String _name;
        String _value;

        public void setName(String value) {
            this._name = value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public void endValid() {
            if (this._name == null) {
                throw new BanProcessException("Attribute 'name' not define");
            }
            if (this._value == null) {
                throw new BanProcessException("Attribute 'value' not define");
            }
        }

        public void appendToManifest(StringBuffer sb) {
            sb.append(this.expanse(this._name).trim());
            sb.append(": ");
            sb.append(this.expanse(this._value));
            sb.append("\n");
        }
    }
}

