/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.struct;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Block;
import com.dassault.cecilia.lib.ban.ReturnException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.unitdefs.struct.Local;
import java.util.ArrayList;
import java.util.List;

public class Function
extends Block {
    String _id;
    protected List<Local> _args = new ArrayList<Local>(3);

    public void setId(String value) {
        if (!this.isSimpleID(value)) {
            throw new BanProcessException("Function with complex-id : " + value);
        }
        if (this._id != null) {
            this.log("Function 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    public void setName(String value) {
        this.setId(value);
    }

    public void startValid() {
        if (this._id == null) {
            throw new BanProcessException("No attribute 'id' define");
        }
    }

    @Override
    public void addUnit(Unit unit) {
        if (unit instanceof Local) {
            this._args.add((Local)unit);
            unit.setOwnerUnit(this);
        } else if (unit instanceof Block) {
            super.addUnit(unit);
        } else {
            throw new BanProcessException("Unit [while] can only children [local, block]");
        }
    }

    @Override
    public void execute() {
        this.getProcess().setIdObject(this._id, this);
    }

    public Object call(Object ... params) {
        int i;
        Object result = null;
        this.prepareExecute();
        if (params.length > this._args.size()) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("Arguments ignored : \n");
            for (int i2 = this._args.size(); i2 < params.length; ++i2) {
                sb.append("\t").append(i2).append(" : ");
                String param = params[i2].toString();
                if (param.length() > 60) {
                    sb.append(param.substring(0, 60));
                    sb.append(" ...");
                } else {
                    sb.append(param);
                }
                if (i2 + 1 >= params.length) continue;
                sb.append("\n");
            }
            this.log(sb.toString(), 2);
        }
        for (i = 0; i < this._args.size(); ++i) {
            Local unit = this._args.get(i);
            Object value = i < params.length ? params[i] : null;
            unit.assignValue(value);
        }
        try {
            for (i = 0; i < this._elements.size(); ++i) {
                Unit unit = (Unit)this._elements.get(i);
                if (unit instanceof Local) continue;
                unit.perform();
            }
        }
        catch (ReturnException e) {
            result = e.getResult();
            while (this.getProcess().pop() != this) {
            }
            this.getProcess().push(this);
        }
        this.disposeExecute();
        return result;
    }
}

