/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia;

import com.dassault.cecilia.core.ConfigException;
import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CApplInit {
    private static Logger _LOG = Logger.getLogger(CApplInit.class.getName());
    protected Window _topWindow = null;
    public static final String PROP_CORE_DEBUG = "cecilia.core.debug";
    static boolean __DEBUG = Boolean.getBoolean("cecilia.core.debug");
    protected static CApplInit _instance = null;
    ArrayList<CloseableAction> _closeables = new ArrayList();
    Timer _sheduler = new Timer("Cecilia-Sheduler", true);

    public void setTopWindow(Window topWindow) {
        this._topWindow = topWindow;
    }

    public Window getTopWindow() {
        return this._topWindow;
    }

    public String getModuleName() {
        return "CECILIA";
    }

    public String getTitle() {
        return ResMsgCore.getString("APPL_TITLE_CECILIA");
    }

    public String getVersion() {
        return "6.2.3";
    }

    public boolean isDebugMode() {
        return __DEBUG;
    }

    public CApplInit() {
        CApplInit.setInstance(this);
    }

    private static synchronized void setInstance(CApplInit app) {
        if (_instance == null) {
            _instance = app;
        }
    }

    public static CApplInit getInstance() {
        return _instance;
    }

    public void fatalError(String error, String title, boolean display, boolean exit) {
        this.displayMsg(error, title, 0);
        if (exit) {
            this.exit(-1);
        }
    }

    public void displayMsg(String msg, String title, int typeMsg) {
        Level level = Level.INFO;
        switch (typeMsg) {
            case 0: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 1: {
                level = Level.INFO;
            }
        }
        StringBuffer buffer = new StringBuffer(512);
        if (title != null) {
            buffer.append("--").append(title).append("--: ");
        }
        buffer.append(msg);
        _LOG.log(level, buffer.toString());
        if (this._topWindow != null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._topWindow), msg, title, typeMsg);
        } else {
            System.err.println(buffer.toString());
        }
    }

    public void exit(int code) {
        try {
            ConfigManager.getInstance().logout();
        }
        catch (ConfigException e) {
            _LOG.warning(e.getMessage());
        }
        System.exit(code);
    }

    public void addCloseableAction(CloseableAction action) {
        if (!this._closeables.contains(action)) {
            this._closeables.add(action);
        }
    }

    public void removeCloseableAction(CloseableAction action) {
        this._closeables.remove(action);
    }

    public void close() {
        for (int i = this._closeables.size() - 1; i >= 0; --i) {
            try {
                this._closeables.get(i).callClose();
                continue;
            }
            catch (Throwable th) {
                _LOG.log(Level.WARNING, "Exception during close application", th);
            }
        }
        this.exit(0);
    }

    public void addShedulerTask(TimerTask task, long delay, long period) {
        this._sheduler.schedule(task, delay, period);
    }

    public static interface CloseableAction {
        public void callClose();
    }
}

