/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public abstract class CThread {
    static Logger _LOG = Logger.getLogger(CThread.class.getPackage().getName());
    public static final String PROP_WAIT_THREAD_DEFAULT = "-1";
    public static final String PROP_WAIT_THREAD = "cecilia.core.WaitThread";
    protected static long WAIT_THREAD = Long.getLong("cecilia.core.WaitThread", Long.parseLong("-1"));
    private Component _source;
    private boolean _stopWindow = false;
    IdentityHashMap<Component, Cursor> _mapCursors = new IdentityHashMap();

    public CThread(Component c) {
        this._source = c;
    }

    public CThread(Component c, boolean stopWindow) {
        this._source = c;
        this._stopWindow = stopWindow;
    }

    protected void setSource(Component c) {
        this._source = c;
    }

    protected Component getSource() {
        return this._source;
    }

    protected String getIDCode() {
        return this.getClass().getName();
    }

    public boolean realiseDo() {
        _LOG.finer("Thread-Start[" + this.getIDCode() + "]");
        this.setWaitCursor(this._source);
        try {
            if (WAIT_THREAD > 0L) {
                try {
                    Thread.sleep(WAIT_THREAD);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.firstDo();
            boolean bl = true;
            return bl;
        }
        catch (Throwable th) {
            _LOG.log(Level.SEVERE, "Unexpected error during Thread execute [" + this.getIDCode() + "]", th);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setDefaultCursor(this._source);
            _LOG.finer("Thread-End  [" + this.getIDCode() + "]");
        }
    }

    protected abstract void firstDo();

    synchronized void setWaitCursor(Component c) {
        this._mapCursors.clear();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.changeCursor(this.getTopParent(c), waitCursor);
    }

    synchronized void setDefaultCursor(Component c) {
        Cursor defaultCursor = Cursor.getPredefinedCursor(0);
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.restoreCursor(this.getTopParent(c), defaultCursor, waitCursor);
        for (Map.Entry<Component, Cursor> entry : this._mapCursors.entrySet()) {
            entry.getKey().setCursor(entry.getValue());
        }
    }

    Component getTopParent(Component c) {
        Container parent = c.getParent();
        if (this._stopWindow && parent instanceof Window) {
            return parent;
        }
        if (parent == null) {
            return c;
        }
        return this.getTopParent(parent);
    }

    void changeCursor(Component c, Cursor curs) {
        if (c instanceof BasicInternalFrameTitlePane) {
            return;
        }
        Cursor currentCursor = c.getCursor();
        if (currentCursor != null) {
            this._mapCursors.put(c, currentCursor);
        }
        if (c instanceof Container) {
            Component[] comps = ((Container)c).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.changeCursor(comps[i], curs);
            }
        }
        c.setCursor(curs);
    }

    void restoreCursor(Component c, Cursor defaultCursor, Cursor waitCursor) {
        Cursor currentCursor;
        if (!c.getCursor().equals(waitCursor)) {
            return;
        }
        if (c instanceof Container) {
            Component[] comps = ((Container)c).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.restoreCursor(comps[i], defaultCursor, waitCursor);
            }
        }
        if ((currentCursor = this._mapCursors.remove(c)) != null) {
            c.setCursor(currentCursor);
        }
    }
}

