/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseFilter;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.lib.util.CryptUtility;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class DBLicenseUtility {
    public static final String PROP_LICENSE_PATH = "cecilia.core.LicensePath";

    public static DBLicense readLicenseFile(String pathLic) throws IOException {
        DBLicense license = new DBLicense();
        try {
            String line;
            BufferedReader inData = new BufferedReader(new FileReader(pathLic));
            String societyName = "";
            String versionName = "";
            String licenseValue = "";
            while ((line = inData.readLine()) != null) {
                int position = line.indexOf("<society>");
                if (position == 0) {
                    societyName = line.substring(position + 9);
                }
                if ((position = line.indexOf("<version>")) == 0) {
                    versionName = line.substring(position + 9);
                }
                if ((position = line.indexOf("<license>")) != 0) continue;
                licenseValue = line.substring(position + 9);
            }
            inData.close();
            if (societyName.length() == 0 || licenseValue.length() == 0) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_DATA_FORMAT"));
            }
            license.setCompany(societyName);
            licenseValue = versionName.equals("") ? CryptUtility.decryptData((String)licenseValue, (String)societyName) : CryptUtility.decryptData((String)licenseValue, (String)(societyName + " " + versionName));
            StringTokenizer stoken = new StringTokenizer(licenseValue, " ");
            if (!stoken.hasMoreTokens()) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            license.setHost(stoken.nextToken());
            if (!stoken.hasMoreTokens()) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String dateValue = stoken.nextToken();
            Date dateExpire = DBLicense.parseDate(dateValue);
            if (dateExpire == null) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            license.setExpire(dateExpire);
            if (!stoken.hasMoreTokens()) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String connectValue = stoken.nextToken();
            int token = DBLicense.parseToken(connectValue);
            if (token == 0) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            license.setToken(token);
            if (!stoken.hasMoreTokens()) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            license.setModule(stoken.nextToken());
            if (!stoken.hasMoreTokens()) {
                throw new IOException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            license.setVersion(stoken.nextToken());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Unknow exception : " + ex.getMessage(), ex);
        }
        return license;
    }

    private static File getDefaultDir() {
        File pdir;
        File dir = new File(".");
        String property = System.getProperty(PROP_LICENSE_PATH);
        if (property != null && !(pdir = new File(property)).isDirectory()) {
            dir = pdir;
        }
        return dir;
    }

    public static DBLicense selectLicense(Component owner) throws IOException {
        JFileChooser dlg = new JFileChooser();
        dlg.setFileFilter(new LicenseFilter());
        dlg.setCurrentDirectory(DBLicenseUtility.getDefaultDir());
        if (dlg.showOpenDialog(owner) != 0) {
            return null;
        }
        return DBLicenseUtility.readLicenseFile(dlg.getSelectedFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeyFile(String society, String host, String module, File licenseFile) throws IOException {
        try (BufferedWriter outData = null;){
            outData = new BufferedWriter(new FileWriter(licenseFile));
            outData.write(ResMsgCore.getString("LICENSE_MSG_COMMENT"));
            outData.newLine();
            outData.write("<num>" + host);
            outData.newLine();
            outData.write("<society>" + society.trim());
            outData.newLine();
            outData.write("<module>" + module);
            outData.newLine();
            outData.write("<version>6.2.3");
            outData.newLine();
        }
    }

    public static boolean askLicense(String host, String module, Component owner, String title) throws IOException {
        String society = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgCore.getString("LICENSE_DLG_LBL_ENTER_COMPANY"), title, 3);
        if (society == null) {
            return false;
        }
        if (society.trim().length() == 0) {
            throw new IOException(ResMsgCore.getString("LICENSE_ERR_ENTER_COMPANY"));
        }
        JFileChooser dlg = new JFileChooser();
        File dir = DBLicenseUtility.getDefaultDir();
        dlg.setCurrentDirectory(dir);
        dlg.setSelectedFile(new File(dir, "Key.txt"));
        FileFilter keyFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (!f.isFile()) {
                    return false;
                }
                String name = f.getName().toLowerCase();
                if (!name.startsWith("key")) {
                    return false;
                }
                return name.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return ResMsgCore.getString("LICENSE_DLG_FILE_KEY");
            }
        };
        dlg.addChoosableFileFilter(keyFilter);
        dlg.setFileFilter(keyFilter);
        if (dlg.showSaveDialog(owner) != 0) {
            return false;
        }
        File keyFile = dlg.getSelectedFile();
        if (!FileUtility.verifyPath((String)keyFile.getAbsolutePath(), (boolean)true, (Component)owner, (String)title)) {
            return false;
        }
        DBLicenseUtility.writeKeyFile(society, host, module, keyFile);
        return true;
    }
}

