/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseException;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseFilter;
import com.dassault.cecilia.core.plugin.Plug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.lib.util.io.CRCWriter;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LicenseManager {
    static Logger LOG = Logger.getLogger(LicenseManager.class.getPackage().getName());
    public static final String PROP_LICENSE_MACNAME = "cecilia.core.LicenseName";
    private static final boolean LICENSE_MAC_WITH_NAME = Boolean.getBoolean("cecilia.core.LicenseName");
    private SQLConnection _connect;
    private static final int LICENSE_DVPT = 0;
    private static final int LICENSE_CECILIA = 1;
    private static int TYPE_LICENSE = 0;
    static SimpleDateFormat __dateFormat = new SimpleDateFormat("dd'/'MM'/'yyyy");
    static final String DATA_MASK = "kmepogaujbfw";
    static final String DISK_MASK = "bwosklertiufj";
    private static final String licence_company_name_DA = "Dassault Aviation";

    public LicenseManager(SQLConnection connect) {
        this._connect = connect;
    }

    public final Date login(Plug module) throws LicenseException {
        if (TYPE_LICENSE == 0) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, cal.get(1) + 1);
            return cal.getTime();
        }
        try {
            if (module != null && TYPE_LICENSE != 0) {
                return this.verifDirectLicense(module);
            }
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_INVALID"), ex);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, cal.get(1) + 1);
        return cal.getTime();
    }

    public final void verify() throws LicenseException {
        if (TYPE_LICENSE == 0) {
            return;
        }
    }

    public final void logout() {
        if (TYPE_LICENSE == 0) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Date verifDirectLicense(Plug module) throws LicenseException, SQLException {
        result = null;
        rs = null;
        society = null;
        moduleName = module.getInfo("licence");
        if (LicenseManager.TYPE_LICENSE != 0) {
            stm = null;
            try {
                stm = this._connect.getConnection().prepareStatement("select * from licenses");
                rs = stm.executeQuery();
                while (society == null && rs.next()) {
                    key = rs.getString("lic_company_name");
                    moduleInDb = rs.getString("lic_module_id");
                    if (moduleInDb == null || !key.equals("Dassault Aviation") || !moduleName.equals(moduleInDb)) continue;
                    society = "Dassault Aviation";
                }
            }
            finally {
                if (stm != null) {
                    stm.close();
                }
            }
        }
        localDataKey = this.getMACAddress();
        if (society == null || this._connect.isDataBaseNode()) {
            society = null;
            stm = null;
            try {
                stm = this._connect.getConnection().prepareStatement("select * from licenses");
                rs = stm.executeQuery();
                while (society == null && rs.next()) {
                    key = rs.getString("lic_company_name");
                    dataCrypt = rs.getString("lic_host_id");
                    moduleInDb = rs.getString("lic_module_id");
                    if (dataCrypt == null || moduleInDb == null) continue;
                    dataDecrypt = LicenseManager.decryptData(dataCrypt, key);
                    if (this._connect.isDataBaseNode() && key.equals("Dassault Aviation") && moduleName.equals(moduleInDb)) {
                        if (!dataDecrypt.equals(System.getProperty("cecilia.db.user"))) continue;
                        var12_17 = null;
                        return var12_17;
                    }
                    if (!this.verifMACAddress(dataDecrypt, localDataKey) || !moduleName.equals(moduleInDb)) continue;
                    society = key;
                }
            }
            finally {
                if (stm != null) {
                    stm.close();
                }
            }
        }
        if (society == null) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_NOT_FOUND"));
        }
        nbrConnectOK = false;
        nbConnect = LicenseManager.decryptData(rs.getString("lic_token_count"), society);
        if (!nbConnect.equalsIgnoreCase("ILLIMITE")) {
            if (this._connect.getType() == SQLConnection.DBType.Oracle) {
                nbConnectNowSt = null;
                try {
                    nbConnectNowSt = this._connect.getConnection().prepareStatement("SELECT COUNT(*) FROM V$SESSION WHERE UPPER(PROGRAM) LIKE '%JDBC%' AND UPPER(USERNAME)='" + this._connect.getLogin().toUpperCase() + "'");
                    rsConnect = nbConnectNowSt.executeQuery();
                    if (!rsConnect.next()) ** GOTO lbl75
                    nbConnectNow = rsConnect.getString(1);
                    try {
                        nbc = Integer.valueOf(nbConnect);
                        nbcn = Integer.valueOf(nbConnectNow);
                        nbrConnectOK = nbcn <= nbc;
                    }
                    catch (NumberFormatException var12_19) {
                        // empty catch block
                    }
                }
                finally {
                    if (nbConnectNowSt != null) {
                        nbConnectNowSt.close();
                    }
                }
            } else {
                nbrConnectOK = true;
            }
        } else {
            nbrConnectOK = true;
        }
lbl75:
        // 5 sources

        if (!nbrConnectOK) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_CONNECT_NBR"));
        }
        delayOK = false;
        delay = LicenseManager.decryptData(rs.getString("lic_deadline"), society);
        if (!delay.equalsIgnoreCase("ALWAYS")) {
            try {
                result = LicenseManager.__dateFormat.parse(delay);
                delayOK = Calendar.getInstance().getTime().before(result);
            }
            catch (ParseException e) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_DATE_FORMAT"), e);
            }
            catch (NumberFormatException e) {
                LicenseManager.LOG.log(Level.INFO, "Delay is not float number: " + delay, e);
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_DATE_FORMAT"), e);
            }
        } else {
            delayOK = true;
        }
        if (!delayOK) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_CONNECT_DATE"));
        }
        version = LicenseManager.decryptData(rs.getString("lic_version_id"), society);
        if (!version.equals(module.getInfo("plugin.version"))) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_VERSION"));
        }
        return result;
    }

    private void readLicenseFile(String pathLic, Plug module, Map<String, String> data) throws LicenseException {
        data.clear();
        try {
            String line;
            BufferedReader inData = new BufferedReader(new FileReader(pathLic));
            String societyName = "";
            String versionName = "";
            String licenseValue = "";
            while ((line = inData.readLine()) != null) {
                int position = line.indexOf("<society>");
                if (position == 0) {
                    societyName = line.substring(position + 9);
                }
                if ((position = line.indexOf("<version>")) == 0) {
                    versionName = line.substring(position + 9);
                }
                if ((position = line.indexOf("<license>")) != 0) continue;
                licenseValue = line.substring(position + 9);
            }
            inData.close();
            if (societyName.length() == 0 || licenseValue.length() == 0) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_DATA_FORMAT"));
            }
            data.put("society", societyName);
            data.put("license", licenseValue);
            licenseValue = versionName.equals("") ? LicenseManager.decryptData(licenseValue, societyName) : LicenseManager.decryptData(licenseValue, societyName + " " + versionName);
            StringTokenizer stoken = new StringTokenizer(licenseValue, " ");
            if (!stoken.hasMoreTokens()) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String registeredMACAddress = stoken.nextToken();
            if (!societyName.equals(licence_company_name_DA) && !this.verifMACAddress(registeredMACAddress, this.getMACAddress())) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_HOST"));
            }
            data.put("MACAddress", registeredMACAddress);
            if (!stoken.hasMoreTokens()) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String dateValue = stoken.nextToken();
            if (!dateValue.equalsIgnoreCase("ALWAYS")) {
                try {
                    Date licenseDate = __dateFormat.parse(dateValue);
                    if (licenseDate.before(new Date())) {
                        throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_EXPIRED"));
                    }
                }
                catch (ParseException ex) {
                    throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_DATE_FORMAT"), ex);
                }
            }
            data.put("date", dateValue);
            if (!stoken.hasMoreTokens()) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String connectValue = stoken.nextToken();
            if (!connectValue.equalsIgnoreCase("ILLIMITE")) {
                try {
                    int nbr = Integer.parseInt(connectValue);
                    if (nbr <= 0) {
                        throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_CONNECT_FORMAT"));
                    }
                }
                catch (NumberFormatException ex) {
                    throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_CONNECT_FORMAT"), ex);
                }
            }
            data.put("connect", connectValue);
            if (!stoken.hasMoreTokens()) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String moduleValue = stoken.nextToken();
            if (!moduleValue.equalsIgnoreCase(module.getInfo("licence"))) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_MODULE"));
            }
            data.put("module", moduleValue);
            if (!stoken.hasMoreTokens()) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_FORMAT"));
            }
            String versionValue = stoken.nextToken();
            if (!versionValue.equals(module.getInfo("plugin.version"))) {
                throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_VERSION"));
            }
            data.put("version", versionValue);
        }
        catch (LicenseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LicenseException("Unknow exception : " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLicence(Map<String, String> data) throws LicenseException {
        Connection connection = null;
        try {
            connection = this._connect.getConnection();
            String society = data.get("society");
            String macAdress = data.get("MACAddress");
            ArrayList<String> deleteMacAdress = new ArrayList<String>();
            try (PreparedStatement stm = null;){
                stm = this._connect.getConnection().prepareStatement("SELECT * FROM licenses");
                ResultSet rs = stm.executeQuery();
                while (rs.next()) {
                    String registeredDataKey;
                    String key = rs.getString("lic_company_name");
                    String dataKey = rs.getString("lic_host_id");
                    if (dataKey == null || !this.verifMACAddress(registeredDataKey = LicenseManager.decryptData(dataKey, key), macAdress)) continue;
                    deleteMacAdress.add(dataKey);
                }
            }
            String module = data.get("module");
            for (int i = 0; i < deleteMacAdress.size(); ++i) {
                Statement deleteStatement = connection.createStatement();
                deleteStatement.executeUpdate("DELETE FROM licenses WHERE lic_host_id = '" + (String)deleteMacAdress.get(i) + "' AND ( lic_module_id = '" + module + "' OR lic_module_id IS NULL )");
                deleteStatement.close();
            }
            macAdress = LicenseManager.cryptData(macAdress, society);
            PreparedStatement statement = null;
            statement = this._connect.getType() == SQLConnection.DBType.Oracle ? connection.prepareStatement("INSERT INTO licenses (lic_id,lic_company_name,lic_deadline,lic_token_count,lic_module_id,lic_version_id,lic_host_id) VALUES (lic_seq.nextval,?,?,?,?,?,?)") : connection.prepareStatement("INSERT INTO licenses (lic_company_name,lic_deadline,lic_token_count,lic_module_id,lic_version_id,lic_host_id) VALUES (?,?,?,?,?,?)");
            statement.setString(1, society);
            statement.setString(2, LicenseManager.cryptData(data.get("date"), society));
            statement.setString(3, LicenseManager.cryptData(data.get("connect"), society));
            statement.setString(4, module);
            statement.setString(5, LicenseManager.cryptData(data.get("version"), society));
            statement.setString(6, macAdress);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_UPDATE_LICENSE"), ex);
        }
    }

    private File getDefaultDir() {
        File pdir;
        File dir = new File(".");
        String property = System.getProperty("cecilia.core.LicensePath");
        if (property != null && !(pdir = new File(property)).isDirectory()) {
            dir = pdir;
        }
        return dir;
    }

    public boolean changeLicense(Plug module, Component owner) throws LicenseException {
        JFileChooser dlg = new JFileChooser();
        dlg.setFileFilter(new LicenseFilter());
        dlg.setCurrentDirectory(this.getDefaultDir());
        if (dlg.showOpenDialog(owner) != 0) {
            return false;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        this.readLicenseFile(dlg.getSelectedFile().getAbsolutePath(), module, data);
        this.updateLicence(data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyFile(String society, String module, File licenseFile) throws LicenseException {
        try (BufferedWriter outData = null;){
            outData = new BufferedWriter(new FileWriter(licenseFile));
            outData.write(ResMsgCore.getString("LICENSE_MSG_COMMENT"));
            outData.newLine();
            outData.write("<num>" + this.getMACAddress());
            outData.newLine();
            outData.write("<society>" + society.trim());
            outData.newLine();
            outData.write("<module>" + module);
            outData.newLine();
            outData.write("<version>6.2.3");
            outData.newLine();
        }
        catch (IOException ex) {
            throw new LicenseException("IOException : " + ex.getMessage(), ex);
        }
    }

    public boolean askLicense(Plug module, Component owner, String title) throws LicenseException {
        String society = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgCore.getString("LICENSE_DLG_LBL_ENTER_COMPANY"), title, 3);
        if (society == null) {
            return false;
        }
        if (society.trim().length() == 0) {
            throw new LicenseException(ResMsgCore.getString("LICENSE_ERR_ENTER_COMPANY"));
        }
        JFileChooser dlg = new JFileChooser();
        File dir = this.getDefaultDir();
        dlg.setCurrentDirectory(dir);
        dlg.setSelectedFile(new File(dir, "Key.txt"));
        FileFilter keyFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (!f.isFile()) {
                    return false;
                }
                String name = f.getName().toLowerCase();
                if (!name.startsWith("key")) {
                    return false;
                }
                return name.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return ResMsgCore.getString("LICENSE_DLG_FILE_KEY");
            }
        };
        dlg.addChoosableFileFilter(keyFilter);
        dlg.setFileFilter(keyFilter);
        if (dlg.showSaveDialog(owner) != 0) {
            return false;
        }
        File keyFile = dlg.getSelectedFile();
        if (!FileUtility.verifyPath((String)keyFile.getAbsolutePath(), (boolean)true, (Component)owner, (String)title)) {
            return false;
        }
        this.writeKeyFile(society, module.getInfo("licence"), keyFile);
        return true;
    }

    private boolean verifMACAddress(String testedAdress, String localAdress) throws LicenseException {
        if (!this._connect.isDataBaseNode()) {
            return testedAdress.equals(localAdress);
        }
        if (TYPE_LICENSE != 0) {
            StringTokenizer st = new StringTokenizer(localAdress, ";");
            while (st.hasMoreTokens()) {
                if (!testedAdress.contains(st.nextToken())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static String readMACAddressWithIPConfig() throws LicenseException {
        try {
            Collection<String> lines = LicenseManager.exec("ipconfig /all", false);
            StringBuffer MACAddresses = new StringBuffer();
            String MACAddress = null;
            Iterator<String> iter = lines.iterator();
            while (iter.hasNext()) {
                MACAddress = LicenseManager.parseMACLine(iter.next());
                if (MACAddress == null) continue;
                MACAddresses.append(MACAddress);
                MACAddresses.append(';');
            }
            if (MACAddresses.length() != 0) {
                MACAddresses.deleteCharAt(MACAddresses.length() - 1);
            }
            return MACAddresses.toString();
        }
        catch (IOException e) {
            throw new LicenseException(null, e);
        }
    }

    private String getMACAddress() throws LicenseException {
        if (!this._connect.isDataBaseNode()) {
            return this._connect.getConnectionUrl();
        }
        if (TYPE_LICENSE != 0) {
            if (LICENSE_MAC_WITH_NAME) {
                return LicenseManager.getMACAddressWithName();
            }
            return LicenseManager.getMACAddressWithJava6();
        }
        throw new LicenseException("Internal error : No manager of MACAdress define");
    }

    private static String getMACAddressWithName() throws LicenseException {
        try {
            String name = InetAddress.getLocalHost().getHostName();
            CRCWriter writer = new CRCWriter((Writer)new StringWriter());
            writer.write(name);
            writer.close();
            return writer.getMAC();
        }
        catch (UnknownHostException e) {
            throw new LicenseException(null, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseException(null, e);
        }
        catch (IOException e) {
            throw new LicenseException(null, e);
        }
    }

    private static String getMACAddressWithJava6() throws LicenseException {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            StringBuffer result = new StringBuffer(256);
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null || mac.length != 6) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                if (result.length() > 0) {
                    result.append(";");
                }
                result.append(sb.toString());
            }
            if (result.length() == 0) {
                throw new LicenseException("No Mac address");
            }
            return result.toString();
        }
        catch (UnknownHostException e) {
            throw new LicenseException(null, e);
        }
        catch (SocketException e) {
            throw new LicenseException(null, e);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(LicenseManager.readMACAddressWithIPConfig());
            System.out.println(LicenseManager.getMACAddressWithJava6());
            System.out.println(LicenseManager.getMACAddressWithName());
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }

    private File convertResource(URL path) throws IOException {
        File f = File.createTempFile("Tgt173", null);
        LicenseManager.convertStream(path, f);
        return f;
    }

    private static void convertStream(URL input, File output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output));
        byte[] b = new byte[in.available()];
        in.read(b, 0, b.length);
        in.close();
        Stack<Byte> stack = new Stack<Byte>();
        for (int i = 0; i < b.length; ++i) {
            stack.push(b[i]);
        }
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            out.write(((Byte)stack.pop()).byteValue());
        }
        out.close();
    }

    private static Collection<String> exec(String cmd, boolean pressAnyKey) throws IOException {
        final ArrayList<String> lines = new ArrayList<String>(10);
        Process proc = Runtime.getRuntime().exec(cmd);
        if (pressAnyKey) {
            OutputStreamWriter writer = new OutputStreamWriter(proc.getOutputStream());
            writer.write(" \n");
            ((Writer)writer).close();
        }
        final BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            while (thread.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lines;
    }

    private static String parseMACLine(String line) {
        String MACAddress = null;
        char[] chars = line.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!LicenseManager.isHexChar(chars[i]) || (MACAddress = LicenseManager.parseMACAddress(chars, i)) == null) continue;
            return MACAddress;
        }
        return null;
    }

    private static String parseMACAddress(char[] chars, int offset) {
        if (chars.length - offset - 1 < 16) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 0])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 1])) {
            return null;
        }
        if (chars[offset + 2] != '-') {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 3])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 4])) {
            return null;
        }
        if (chars[offset + 5] != '-') {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 6])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 7])) {
            return null;
        }
        if (chars[offset + 8] != '-') {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 9])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 10])) {
            return null;
        }
        if (chars[offset + 11] != '-') {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 12])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 13])) {
            return null;
        }
        if (chars[offset + 14] != '-') {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 15])) {
            return null;
        }
        if (!LicenseManager.isHexChar(chars[offset + 16])) {
            return null;
        }
        return new String(chars, offset, 17);
    }

    private static boolean isHexChar(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static String cryptData(String data) {
        return LicenseManager.cryptData(data, DATA_MASK);
    }

    public static String cryptData(String data, String cryptMask) {
        String result = new String("");
        String mask = new String("");
        while (mask.length() < data.length()) {
            mask = mask.concat(cryptMask);
        }
        mask = mask.substring(0, data.length());
        int dataLength = data.length();
        char[] dataChar = data.toCharArray();
        char[] maskChar = mask.toCharArray();
        for (int i = 0; i < dataLength; ++i) {
            result = result + LicenseManager.cryptOneCar(dataChar[i], LicenseManager.getBigInteger(maskChar[i]));
        }
        return result;
    }

    private static String cryptOneCar(char c, BigInteger charData) {
        BigInteger cBi = LicenseManager.getBigInteger(c);
        BigInteger resultBi = cBi.xor(charData);
        return LicenseManager.getHexaValue(Integer.parseInt(resultBi.toString()));
    }

    public static String decryptData(String data) {
        return LicenseManager.decryptData(data, DATA_MASK);
    }

    public static String decryptData(String data, String cryptMask) {
        String result = new String();
        int dataLength = data.length() / 2;
        String mask = new String("");
        while (mask.length() < dataLength) {
            mask = mask.concat(cryptMask);
        }
        mask = mask.substring(0, dataLength);
        char[] maskChar = mask.toCharArray();
        int j = 0;
        for (int i = 0; i < dataLength; ++i) {
            int dataInt = LicenseManager.getIntValue(data.substring(j, j + 2));
            result = result + LicenseManager.decryptOneCar(dataInt, LicenseManager.getBigInteger(maskChar[i]));
            j += 2;
        }
        return result;
    }

    private static String decryptOneCar(int c, BigInteger charData) {
        BigInteger cBi = new BigInteger("" + c);
        BigInteger resultBi = cBi.xor(charData);
        return "" + (char)resultBi.intValue();
    }

    private static BigInteger getBigInteger(char c) {
        BigInteger bi = new BigInteger(String.valueOf((int)c));
        return bi;
    }

    private static String getHexaValue(int value) {
        int firstValue = value / 16;
        int secondValue = value - firstValue * 16;
        String result = new String(LicenseManager.intToHexa(firstValue) + LicenseManager.intToHexa(secondValue));
        return result;
    }

    private static int getIntValue(String value) {
        char[] valueTab = value.toCharArray();
        return LicenseManager.hexaToInt("" + valueTab[0]) * 16 + LicenseManager.hexaToInt("" + valueTab[1]);
    }

    private static int hexaToInt(String valeur) {
        switch (valeur.toCharArray()[0]) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Integer.parseInt(valeur);
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'G': {
                return 16;
            }
            case 'H': {
                return 17;
            }
            case 'I': {
                return 18;
            }
            case 'J': {
                return 19;
            }
            case 'K': {
                return 20;
            }
            case 'L': {
                return 21;
            }
            case 'M': {
                return 22;
            }
            case 'N': {
                return 23;
            }
        }
        return -1;
    }

    private static String intToHexa(int valeur) {
        switch (valeur) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "" + valeur;
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
            case 16: {
                return "G";
            }
            case 17: {
                return "H";
            }
            case 18: {
                return "I";
            }
            case 19: {
                return "J";
            }
            case 20: {
                return "K";
            }
            case 21: {
                return "L";
            }
            case 22: {
                return "M";
            }
            case 23: {
                return "N";
            }
        }
        return "";
    }
}

