/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModelInterface;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.IFolder;
import com.dassault.cecilia.lib.util.AlphaNumComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DBFolderTreeNode
implements TreeNode,
IFolder {
    private static Logger _LOG = Logger.getLogger(DBFolderTreeNode.class.getPackage().getName());
    private DBFolder _dbFolder;
    private boolean _bReadOnly;
    protected DBFolderTreeModelInterface _model;
    protected ArrayList<DBFolderTreeNode> _nodeChildren = null;
    protected DBFolderTreeNode _nodeParent = null;
    protected static Comparator<? super DBFolderTreeNode> __DBFolderTreeNodeComparator = new Comparator<DBFolderTreeNode>(){
        Comparator<String> _delegate = AlphaNumComparator.getInstance((boolean)true);

        @Override
        public int compare(DBFolderTreeNode o1, DBFolderTreeNode o2) {
            return this._delegate.compare(o1.getName(), o2.getName());
        }
    };

    public DBFolderTreeNode(DBFolderTreeModelInterface model, DBFolder dbFolder) {
        this._model = model;
        this._dbFolder = dbFolder;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._dbFolder.isFolder()) {
            sb.append("+");
        }
        sb.append(this._dbFolder.getName());
        sb.append("[").append(this._dbFolder.getID()).append("]");
        if (this._bReadOnly) {
            sb.append("!");
        }
        return sb.toString();
    }

    protected DBFolderTreeModelInterface getModel() {
        return this._model;
    }

    public void setReadOnly(boolean bReadOnly) {
        this._bReadOnly = bReadOnly;
    }

    public synchronized void createNodeChildren() {
        List<DBFolder> children = this._dbFolder.getChildren();
        if (children == null) {
            children = this._model.findChildren(this._dbFolder);
        }
        if (children == null || children.isEmpty()) {
            this._nodeChildren = this._dbFolder.isVersion() && this.getModel().withNodeFiles() ? this.createNodeFiles() : new ArrayList(0);
            return;
        }
        this._nodeChildren = new ArrayList(children.size());
        for (DBFolder dbFolder : children) {
            if (!this.getModel().acceptFolder(dbFolder)) continue;
            DBFolderTreeNode trNode = this._model.getTreeNode(dbFolder);
            if (trNode == null) {
                trNode = new DBFolderTreeNode(this._model, dbFolder);
                this._model.putTreeNode(dbFolder, trNode);
            }
            this._nodeChildren.add(trNode);
            trNode.setParent(this);
        }
        Collections.sort(this._nodeChildren, __DBFolderTreeNodeComparator);
    }

    protected ArrayList<DBFolderTreeNode> createNodeFiles() {
        ArrayList<DBFolderTreeNode> result = new ArrayList<DBFolderTreeNode>();
        if (!this._dbFolder.isVersion()) {
            return result;
        }
        DBObject dbObject = this._dbFolder.getObject();
        if (dbObject == null) {
            return result;
        }
        for (DBObjModel dbObjModel : dbObject.getModels()) {
            if (!dbObjModel.getNature().startsWith("associated.file")) continue;
            DBFolderTreeNodeFile trNode = new DBFolderTreeNodeFile(this._model, this._dbFolder, dbObjModel);
            trNode.setParent(this);
            result.add(trNode);
        }
        return result;
    }

    public int remove(DBFolderTreeNode trNode) {
        int idx = this._nodeChildren.indexOf(trNode);
        if (idx != -1) {
            this._nodeChildren.remove(idx);
        }
        return idx;
    }

    protected int findInsertPoint_rec(DBFolderTreeNode nodeWillInsert, int min, int max) {
        int mean = (min + max) / 2;
        int cmp = __DBFolderTreeNodeComparator.compare(this._nodeChildren.get(mean), nodeWillInsert);
        if (mean == min) {
            if (cmp > 0) {
                return mean;
            }
            return max;
        }
        if (cmp <= 0) {
            return this.findInsertPoint_rec(nodeWillInsert, mean, max);
        }
        return this.findInsertPoint_rec(nodeWillInsert, min, mean);
    }

    public int insert(DBFolderTreeNode trNode) {
        if (this._nodeChildren == null) {
            this.createNodeChildren();
        } else if (this._nodeChildren.size() == 0) {
            this._nodeChildren.add(trNode);
            trNode.setParent(this);
        } else {
            int idx = this.findInsertPoint_rec(trNode, 0, this._nodeChildren.size());
            this._nodeChildren.add(idx, trNode);
            trNode.setParent(this);
        }
        return -1;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this._nodeChildren == null) {
            this.createNodeChildren();
        }
        return this._nodeChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (this._nodeChildren == null) {
            this.createNodeChildren();
        }
        return this._nodeChildren.size();
    }

    @Override
    public synchronized DBFolderTreeNode getParent() {
        if (this._nodeParent == null) {
            if (this._model.getRoot() == this) {
                return null;
            }
            this._nodeParent = this._model.getTreeNode(this._dbFolder.getParent());
        }
        return this._nodeParent;
    }

    protected synchronized void setParent(DBFolderTreeNode parent) {
        this._nodeParent = parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this._nodeChildren == null) {
            this.createNodeChildren();
        }
        return this._nodeChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        if (!this._dbFolder.isVersion()) {
            return false;
        }
        if (this._nodeChildren != null && !this._nodeChildren.isEmpty()) {
            return false;
        }
        DBObject dbObject = this._dbFolder.getObject();
        if (dbObject == null) {
            return true;
        }
        for (DBObjModel dbObjModel : dbObject.getModels()) {
            if (!dbObjModel.getNature().startsWith("associated.file")) continue;
            return false;
        }
        return true;
    }

    public Enumeration children() {
        if (this._nodeChildren == null) {
            this.createNodeChildren();
        }
        return Collections.enumeration(this._nodeChildren);
    }

    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    public short getVirtualFamilyFlag() {
        if (this._dbFolder != null) {
            return this._dbFolder.getFamilyFlag();
        }
        return 0;
    }

    @Override
    public long getID() {
        return this._dbFolder.getID();
    }

    @Override
    public String getName() {
        return this._dbFolder.getName();
    }

    @Override
    public boolean isSystem() {
        return this._dbFolder.isSystem();
    }

    @Override
    public boolean isFreeze() {
        return this._dbFolder.isFreeze();
    }

    @Override
    public boolean isLocked() {
        return this._dbFolder.isLocked();
    }

    @Override
    public DBFolder getSource() {
        return this._dbFolder;
    }

    @Override
    public boolean isReadOnly() {
        return this._bReadOnly;
    }

    public static void expandTree(JTree tree, DBFolderTreeModelInterface model, List<DBFolder> dbFolders, int depth) {
        for (DBFolder dbFolder : dbFolders) {
            int nbrChildren;
            _LOG.finest("doExpand::start " + dbFolder);
            if (dbFolder.isVersion()) continue;
            DBFolderTreeNode folderNode = model.getTreeNode(dbFolder);
            if (folderNode == null) {
                _LOG.finest("doExpand::stop " + dbFolder);
                continue;
            }
            Object[] pathNodes = model.getPathToRoot(folderNode);
            if (pathNodes == null || pathNodes.length == 0) {
                _LOG.severe("doExpand: Pas de chemin vers root pour le folder : " + dbFolder);
                continue;
            }
            TreePath treePath = new TreePath(pathNodes);
            if (!tree.isExpanded(treePath)) {
                _LOG.finest("doExpand::expandPath " + dbFolder);
                tree.expandPath(treePath);
            }
            if (depth == 0 || (nbrChildren = folderNode.getChildCount()) == 0) continue;
            _LOG.finest("doExpand::startChildren " + dbFolder);
            List<DBFolder> dbChildren = dbFolder.getChildren();
            if (dbChildren == null) continue;
            DBFolderTreeNode.expandTree(tree, model, dbChildren, depth - 1);
        }
    }

    public static void collapseTree(JTree tree, DBFolderTreeModelInterface model, List<DBFolder> dbFolders) {
        for (DBFolder dbFolder : dbFolders) {
            TreePath path;
            Object[] pathNodes;
            DBFolderTreeNode folderNode;
            if (dbFolder.isVersion() || (folderNode = model.getTreeNode(dbFolder)) == null || (pathNodes = model.getPathToRoot(folderNode)) == null || pathNodes.length == 0) continue;
            if (folderNode.getChildCount() != 0) {
                DBFolderTreeNode firstChild;
                List<DBFolder> dbChildren = dbFolder.getChildren();
                if (dbChildren != null) {
                    DBFolderTreeNode.collapseTree(tree, model, dbChildren);
                }
                if ((firstChild = (DBFolderTreeNode)folderNode.getChildAt(0)) != null && firstChild.getVirtualFamilyFlag() != 0 && !firstChild.getSource().isVersion()) {
                    for (int i = 0; i < folderNode.getChildCount(); ++i) {
                        TreeNode child = folderNode.getChildAt(i);
                        tree.collapsePath(new TreePath(model.getPathToRoot(child)));
                    }
                }
            }
            if (tree.isCollapsed(path = new TreePath(pathNodes))) continue;
            tree.collapsePath(path);
        }
    }
}

