/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModelInterface;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class DBFolderTreeNodeFile
extends DBFolderTreeNode {
    private static Logger _LOG = Logger.getLogger(DBFolderTreeNodeFile.class.getPackage().getName());
    private static final String NATURE = "associated.file.";
    private static final int NATURE_LENGTH = "associated.file.".length();
    private static Map<String, TypeFile> MAP_ICON = DBFolderTreeNodeFile.createTypeMap();
    DBObjModel _dbObjModel;
    String _strName;
    TypeFile _type;

    private static Map<String, TypeFile> createTypeMap() {
        HashMap<String, TypeFile> result = new HashMap<String, TypeFile>();
        result.put("doc", TypeFile.DOC);
        result.put("docx", TypeFile.DOC);
        result.put("rtf", TypeFile.DOC);
        result.put("odt", TypeFile.DOC);
        result.put("jpg", TypeFile.JPG);
        result.put("gif", TypeFile.JPG);
        result.put("png", TypeFile.JPG);
        result.put("pdf", TypeFile.PDF);
        result.put("txt", TypeFile.TXT);
        result.put("log", TypeFile.TXT);
        result.put("properties", TypeFile.TXT);
        result.put("xls", TypeFile.XLS);
        result.put("xlsx", TypeFile.XLS);
        result.put("ods", TypeFile.XLS);
        result.put("ppt", TypeFile.PPT);
        result.put("pptx", TypeFile.PPT);
        return result;
    }

    public DBFolderTreeNodeFile(DBFolderTreeModelInterface model, DBFolder dbFolder, DBObjModel dbObjModel) {
        super(model, dbFolder);
        this._dbObjModel = dbObjModel;
        this._strName = this._dbObjModel.getNature();
        this._strName = this._strName.startsWith(NATURE) && this._strName.length() > NATURE_LENGTH ? this._strName.substring(NATURE_LENGTH) : "#" + this._strName;
        String ext = "";
        int pos = this._strName.lastIndexOf(46);
        if (pos > 0 && pos < this._strName.length() - 1) {
            ext = this._strName.substring(pos + 1);
        }
        this._type = MAP_ICON.get(ext.toLowerCase());
        if (this._type == null) {
            this._type = TypeFile.OTH;
        }
    }

    @Override
    public String getName() {
        return this._strName;
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this._nodeParent.isReadOnly();
    }

    @Override
    public boolean isFreeze() {
        return this._nodeParent.isFreeze();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode node) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Enumeration children() {
        return Collections.emptyEnumeration();
    }

    public Icon getIcon() {
        return this._type.getIcon();
    }

    public File getFile(File tmpDirectory) {
        StringBuilder sb = new StringBuilder(this._strName.length() + 16);
        sb.append(this.getSource().getID()).append(".").append(this._strName);
        return new File(tmpDirectory, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile(DAOFactory daoFactory, File tmpDirectory) {
        block16: {
            InputStream istream;
            File tmpFile = this.getFile(tmpDirectory);
            if (tmpFile.exists()) {
                return tmpFile;
            }
            if (daoFactory != null && (istream = daoFactory.createObjModelDAO().getBinaryStream(this._dbObjModel)) != null) {
                istream = new InflaterInputStream(istream);
                FileOutputStream oStream = null;
                try {
                    oStream = new FileOutputStream(tmpFile);
                    FileUtility.copyStream((InputStream)istream, (OutputStream)oStream);
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Erreur lors de la copie vers le fichier: " + tmpFile, e);
                    break block16;
                }
                finally {
                    if (oStream != null) {
                        try {
                            oStream.close();
                        }
                        catch (IOException e) {
                            _LOG.finer("Peut pas fermer le fichier: " + tmpFile);
                        }
                    }
                }
                if (tmpFile.exists()) {
                    tmpFile.deleteOnExit();
                    return tmpFile;
                }
            }
        }
        return null;
    }

    public DBObjModel getObjModel() {
        return this._dbObjModel;
    }

    private static enum TypeFile {
        DOC(ResIcoCore.getImageIcon("FOLDER_FILE_DOC")),
        JPG(ResIcoCore.getImageIcon("FOLDER_FILE_JPG")),
        PDF(ResIcoCore.getImageIcon("FOLDER_FILE_PDF")),
        TXT(ResIcoCore.getImageIcon("FOLDER_FILE_TXT")),
        XLS(ResIcoCore.getImageIcon("FOLDER_FILE_XLS")),
        PPT(ResIcoCore.getImageIcon("FOLDER_FILE_PPT")),
        OTH(ResIcoCore.getImageIcon("FOLDER_FILE_TXT"));

        Icon _icon;

        private TypeFile(Icon icon) {
            this._icon = icon;
        }

        public Icon getIcon() {
            return this._icon;
        }
    }
}

