/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.gui;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeRenderer;
import com.dassault.cecilia.core.cecilia.folder.SetFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.SetFolderTreeNode;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class FoldersConfirmDlg
extends JDialogCecilia {
    Collection<DBFolder> _folders;
    protected JTree _ctrlTree;
    JLabel _lblHeader;
    JLabel _lblFooter;

    protected abstract String getLabelTitle();

    protected abstract String getLabelHeader();

    protected abstract String getLabelFooter();

    public FoldersConfirmDlg(Window win, Collection<DBFolder> folders) {
        super(win, true);
        this._folders = folders;
        this.setTitle(this.getLabelTitle());
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(win));
    }

    private void make() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        SetFolderTreeModel model = new SetFolderTreeModel(this._folders);
        this._ctrlTree = new JTree(model);
        this._ctrlTree.setCellRenderer(new DBFolderTreeRenderer());
        this._ctrlTree.setRootVisible(false);
        this._ctrlTree.setRowHeight(ResIcoAbstract.getIconSize());
        JScrollPane scrollPane = new JScrollPane(this._ctrlTree);
        this._ctrlTree.setVisibleRowCount((int)Math.min(7.0 * Math.sqrt(this._folders.size()), 20.0));
        this._lblHeader = new JLabel(this.getLabelHeader());
        panel.add((Component)this._lblHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this._lblFooter = new JLabel(this.getLabelFooter());
        panel.add((Component)this._lblFooter, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.doExpand(model, Collections.singleton(model.getRoot()));
        this.init();
        this.pack();
    }

    protected void doExpand(SetFolderTreeModel model, Collection<SetFolderTreeNode> treeNodes) {
        for (SetFolderTreeNode treeNode : treeNodes) {
            List<SetFolderTreeNode> nodeChildren;
            int nbrChildren;
            Object[] pathNodes;
            if (treeNode.getDBFolder().isVersion() || (pathNodes = model.getPathToRoot(treeNode)) == null || pathNodes.length == 0) continue;
            TreePath treePath = new TreePath(pathNodes);
            if (!this._ctrlTree.isExpanded(treePath)) {
                this._ctrlTree.expandPath(treePath);
            }
            if ((nbrChildren = treeNode.getChildCount()) == 0 || (nodeChildren = treeNode.getChildren()) == null) continue;
            this.doExpand(model, nodeChildren);
        }
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    protected void refreshLabel() {
        this.setTitle(this.getLabelTitle());
        this._lblHeader.setText(this.getLabelHeader());
        this._lblFooter.setText(this.getLabelFooter());
    }
}

