/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.BanStoppedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class AbstractPlugTaskBanWithLog
implements PlugTask {
    private static final Logger _LOG = Logger.getLogger(AbstractPlugTaskBanWithLog.class.getPackage().getName());
    long _uid;
    Plugable _launcher;
    BanInputStream _scriptStream;
    File _traceFile;
    BanEntry _process;
    boolean _requestStop;
    Object _lockerProcess = new Object();
    protected TaskState _state;

    public AbstractPlugTaskBanWithLog(long uid, Plugable launcher, BanEntry entry, BanInputStream scriptStream, File traceFile) {
        this._uid = uid;
        this._launcher = launcher;
        this._process = entry;
        this._scriptStream = scriptStream;
        this._traceFile = traceFile;
        this._state = TaskState.WAIT;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    protected String getDefaultTitle() {
        return this.getInfo("ptask.desc");
    }

    protected abstract String getName();

    protected abstract String getDesc();

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return this.getName();
        }
        if (key.equals("ptask.desc")) {
            return this.getDesc();
        }
        if (this._process != null) {
            return this._process.getInfo(key);
        }
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            switch (this._state) {
                case WAIT: {
                    return ResPlug.getString("TASK_WAIT");
                }
                case INIT: {
                    return ResPlug.getString("TASK_INIT");
                }
                case WORK: {
                    return ResPlug.getString("TASK_WORK");
                }
                case MARK1: {
                    return "Mark1";
                }
                case MARK2: {
                    return "Mark2";
                }
                case FINISH: {
                    return ResPlug.getString("TASK_FINISH");
                }
            }
        }
        if (key.equals("process.p1000")) {
            switch (this._state) {
                case WAIT: {
                    return "-1";
                }
                case INIT: {
                    return "0";
                }
                default: {
                    return "100";
                }
                case FINISH: 
            }
            return "1000";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoCore.getImageIcon("TASK_START");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._state = TaskState.INIT;
        try {
            this._state = TaskState.WORK;
            this._process.execute(this._scriptStream);
            if (!this._requestStop && this._traceFile.length() > 0L) {
                this.displayResult(this._traceFile, true);
            }
        }
        catch (BanStoppedException banStoppedException) {
        }
        catch (Exception e) {
            BanProcessException bpe;
            _LOG.log(Level.FINE, "Exception during task: " + this.getClass().getName(), e);
            e.printStackTrace();
            Throwable exc = e;
            if (e instanceof BanProcessException && (bpe = (BanProcessException)e).getException() != null) {
                exc = bpe.getException();
            }
            try {
                FileWriter out = new FileWriter(this._traceFile, true);
                out.write("\n\n======================================\n");
                out.write(exc.getClass().getSimpleName() + " : ");
                if (exc.getMessage() != null) {
                    out.write(exc.getMessage());
                }
                ((Writer)out).close();
            }
            catch (IOException ioe) {
                _LOG.log(Level.WARNING, "Exception during write trace:" + this.getClass().getName(), ioe);
            }
            this.displayResult(this._traceFile, true);
        }
        finally {
            this._state = TaskState.FINISH;
            Object object = this._lockerProcess;
            synchronized (object) {
                this._process = null;
            }
            this._launcher = null;
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestResume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this._requestStop = true;
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSuspend(boolean high) {
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestSuspend();
        }
    }

    protected void displayResult(File pathInfo, boolean deleteFileOnTrash) {
        try {
            AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                @Override
                protected String getLabel() {
                    return AbstractPlugTaskBanWithLog.this.getDefaultTitle();
                }

                @Override
                public String getInfo(String key) {
                    if (key.equals("ppanel.title")) {
                        return "Info - " + AbstractPlugTaskBanWithLog.this.getDefaultTitle();
                    }
                    if (key.equals("ppanel.default.width")) {
                        return "600";
                    }
                    if (key.equals("ppanel.default.height")) {
                        return "600";
                    }
                    return super.getInfo(key);
                }
            };
            pPane.load(pathInfo, deleteFileOnTrash);
            String addInfo = this.getOptionnalInfo();
            if (addInfo != null) {
                pPane.append(addInfo);
            }
            this._launcher.addPanel(pPane, this._uid);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), "Display result file : " + e1.getMessage(), this.getDefaultTitle(), 0);
        }
    }

    protected String getOptionnalInfo() {
        return null;
    }

    public static enum TaskState {
        WAIT,
        INIT,
        WORK,
        FINISH,
        MARK1,
        MARK2;

    }
}

