/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class AbstractPluginModel
implements PluginModel {
    protected AbstractPluginModel() {
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.key")) {
            return this.getClass().getName();
        }
        if (key.equals("plugin.version")) {
            return "1.01";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCore.getImageIcon("PLUGIN_DEFAULT");
        }
        if (key.equals("plugin.logo")) {
            return ResIcoAbstract.getIconRes((URL)AbstractPluginModel.class.getResource("PluginLogoDA.gif"));
        }
        return null;
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        assert (this.withOption(null));
        return null;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        return this.withOption(null);
    }

    @Override
    public boolean withParameters() {
        return false;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        assert (this.withParameters());
        return null;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        assert (this.withParameters());
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        assert (this.withParameters());
        return null;
    }

    public File createFile(Plugable launcher, String base, String ext) {
        File logFile = null;
        try {
            logFile = File.createTempFile(base, ext);
            logFile.deleteOnExit();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResPlug.getString("ERR_TMP_FILE"), this.getInfo("plugin.name"), 0);
        }
        return logFile;
    }
}

