/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PanelSelectProcess
extends JPanel {
    boolean _withLabel;
    List<PluginMProcess> _listAll;
    String _filter;
    List<PluginMProcess> _listFilter;
    static PluginMProcess __noneProcess = new PluginMProcess(){

        @Override
        public boolean withParameters() {
            return false;
        }

        @Override
        public Object changeParameters(PluginManager parent, Object parameters) {
            return null;
        }

        @Override
        public Object getDefaultParameters(PluginManager plugable) {
            return null;
        }

        @Override
        public IOParameters getIOParameters() {
            return null;
        }

        @Override
        public boolean withOption(Plugable plugable) {
            return false;
        }

        @Override
        public PlugPanel displayOption(Plugable launcher) {
            return null;
        }

        @Override
        public void refreshOptions(Plugable launcher) {
        }

        @Override
        public boolean validOptions(Plugable launcher) {
            return false;
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }

        @Override
        public String getInfo(String key) {
            if (key.equals("plugin.name")) {
                return ResPlug.getString("PROCESS_NONE");
            }
            if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
                return ResPlug.getString("PROCESS_NONE_REMARK");
            }
            if (key.equals(PanelSelectProcess.TYPE_ATTR)) {
                return "PlugProcess";
            }
            if (key.equals("plugin.key")) {
                return PanelSelectProcess.class.getName() + ".None";
            }
            if (key.equals("plugin.version")) {
                return "1.01";
            }
            return null;
        }

        @Override
        public boolean withCriterium(String criterium) {
            return true;
        }

        public String toString() {
            return ResPlug.getString("PROCESS_NONE");
        }

        @Override
        public String writeCommand(Plugable launcher, String filePath, String logPath) {
            return null;
        }

        @Override
        public String writeDefine(Plugable launcher) {
            return null;
        }
    };
    JLabel _lblList = new JLabel(ResPlug.getString("PROCESS_NAME"));
    JComboBox _ctrlList;
    ArrayListModel<PluginMProcess> _modelList;
    private static final String POSTP_ELEM = "post-processor";
    private static final String TYPE_ATTR = "type";

    public PanelSelectProcess(boolean withLabel) {
        super(new GridBagLayout());
        this._withLabel = withLabel;
        this.initialise();
    }

    public void setPlugable(PluginManager plugable) {
        List keyProcesss = plugable.getPlugins("PlugProcess");
        this._listAll = new ArrayList<PluginMProcess>(keyProcesss.size());
        for (String key : keyProcesss) {
            PluginModel plugin = plugable.getPlugin(key);
            if (plugin == null || !(plugin instanceof PluginMProcess)) continue;
            this._listAll.add((PluginMProcess)plugin);
        }
    }

    public void setFilter(String filter) {
        if (filter.equals(this._filter)) {
            return;
        }
        this._filter = filter;
        this._listFilter = new ArrayList<PluginMProcess>();
        this._listFilter.add(__noneProcess);
        for (PluginMProcess plugin : this._listAll) {
            if (!plugin.withCriterium(this._filter)) continue;
            this._listFilter.add(plugin);
        }
        Object selectItem = null;
        if (this._ctrlList != null) {
            selectItem = this._ctrlList.getSelectedItem();
        }
        this._modelList.setList(this._listFilter);
        this._ctrlList.setSelectedItem(__noneProcess);
        if (selectItem != null && this._listFilter.contains(selectItem)) {
            this._ctrlList.setSelectedItem(selectItem);
        }
        this._ctrlList.setEnabled(this._listFilter.size() > 1);
        this._lblList.setEnabled(this._listFilter.size() > 1);
    }

    public PluginMProcess getSelectProcess() {
        if (this._ctrlList == null) {
            return null;
        }
        Object selectItem = this._ctrlList.getSelectedItem();
        if (selectItem == null) {
            return null;
        }
        if (selectItem == __noneProcess) {
            return null;
        }
        if (selectItem instanceof PluginMProcess) {
            return (PluginMProcess)selectItem;
        }
        return null;
    }

    public boolean setSelectProcess(PluginMProcess select) {
        if (this._ctrlList == null || this._listFilter == null) {
            return false;
        }
        if (select == null || this._listFilter.contains(select)) {
            this._ctrlList.setSelectedItem(select);
            return true;
        }
        return false;
    }

    public boolean setSelectProcessFromKey(String select) {
        if (this._ctrlList == null || this._listFilter == null) {
            return false;
        }
        if (select == null) {
            this._ctrlList.setSelectedItem(__noneProcess);
            return true;
        }
        for (int i = this._listFilter.size() - 1; i >= 0; --i) {
            PluginMProcess plugin = this._listFilter.get(i);
            if (!select.equals(plugin.getInfo("plugin.key"))) continue;
            this._ctrlList.setSelectedItem(plugin);
            return true;
        }
        this._ctrlList.setSelectedItem(__noneProcess);
        return false;
    }

    public Component getLabel() {
        return this._lblList;
    }

    private void initialise() {
        int row = 0;
        if (this._withLabel) {
            this.add((Component)this._lblList, new GridBagConstraints(row++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        }
        this._modelList = new ArrayListModel();
        if (this._listFilter != null) {
            this._modelList.setList(this._listFilter);
        }
        this._ctrlList = new JComboBox<PluginMProcess>(this._modelList);
        this.add((Component)this._ctrlList, new GridBagConstraints(row++, 0, 1, 1, 10.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlList.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object current;
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String info = null;
                if (index >= 0 && index < list.getModel().getSize() && (current = list.getModel().getElementAt(index)) instanceof PluginModel) {
                    PluginModel plugin = (PluginModel)current;
                    info = plugin.getInfo("plugin.description");
                }
                if (info != null && info.trim().length() == 0) {
                    info = null;
                }
                if (info != null) {
                    StringBuffer sb = new StringBuffer(128);
                    sb.append("<html>").append(info).append("</html>");
                    info = sb.toString();
                    info = info.replaceAll("\n", "<br>");
                    info = info.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                    info = info.replaceAll(" ", "&nbsp;");
                }
                list.setToolTipText(info);
                return result;
            }
        });
    }

    public void doSave(IndentWriter out) throws IOException {
        out.write("<");
        out.write(POSTP_ELEM);
        out.write(" ");
        out.write(TYPE_ATTR);
        out.write("=\"");
        out.write(((PluginMProcess)this._ctrlList.getSelectedItem()).getInfo("plugin.key"));
        out.write("\"/>\n");
    }

    public void doLoad(Element root) {
        String valueType;
        Node postPNode;
        if (this._listAll == null || this._listAll.isEmpty()) {
            return;
        }
        NodeList nodes = root.getElementsByTagName(POSTP_ELEM);
        Node node = postPNode = nodes == null ? null : nodes.item(0);
        if (postPNode == null) {
            return;
        }
        Node postPType = postPNode.getAttributes().getNamedItem(TYPE_ATTR);
        String string = valueType = postPType == null ? null : postPType.getFirstChild().getNodeValue();
        if (valueType != null) {
            for (PluginMProcess plug : this._listAll) {
                if (!valueType.equals(plug.getInfo("plugin.key"))) continue;
                this._ctrlList.setSelectedItem(plug);
                break;
            }
        }
    }
}

