/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.ItemDescriptor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginAction {
    private String _pluginKey = null;
    PluginModel _plugin = null;
    Object _parameters = null;
    private String _name = "";
    String _iconPath = "";
    String _shortcut = "";
    String _tooltip = "";

    PluginAction(String pluginKey, PluginModel plugin, PluginManager plugable) {
        this._pluginKey = pluginKey;
        this._plugin = plugin;
        if (this._plugin.withParameters()) {
            this._parameters = this._plugin.getDefaultParameters(plugable);
        }
    }

    public void readNode(Node node, PluginModel plugin, com.dassault.cecilia.core.pluginmanager.PluginManager pluginManager) {
        Node attr = node.getAttributes().getNamedItem("NAME");
        if (attr != null) {
            this._name = attr.getNodeValue();
        }
        if ((attr = node.getAttributes().getNamedItem("ICON_PATH")) != null) {
            this._iconPath = attr.getNodeValue();
        }
        if ((attr = node.getAttributes().getNamedItem("SHORTCUT")) != null) {
            this._shortcut = attr.getNodeValue();
        }
        if ((attr = node.getAttributes().getNamedItem("TOOLTIP")) != null) {
            this._tooltip = attr.getNodeValue();
        }
        String parameterTag = plugin.getInfo("plugin.parameterTag");
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (plugin.withParameters() && child.getNodeName().equals(parameterTag)) {
                this._parameters = plugin.getIOParameters().readXML(child, pluginManager);
                continue;
            }
            if (!child.getNodeName().equals("ATTACHABLE_COMPONENT")) continue;
            ItemDescriptor itemDescriptor = new ItemDescriptor(this);
            itemDescriptor.readNode(child);
            pluginManager.loadAttachableComponent(itemDescriptor);
        }
    }

    public void write(BufferedWriter writer, PluginModel plugin, com.dassault.cecilia.core.pluginmanager.PluginManager pluginManager) throws IOException {
        writer.write("    <PLUGIN_ACTION ");
        if (this._name.length() > 0) {
            writer.write("NAME=\"" + this._name + "\" ");
        }
        if (this._iconPath.length() > 0) {
            writer.write("ICON_PATH=\"" + this._iconPath + "\" ");
        }
        if (this._shortcut.length() > 0) {
            writer.write("SHORTCUT=\"" + this._shortcut + "\" ");
        }
        if (this._tooltip.length() > 0) {
            writer.write("TOOLTIP=\"" + this._tooltip + "\" ");
        }
        writer.write(">");
        writer.newLine();
        if (plugin.withParameters()) {
            try {
                StringWriter w = new StringWriter();
                plugin.getIOParameters().writeXML(w, this._parameters, pluginManager);
                w.close();
                writer.write("      ");
                writer.write(w.toString());
                writer.newLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.writePluginItems(writer, pluginManager);
        writer.write("    </PLUGIN_ACTION>");
        writer.newLine();
    }

    public void writePluginItems(BufferedWriter writer, com.dassault.cecilia.core.pluginmanager.PluginManager pluginManager) throws IOException {
        for (ItemDescriptor itemDescriptor : pluginManager.getItemDescriptors(this)) {
            itemDescriptor.write(writer);
        }
    }

    public String getPluginKey() {
        return this._pluginKey;
    }

    public String getName() {
        if (this._name.length() != 0) {
            return this._name;
        }
        return this._plugin.getInfo("plugin.name");
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getShortcut() {
        if (this._shortcut.length() != 0) {
            return this._shortcut;
        }
        return this._plugin.getInfo("plugin.shortcut");
    }

    public void setShortcut(String shortcut) {
        this._shortcut = shortcut == null ? "" : shortcut;
    }

    public String getTooltip() {
        if (this._tooltip.length() != 0) {
            return this._tooltip;
        }
        return this._plugin.getInfo("plugin.tooltip");
    }

    public void setTooltip(String tooltip) {
        this._tooltip = tooltip == null ? "" : tooltip;
    }

    public String getIconPath() {
        return this._iconPath;
    }

    public void setIconPath(String iconPath) {
        this._iconPath = iconPath == null ? "" : iconPath;
    }

    public Object getParameters() {
        return this._parameters;
    }

    public void setParameters(Object parameters) {
        this._parameters = parameters;
    }

    public String toString() {
        return this._name;
    }
}

