/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMCompiler;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.AbstractAttachableComponentDescriptor;
import com.dassault.cecilia.core.pluginmanager.AttachableComponentDescriptor;
import com.dassault.cecilia.core.pluginmanager.ErrorManager;
import com.dassault.cecilia.core.pluginmanager.ItemDescriptor;
import com.dassault.cecilia.core.pluginmanager.MenuDescriptor;
import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.PluginAction;
import com.dassault.cecilia.core.pluginmanager.PluginDescriptor;
import com.dassault.cecilia.core.pluginmanager.PluginType;
import com.dassault.cecilia.core.pluginmanager.PostProcessStore;
import com.dassault.cecilia.core.pluginmanager.Util;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PluginManager
implements com.dassault.cecilia.core.plugin.PluginManager {
    private static final Logger _LOG = Logger.getLogger(PluginManager.class.getPackage().getName());
    public static String PLUGIN_PATH = System.getProperty("cecilia.plugin.path", ".");
    public static final String PLUGIN_FILE = System.getProperty("cecilia.plugin.name", "plugins.xml");
    public static final String DEFAULT_PLUGIN_FILE = System.getProperty("cecilia.plugin.default", "./defaultplugins.xml");
    public static final String BAK_PLUGIN_FILE = PLUGIN_FILE + "~";
    public static final String XML_TAG_JAR = "JAR";
    public static final String XML_TAG_PLUGIN = "PLUGIN";
    public static final String XML_TAG_PLUGINS = "PLUGINS";
    public static final String XML_ATT_KEY = "KEY";
    public static final String XML_TAG_PLUGIN_ACTION = "PLUGIN_ACTION";
    public static final String XML_ATT_PATH = "PATH";
    public static final String XML_ATT_TYPE = "TYPE";
    public static final String XML_TAG_ATTACHABLE_COMPONENT = "ATTACHABLE_COMPONENT";
    public static final String XML_ATT_CONTAINER_TYPE = "CONTAINER_TYPE";
    public static final String XML_ATT_CONTAINER_PATH = "CONTAINER_PATH";
    public static final String XML_ATT_POSITION = "POSITION";
    public static final String XML_ATT_NAME = "NAME";
    public static final String XML_ATT_ICON_PATH = "ICON_PATH";
    public static final String XML_ATT_ICON_TYPE = "ICON_TYPE";
    public static final String XML_ATT_SHORTCUT = "SHORTCUT";
    public static final String XML_ATT_TOOLTIP = "TOOLTIP";
    public static final String PLUGIN_MACTION_TYPE = "PluginAction";
    public static final String PLUGIN_MSTEPPER_TYPE = "PluginStepper";
    public static final String PLUGIN_MTRANSLATE_TYPE = "PluginTranslate";
    public static final String PLUGIN_MCOMPILER_TYPE = "PluginCompiler";
    public static final String PLUGIN_MTREATMENT_TYPE = "PluginTreatment";
    private Map<String, PluginType> _typeKeyList = new TreeMap<String, PluginType>();
    private Plugable _plugable;
    private PluginStore _pluginStore = new PluginStore();
    private ActionStore _actionStore = new ActionStore();
    private ItemStore _itemStore = new ItemStore();
    private PostProcessStore _postProcessStore = new PostProcessStore();
    private List _attachables = new ArrayList();
    private PluginURLClassLoader _classLoader = null;
    private String _pluginPath = null;
    private File _pluginFile = null;

    ClassLoader getClassLoader() {
        if (this._classLoader != null) {
            return this._classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public PluginManager(Plugable plugable) {
        this._plugable = plugable;
        this.init();
    }

    private void init() {
        this._typeKeyList.put(PLUGIN_MACTION_TYPE, new PluginType(PLUGIN_MACTION_TYPE, "Action", "", "pluginActionImage"));
        this._typeKeyList.put(PLUGIN_MSTEPPER_TYPE, new PluginType(PLUGIN_MSTEPPER_TYPE, "Stepper", "", "pluginStepperImage"));
        this._typeKeyList.put(PLUGIN_MTRANSLATE_TYPE, new PluginType(PLUGIN_MTRANSLATE_TYPE, "Translate", "", "pluginTranslateImage"));
        this._typeKeyList.put(PLUGIN_MTREATMENT_TYPE, new PluginType(PLUGIN_MTREATMENT_TYPE, "Treatment", "", "pluginTreatmentImage"));
        this._typeKeyList.put(PLUGIN_MCOMPILER_TYPE, new PluginType(PLUGIN_MCOMPILER_TYPE, "Compiler", "", "pluginCompilerImage"));
    }

    PluginType getPluginType(String typeKey) {
        return this._typeKeyList.get(typeKey);
    }

    PostProcessStore getPostProcessStore() {
        return this._postProcessStore;
    }

    private void addJar(File jarFile) {
        try {
            String path = jarFile.getCanonicalPath();
            URL url = jarFile.toURI().toURL();
            if (this._classLoader == null) {
                URL[] urls = new URL[]{url};
                String[] jars = new String[]{path};
                this._classLoader = new PluginURLClassLoader(urls, jars, this.getClass().getClassLoader());
            } else {
                this._classLoader.addJar(url, path);
            }
        }
        catch (MalformedURLException e) {
            _LOG.log(Level.WARNING, "Exception during addJar: " + jarFile.toString(), e);
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "Exception during addJar: " + jarFile.toString(), e);
        }
    }

    String getJarPathOfClass(String className) {
        if (this._classLoader == null) {
            return null;
        }
        return this._classLoader.findPath(className);
    }

    boolean isJarExist(File jarFile) {
        if (this._classLoader == null) {
            return false;
        }
        try {
            String path = jarFile.getCanonicalPath();
            return this._classLoader.contains(path);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Exception isJarExist: " + jarFile.toString(), e);
            return false;
        }
    }

    void removeJar(String jarPath) {
        if (this._classLoader != null) {
            this._classLoader.removeJar(jarPath);
        }
    }

    public Collection<String> getJars() {
        if (this._classLoader == null) {
            return new ArrayList<String>();
        }
        return this._classLoader._jars;
    }

    boolean addPlugin(PluginModel plugin, PluginDescriptor descriptor) {
        if (plugin instanceof PluginMAction) {
            this._pluginStore.add(PLUGIN_MACTION_TYPE, plugin, descriptor);
        } else if (plugin instanceof PluginMCompiler) {
            this._pluginStore.add(PLUGIN_MCOMPILER_TYPE, plugin, descriptor);
        } else if (plugin instanceof PluginMStepper) {
            this._pluginStore.add(PLUGIN_MSTEPPER_TYPE, plugin, descriptor);
        } else if (plugin instanceof PluginMTranslate) {
            this._pluginStore.add(PLUGIN_MTRANSLATE_TYPE, plugin, descriptor);
        } else if (plugin instanceof PluginMTreatment) {
            this._pluginStore.add(PLUGIN_MTREATMENT_TYPE, plugin, descriptor);
        }
        return true;
    }

    boolean removePlugin(String pluginKey) {
        PluginModel plugin = this.getPlugin(pluginKey);
        if (plugin instanceof PluginMAction) {
            return this._pluginStore.remove(PLUGIN_MACTION_TYPE, pluginKey);
        }
        if (plugin instanceof PluginMCompiler) {
            return this._pluginStore.remove(PLUGIN_MCOMPILER_TYPE, pluginKey);
        }
        if (plugin instanceof PluginMStepper) {
            return this._pluginStore.remove(PLUGIN_MSTEPPER_TYPE, pluginKey);
        }
        if (plugin instanceof PluginMTranslate) {
            return this._pluginStore.remove(PLUGIN_MTRANSLATE_TYPE, pluginKey);
        }
        if (plugin instanceof PluginMTreatment) {
            return this._pluginStore.remove(PLUGIN_MTREATMENT_TYPE, pluginKey);
        }
        return true;
    }

    List getPlugins() {
        return this.getPlugins(null);
    }

    @Override
    public List getPlugins(String typeKey) {
        if (typeKey == null) {
            ArrayList plugins = new ArrayList();
            for (String type : this._typeKeyList.keySet()) {
                plugins.addAll(this._pluginStore.getPlugins(type));
            }
            return plugins;
        }
        if (typeKey.equals("PlugProcess")) {
            return this._postProcessStore.getKeyPlugins();
        }
        return this._pluginStore.getPlugins(typeKey);
    }

    public List getPlugins(String typeKey, String subTypeKey) {
        return this._pluginStore.getPlugins(typeKey, subTypeKey);
    }

    @Override
    public PluginModel getPlugin(String pluginKey) {
        PluginModel plugin = this._postProcessStore.getPlugin(pluginKey);
        if (plugin != null) {
            return plugin;
        }
        for (String typeKey : this._typeKeyList.keySet()) {
            plugin = this._pluginStore.getPlugin(typeKey, pluginKey);
            if (plugin == null) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public Window getWindow() {
        if (this._plugable != null) {
            return this._plugable.getWindow();
        }
        return null;
    }

    @Override
    public String getInfo(String key) {
        if (this._plugable != null) {
            return this._plugable.getInfo(key);
        }
        return null;
    }

    PluginDescriptor getPluginDescriptor(String pluginKey) {
        return this._pluginStore.getPluginDescriptor(pluginKey);
    }

    List addPlugins(File jarFile) {
        this.addJar(jarFile);
        ArrayList<String> plugins = new ArrayList<String>();
        List entries = this.getPluginZipEntries(jarFile);
        for (ZipEntry entry : entries) {
            String className = entry.getName().substring(0, entry.getName().length() - 6);
            PluginModel plugin = this.loadPluginModelClass(className = className.replace('/', '.'));
            if (!this.isPluginValid(plugin)) {
                ErrorManager errMgr = new ErrorManager();
                String msg = errMgr.Get(Messages.getString("PluginManager.22"), className);
                errMgr.displayError(this._plugable.getWindow(), msg);
                continue;
            }
            String pluginKey = className;
            String pluginName = plugin.getInfo("plugin.name");
            PluginDescriptor pluginDescriptor = new PluginDescriptor(pluginKey, pluginName, jarFile.getPath());
            if (!this.addPlugin(plugin, pluginDescriptor)) continue;
            plugins.add(pluginKey);
        }
        return plugins;
    }

    private boolean isPluginValid(PluginModel plugin) {
        String name = plugin.getInfo("plugin.name");
        if (name == null || name.length() == 0) {
            return false;
        }
        String type = plugin.getInfo("type");
        if (type == null || type.length() == 0) {
            return false;
        }
        return type.equals(PLUGIN_MACTION_TYPE) || type.equals(PLUGIN_MCOMPILER_TYPE) || type.equals(PLUGIN_MSTEPPER_TYPE) || type.equals(PLUGIN_MTRANSLATE_TYPE) || type.equals(PLUGIN_MTREATMENT_TYPE);
    }

    private List getPluginZipEntries(File jarFile) {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        ZipFile zipFile = this.getZipFile(jarFile);
        if (zipFile == null) {
            return entries;
        }
        PluginURLClassLoader loader = this._classLoader;
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!this.isPlugin(loader, entry)) continue;
            entries.add(entry);
        }
        return entries;
    }

    private ZipFile getZipFile(File jarFile) {
        try {
            return new ZipFile(jarFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isPlugin(ClassLoader loader, ZipEntry entry) {
        try {
            if (!entry.getName().endsWith(".class")) {
                return false;
            }
            if (entry.getName().contains("$")) {
                return false;
            }
            String name = entry.getName().substring(0, entry.getName().length() - 6);
            Class<?> theClass = loader.loadClass(name = name.replace('/', '.'));
            if (!PluginModel.class.isAssignableFrom(theClass)) {
                return false;
            }
            Object instance = theClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (instance instanceof PluginMAction) {
                return true;
            }
            if (instance instanceof PluginMCompiler) {
                return true;
            }
            if (instance instanceof PluginMStepper) {
                return true;
            }
            if (instance instanceof PluginMTranslate) {
                return true;
            }
            return instance instanceof PluginMTreatment;
        }
        catch (Exception e) {
            return false;
        }
    }

    List getPluginActions(String pluginKey) {
        return this._actionStore.getPluginActions(pluginKey);
    }

    void loadPluginAction(PluginAction action) {
        this._actionStore.load(action);
    }

    void addPluginAction(PluginAction action) {
        this._actionStore.add(action);
    }

    boolean removePluginAction(PluginAction action) {
        return this._actionStore.remove(action);
    }

    List getItemDescriptors(PluginAction action) {
        return this._itemStore.getItemDescriptors(action);
    }

    List getAttachableComponents() {
        return this._attachables;
    }

    void loadAttachableComponent(AttachableComponentDescriptor attachable) {
        this._attachables.add(attachable);
        if (attachable instanceof ItemDescriptor) {
            this._itemStore.load((ItemDescriptor)attachable);
        }
    }

    void addAttachableComponent(AttachableComponentDescriptor attachable) {
        this._attachables.add(attachable);
        if (attachable instanceof ItemDescriptor) {
            this._itemStore.add((ItemDescriptor)attachable);
        }
        this.updatePositionOnAdd(attachable, attachable.getPosition());
    }

    boolean removeAttachableComponent(AttachableComponentDescriptor attachable) {
        boolean b = this._attachables.remove(attachable);
        if (attachable instanceof ItemDescriptor) {
            this._itemStore.remove((ItemDescriptor)attachable);
        }
        this.updatePositionOnRemove(attachable, attachable.getPosition());
        return b;
    }

    void moveAttachableComponent(AttachableComponentDescriptor attachable, int newPosition) {
        int lastPosition = attachable.getPosition();
        attachable.setPosition(newPosition);
        this.updatePositionOnMove(attachable, lastPosition, newPosition);
    }

    public String getPluginPath() {
        if (this._pluginFile != null) {
            return this._pluginFile.getParent();
        }
        if (this._pluginPath != null) {
            return this._pluginPath;
        }
        return ".";
    }

    @Deprecated
    public boolean loadPlugins(File pluginFile) throws IOException {
        if (this._pluginFile != null) {
            throw new IOException("Plugin file already loaded");
        }
        this._pluginFile = pluginFile;
        if (this._pluginFile == null) {
            throw new IOException("Plugin file does not exist");
        }
        if (this._pluginFile.exists()) {
            return this.readPlugins(this._pluginFile);
        }
        File parent = this._pluginFile.getParentFile();
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException("Plugin file not accessible");
        }
        if (!parent.canWrite()) {
            throw new IOException("Plugin path not writable");
        }
        File refFile = new File(DEFAULT_PLUGIN_FILE);
        if (!refFile.exists()) {
            throw new IOException("Plugin reference file does not exist");
        }
        boolean bReadDefaultPlugins = this.readPlugins(refFile);
        if (!bReadDefaultPlugins) {
            throw new IOException("Error during read reference file (default plugin file)");
        }
        return this.write();
    }

    public boolean loadPlugins(InputStream stream, String pluginPath) throws IOException {
        this._pluginPath = pluginPath;
        return this.readPlugins(new InputSource(stream), pluginPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readPlugins(File file) throws IOException {
        try (InputStream input = null;){
            input = new BufferedInputStream(new FileInputStream(file));
            boolean bl = this.readPlugins(new InputSource(input), file.getParent());
            return bl;
        }
    }

    private boolean readPlugins(InputSource source, String pluginPath) throws IOException {
        try {
            Node child;
            int i;
            Document document = Util.checkXml(source);
            if (document == null) {
                throw new IOException("Plugin source is corrupted.");
            }
            NodeList childs = document.getLastChild().getChildNodes();
            for (i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (!child.getNodeName().equals(XML_TAG_JAR)) continue;
                Node path = child.getAttributes().getNamedItem(XML_ATT_PATH);
                if (path == null) {
                    _LOG.log(Level.INFO, "PluginXML - JAR without PATH: " + child);
                    continue;
                }
                String pathNode = path.getNodeValue();
                File jarFile = new File(pathNode);
                if (jarFile.isAbsolute()) {
                    if (jarFile.exists() && jarFile.canRead()) {
                        this.addJar(jarFile);
                        continue;
                    }
                    _LOG.log(Level.INFO, "PluginXML - JAR with PATH no correct: " + path.getNodeValue());
                    continue;
                }
                jarFile = new File(pluginPath, pathNode);
                if (jarFile.exists() && jarFile.canRead()) {
                    this.addJar(jarFile);
                    continue;
                }
                _LOG.log(Level.INFO, "PluginXML - JAR with PATH no correct: " + path.getNodeValue());
            }
            for (i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (!child.getNodeName().equals(XML_TAG_PLUGIN)) continue;
                this.readPluginNode(child);
            }
            for (i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (!child.getNodeName().equals(XML_TAG_ATTACHABLE_COMPONENT)) continue;
                this.readAttachableComponentNode(child);
            }
            this._postProcessStore.load(childs, this);
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            _LOG.log(Level.FINE, "Error during read plugin file", e);
            throw new IOException(e.getMessage());
        }
    }

    private PluginDescriptor readPluginNode(Node node) {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        PluginModel plugin = pluginDescriptor.readNode(node, this);
        if (plugin == null) {
            return null;
        }
        this.addPlugin(plugin, pluginDescriptor);
        return pluginDescriptor;
    }

    private AttachableComponentDescriptor readAttachableComponentNode(Node node) {
        String type = node.getAttributes().getNamedItem(XML_ATT_TYPE).getNodeValue();
        AbstractAttachableComponentDescriptor descriptor = AbstractAttachableComponentDescriptor.newInstance(type);
        descriptor.readNode(node);
        this.loadAttachableComponent(descriptor);
        return descriptor;
    }

    public boolean write() {
        File pluginFile = new File(PLUGIN_PATH, PLUGIN_FILE);
        String filePath = pluginFile.getAbsolutePath();
        try {
            File tmpFile = File.createTempFile("plugins", ".xml");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            writer.write("<PLUGINS>");
            writer.newLine();
            writer.newLine();
            writer.write("  <!-- All jars -->\n");
            for (String pathJar : this.getJars()) {
                pathJar = pathJar.replaceAll("\\\\", "/");
                writer.write("  <JAR PATH=\"" + pathJar + "\"/>");
                writer.newLine();
            }
            writer.newLine();
            writer.write("  <!-- All Plugins -->\n");
            this.writePlugins(writer);
            writer.newLine();
            writer.write("  <!-- All others -->\n");
            this.writeAttachableComponents(writer);
            writer.newLine();
            writer.write("  <!-- Post-Process  -->\n");
            this._postProcessStore.save(writer, this);
            writer.newLine();
            writer.write("</PLUGINS>");
            writer.newLine();
            writer.close();
            if (!Util.copyFile(tmpFile.getAbsolutePath(), filePath)) {
                throw new IOException();
            }
            tmpFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorManager errMgr = new ErrorManager();
            String msg = errMgr.Get(Messages.getString("PluginManager.3"), pluginFile.getAbsolutePath());
            errMgr.displayError(this._plugable.getWindow(), msg);
            return false;
        }
        return true;
    }

    private void writeAttachableComponents(BufferedWriter writer) throws IOException {
        Iterator attachables = this._attachables.iterator();
        StringWriter bufContainers = new StringWriter();
        BufferedWriter wrContainers = new BufferedWriter(bufContainers);
        StringWriter bufAttachables = new StringWriter();
        BufferedWriter wrAttachables = new BufferedWriter(bufAttachables);
        while (attachables.hasNext()) {
            BufferedWriter w;
            StringWriter buf;
            AttachableComponentDescriptor attachable = (AttachableComponentDescriptor)attachables.next();
            if (attachable instanceof ItemDescriptor) continue;
            if (attachable instanceof MenuDescriptor) {
                buf = new StringWriter();
                w = new BufferedWriter(buf);
                try {
                    attachable.write(w);
                    w.close();
                    wrContainers.write(buf.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            buf = new StringWriter();
            w = new BufferedWriter(buf);
            try {
                attachable.write(w);
                w.close();
                wrAttachables.write(buf.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        wrContainers.close();
        wrAttachables.close();
        writer.write(bufContainers.toString());
        writer.write(bufAttachables.toString());
    }

    private boolean writePlugins(BufferedWriter writer) throws IOException {
        for (String pluginKey : this.getPlugins()) {
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(pluginKey);
            PluginModel plugin = this.getPlugin(pluginKey);
            StringWriter buf = new StringWriter();
            BufferedWriter w = new BufferedWriter(buf);
            try {
                pluginDescriptor.write(w, plugin, this);
                w.close();
                writer.write(buf.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    PluginModel loadPluginModelClass(String className) {
        try {
            ClassLoader loader = this.getClassLoader();
            PluginModel plugin = (PluginModel)loader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return plugin;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "PluginManager::loadPluginModelClass: " + className, e);
            return null;
        }
    }

    void updatePositionOnAdd(AttachableComponentDescriptor descriptor, int position) {
        for (AttachableComponentDescriptor descr : this.getAttachableComponents()) {
            if (descr == descriptor || !descr.getContainerType().equals(descriptor.getContainerType()) || !descr.getContainerPath().equals(descriptor.getContainerPath()) || descr.getPosition() < position) continue;
            descr.setPosition(descr.getPosition() + 1);
        }
    }

    void updatePositionOnRemove(AttachableComponentDescriptor descriptor, int position) {
        for (AttachableComponentDescriptor descr : this.getAttachableComponents()) {
            if (!descr.getContainerType().equals(descriptor.getContainerType()) || !descr.getContainerPath().equals(descriptor.getContainerPath()) || descr.getPosition() <= position) continue;
            descr.setPosition(descr.getPosition() - 1);
        }
    }

    void updatePositionOnMove(AttachableComponentDescriptor descriptor, int lastPosition, int newPosition) {
        int min = Math.min(lastPosition, newPosition);
        int max = Math.max(lastPosition, newPosition);
        int dec = lastPosition < newPosition ? -1 : (lastPosition > newPosition ? 1 : 0);
        for (AttachableComponentDescriptor descr : this.getAttachableComponents()) {
            if (descr == descriptor || !descr.getContainerType().equals(descriptor.getContainerType()) || !descr.getContainerPath().equals(descriptor.getContainerPath()) || descr.getPosition() < min || descr.getPosition() > max) continue;
            descr.setPosition(descr.getPosition() + dec);
        }
    }

    public void clear() {
        this._attachables.clear();
        this._itemStore._items.clear();
        this._actionStore._actions.clear();
        this._pluginStore.pluginDescriptors.clear();
        this._pluginStore.plugins.clear();
        this._postProcessStore.clear();
        if (this._classLoader != null) {
            this._classLoader._jars.clear();
            this._classLoader._urls.clear();
        }
    }

    class PluginURLClassLoader
    extends URLClassLoader {
        List<URL> _urls;
        List<String> _jars;
        String _defPath;

        public PluginURLClassLoader(URL[] urls, String[] jarPath, ClassLoader parent) {
            super(urls, parent);
            this._urls = new ArrayList<URL>();
            this._jars = new ArrayList<String>();
            this._defPath = PluginManager.this.getPluginPath();
            for (int i = 0; i < urls.length; ++i) {
                if (urls[i] == null) continue;
                this._urls.add(urls[i]);
                this._jars.add(FileUtility.getDiffPath((String)this._defPath, (String)jarPath[i]));
            }
        }

        private void addJar(URL url, String jarPath) {
            String path = FileUtility.getDiffPath((String)this._defPath, (String)jarPath);
            if (!this._jars.contains(path)) {
                this._jars.add(path);
                this._urls.add(url);
                this.addURL(url);
            }
        }

        private boolean contains(String path) {
            path = FileUtility.getDiffPath((String)this._defPath, (String)path);
            for (int i = 0; i < this._jars.size(); ++i) {
                if (!this._jars.get(i).equalsIgnoreCase(path)) continue;
                return true;
            }
            return false;
        }

        private String findPath(String className) {
            String classPath = className.replace('.', '/') + ".class";
            for (int i = 0; i < this._urls.size(); ++i) {
                try {
                    ZipFile zipFile;
                    File jarFile = new File(this._jars.get(i));
                    if (!jarFile.isAbsolute()) {
                        jarFile = new File(this._defPath + File.separator + this._jars.get(i));
                    }
                    if ((zipFile = new ZipFile(jarFile)).getEntry(classPath) == null) continue;
                    return this._jars.get(i);
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Exception during findPath: " + this._jars.get(i));
                }
            }
            return "[classpath]" + File.separatorChar + "[default]";
        }

        private void removeJar(String jarPath) {
            String path = FileUtility.getDiffPath((String)this._defPath, (String)jarPath);
            int idx = this._jars.indexOf(path);
            if (idx >= 0) {
                this._jars.remove(idx);
                this._urls.remove(idx);
            }
        }
    }

    class ItemStore {
        private Map _items = new HashMap();

        ItemStore() {
        }

        void load(ItemDescriptor itemDescriptor) {
            PluginAction action = itemDescriptor.getAction();
            ArrayList<ItemDescriptor> list = (ArrayList<ItemDescriptor>)this._items.get(action);
            if (list == null) {
                list = new ArrayList<ItemDescriptor>();
                this._items.put(action, list);
            }
            list.add(itemDescriptor);
        }

        void add(ItemDescriptor itemDescriptor) {
            PluginAction action = itemDescriptor.getAction();
            ArrayList<ItemDescriptor> list = (ArrayList<ItemDescriptor>)this._items.get(action);
            if (list == null) {
                list = new ArrayList<ItemDescriptor>();
                this._items.put(action, list);
            }
            list.add(itemDescriptor);
        }

        boolean remove(ItemDescriptor itemDescriptor) {
            List list = (List)this._items.get(itemDescriptor.getAction());
            if (list == null) {
                return false;
            }
            boolean b = list.remove(itemDescriptor);
            return b;
        }

        void move(ItemDescriptor itemDescriptor, int position) {
            itemDescriptor.setPosition(position);
        }

        List getItemDescriptors() {
            ArrayList items = new ArrayList();
            Iterator iterator = this._items.values().iterator();
            while (iterator.hasNext()) {
                items.addAll((Collection)iterator.next());
            }
            return items;
        }

        List getItemDescriptors(PluginAction action) {
            return this._items.get(action) == null ? new ArrayList() : (List)this._items.get(action);
        }
    }

    class ActionStore {
        private Map _actions = new HashMap();

        ActionStore() {
        }

        void load(PluginAction action) {
            ArrayList<PluginAction> list = (ArrayList<PluginAction>)this._actions.get(action.getPluginKey());
            if (list == null) {
                list = new ArrayList<PluginAction>();
                this._actions.put(action.getPluginKey(), list);
            }
            list.add(action);
        }

        void add(PluginAction action) {
            ArrayList<PluginAction> list = (ArrayList<PluginAction>)this._actions.get(action.getPluginKey());
            if (list == null) {
                list = new ArrayList<PluginAction>();
                this._actions.put(action.getPluginKey(), list);
            }
            list.add(action);
        }

        boolean remove(PluginAction action) {
            List list = (List)this._actions.get(action.getPluginKey());
            if (list == null) {
                return false;
            }
            boolean b = list.remove(action);
            return b;
        }

        List getPluginActions() {
            ArrayList actions = new ArrayList();
            for (Collection col : this._actions.values()) {
                if (col == null) continue;
                actions.addAll(col);
            }
            return actions;
        }

        List getPluginActions(String pluginKey) {
            return this._actions.get(pluginKey) == null ? new ArrayList() : (List)this._actions.get(pluginKey);
        }
    }

    class PluginStore {
        Map plugins = new TreeMap();
        Map pluginDescriptors = new HashMap();

        PluginStore() {
        }

        public List<String> getPlugins(String typeKey, String subTypeKey) {
            ArrayList<String> lst = new ArrayList<String>();
            Map entrie = (Map)this.plugins.get(typeKey);
            if (entrie == null) {
                return lst;
            }
            for (String key : entrie.keySet()) {
                PluginModel plugin = (PluginModel)entrie.get(key);
                String stype = plugin.getInfo("sub-type");
                if (stype == null || !stype.equals(subTypeKey)) continue;
                lst.add(key);
            }
            return lst;
        }

        PluginModel add(String pluginType, PluginModel plugin, PluginDescriptor descriptor) {
            TreeMap<String, PluginModel> entrie = (TreeMap<String, PluginModel>)this.plugins.get(pluginType);
            if (entrie == null) {
                entrie = new TreeMap<String, PluginModel>();
                this.plugins.put(pluginType, entrie);
            }
            PluginModel oldPlugin = entrie.put(descriptor.getKey(), plugin);
            this.pluginDescriptors.put(descriptor.getKey(), descriptor);
            return oldPlugin;
        }

        boolean remove(String pluginType, String pluginKey) {
            boolean removed;
            Map entrie = (Map)this.plugins.get(pluginType);
            if (entrie == null) {
                return false;
            }
            boolean bl = removed = entrie.remove(pluginKey) != null;
            if (removed) {
                this.pluginDescriptors.remove(pluginKey);
            }
            return removed;
        }

        PluginModel getPlugin(String pluginType, String name) {
            Map entrie = (Map)this.plugins.get(pluginType);
            if (entrie == null) {
                return null;
            }
            return (PluginModel)entrie.get(name);
        }

        PluginDescriptor getPluginDescriptor(String pluginKey) {
            return (PluginDescriptor)this.pluginDescriptors.get(pluginKey);
        }

        List getPlugins(String pluginType) {
            ArrayList lst = new ArrayList();
            Map entrie = (Map)this.plugins.get(pluginType);
            if (entrie == null) {
                return lst;
            }
            lst.addAll(entrie.keySet());
            return lst;
        }

        List getDescriptors() {
            ArrayList lst = new ArrayList();
            lst.addAll(this.pluginDescriptors.values());
            return lst;
        }
    }
}

