/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.AttachableComponent;
import com.dassault.cecilia.core.pluginmanager.AttachableComponentDescriptor;
import com.dassault.cecilia.core.pluginmanager.EditMenuDlg;
import com.dassault.cecilia.core.pluginmanager.EditPluginActionDlg;
import com.dassault.cecilia.core.pluginmanager.ErrorManager;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.pluginmanager.ItemDescriptor;
import com.dassault.cecilia.core.pluginmanager.Menu;
import com.dassault.cecilia.core.pluginmanager.MenuDescriptor;
import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.PluginAction;
import com.dassault.cecilia.core.pluginmanager.PluginDescriptor;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PluginType;
import com.dassault.cecilia.core.pluginmanager.PostProcessPluginsPanel;
import com.dassault.cecilia.core.pluginmanager.PostProcessStore;
import com.dassault.cecilia.core.pluginmanager.PostProcessStoreChangeListener;
import com.dassault.cecilia.core.pluginmanager.ResourceAccessor;
import com.dassault.cecilia.core.pluginmanager.SeparatorDescriptor;
import com.dassault.cecilia.core.pluginmanager.Util;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PluginManagerPanel
extends JPanel
implements PostProcessStoreChangeListener {
    private static final Logger _LOG = Logger.getLogger(PluginManagerPanel.class.getPackage().getName());
    private PluginManager _pluginManager;
    private ExtendedPlugable _plugable;
    private Map _map_Component_Descriptor = new HashMap();
    private JButton _bClose = new JButton(Messages.getString("PluginManagerPanel.0"));
    private JTree _pluginTree;
    private JButton _bAddJar = new JButton(Messages.getString("PluginManagerPanel.1"));
    private JButton _bRemoveJar = new JButton(Messages.getString("PluginManagerPanel.2"));
    private JButton _bRefreshJar = new JButton(Messages.getString("Refresh"));
    private JLabel _lblPluginName = new JLabel(Messages.getString("PluginManagerPanel.3"));
    private JLabel _lblPluginClassName = new JLabel(Messages.getString("PluginManagerPanel.4"));
    private JTextField _tfPluginName = new JTextField();
    private JTextField _tfPluginClassName = new JTextField();
    private JLabel _lblPluginDescription = new JLabel(Messages.getString("PluginManagerPanel.5"));
    private JTextArea _taPluginDescription = new JTextArea(5, 0);
    private JTabbedPane _tabbedPane;
    private JTree _treeAction;
    private JButton _bAddAction = new JButton(Messages.getString("PluginManagerPanel.1"));
    private JButton _bRemoveAction = new JButton(Messages.getString("PluginManagerPanel.2"));
    private JButton _bEditAction = new JButton(Messages.getString("PluginManagerPanel.8"));
    private JTree _treeItem;
    private JButton _bAddItem = new JButton(Messages.getString("PluginManagerPanel.9"));
    private JButton _bRemove = new JButton(Messages.getString("PluginManagerPanel.2"));
    private JButton _bUp = new JButton(Messages.getString("PluginManagerPanel.11"));
    private JButton _bDown = new JButton(Messages.getString("PluginManagerPanel.12"));
    private JButton _bAddSeparator = new JButton(Messages.getString("PluginManagerPanel.13"));
    private JButton _bAddMenu = new JButton(Messages.getString("PluginManagerPanel.14"));
    private JButton _bEditMenu = new JButton(Messages.getString("PluginManagerPanel.15"));
    private PostProcessPluginsPanel _postProcessPanel = null;
    private PluginDescriptor _currentPluginDescripor = null;
    private PluginAction _currentPluginAction = null;
    private JPanel _panelInfo;

    public PluginManagerPanel(PluginManager pluginManager, ExtendedPlugable plugable) {
        this._pluginManager = pluginManager;
        this._plugable = plugable;
        this.init();
    }

    public void setVisibleInFrame() {
        JFrame frame = new JFrame(Messages.getString("PluginManagerPanel.16"));
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public void attachComponents() throws IOException {
        try {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    AttachableComponentDescriptor att1 = (AttachableComponentDescriptor)o1;
                    AttachableComponentDescriptor att2 = (AttachableComponentDescriptor)o2;
                    return att1.getPosition() - att2.getPosition();
                }
            };
            TreeMap<String, TreeSet<AttachableComponentDescriptor>> map = new TreeMap<String, TreeSet<AttachableComponentDescriptor>>();
            Iterator attachables = this._pluginManager.getAttachableComponents().iterator();
            Set<AttachableComponentDescriptor> lst2 = null;
            while (attachables.hasNext()) {
                AttachableComponentDescriptor attachable = (AttachableComponentDescriptor)attachables.next();
                lst2 = (Set)map.get(attachable.getContainerType() + ";" + attachable.getContainerPath());
                if (lst2 == null) {
                    lst2 = new TreeSet<AttachableComponentDescriptor>(comparator);
                    map.put(attachable.getContainerType() + ";" + attachable.getContainerPath(), (TreeSet<AttachableComponentDescriptor>)lst2);
                }
                lst2.add(attachable);
            }
            for (Set<AttachableComponentDescriptor> lst2 : map.values()) {
                for (AttachableComponentDescriptor descriptor : lst2) {
                    Component component = descriptor.createComponent();
                    this.attachComponent(component, descriptor);
                    if (!(descriptor instanceof ItemDescriptor)) continue;
                    AbstractButton pluginComponent = (AbstractButton)component;
                    PluginAction action = ((ItemDescriptor)descriptor).getAction();
                    pluginComponent.setAction(new PluginItemAction(action));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String pluginPath = this._pluginManager.getPluginPath();
            String pluginFilePath = pluginPath + File.separator + PluginManager.PLUGIN_FILE;
            String msg = Messages.getString("PluginManagerPanel.19") + "\n";
            msg = msg + Util.FormatString(Messages.getString("PluginManagerPanel.21"), pluginFilePath);
            new ErrorManager().displayError(this._plugable.getWindow(), msg);
            _LOG.log(Level.FINE, msg, e);
            throw new IOException(msg);
        }
    }

    public void updateItemTree() {
        DefaultTreeModel model = (DefaultTreeModel)this._treeItem.getModel();
        model.setRoot(null);
        if (!this.loadItemTree(this._treeItem)) {
            // empty if block
        }
    }

    public void updateLanguage(Locale locale) {
        this._bClose.setText(Messages.getString("PluginManagerPanel.0"));
        this._bAddJar.setText(Messages.getString("PluginManagerPanel.1"));
        this._bRemoveJar.setText(Messages.getString("PluginManagerPanel.2"));
        this._bRefreshJar.setText(Messages.getString("Refresh"));
        this._lblPluginName.setText(Messages.getString("PluginManagerPanel.3"));
        this._lblPluginClassName.setText(Messages.getString("PluginManagerPanel.4"));
        this._lblPluginDescription.setText(Messages.getString("PluginManagerPanel.5"));
        this._bAddAction.setText(Messages.getString("PluginManagerPanel.1"));
        this._bRemoveAction.setText(Messages.getString("PluginManagerPanel.2"));
        this._bEditAction.setText(Messages.getString("PluginManagerPanel.8"));
        this._bAddItem.setText(Messages.getString("PluginManagerPanel.9"));
        this._bRemove.setText(Messages.getString("PluginManagerPanel.2"));
        this._bUp.setText(Messages.getString("PluginManagerPanel.11"));
        this._bDown.setText(Messages.getString("PluginManagerPanel.12"));
        this._bAddSeparator.setText(Messages.getString("PluginManagerPanel.13"));
        this._bAddMenu.setText(Messages.getString("PluginManagerPanel.14"));
        this._bEditMenu.setText(Messages.getString("PluginManagerPanel.15"));
        this._tabbedPane.setTitleAt(0, Messages.getString("PluginManagerPanel.42"));
        this._tabbedPane.setTitleAt(1, Messages.getString("PluginManagerPanel.43"));
        this._tabbedPane.setTitleAt(2, Messages.getString("PluginManagerPanel.44"));
        this._panelInfo.setBorder(new TitledBorder(Messages.getString("PluginManagerPanel.45")));
    }

    private Component attachComponent(Component component, AttachableComponentDescriptor descriptor) {
        try {
            if (descriptor.getContainerType().equals("JToolBar")) {
                return this.attachComponentOnToolbar(component, descriptor);
            }
            if (descriptor.getContainerType().equals("JMenu")) {
                return this.attachComponentOnMenuBar(component, descriptor);
            }
        }
        catch (Exception e) {
            _LOG.fine("Exception during plugin manager attach component: " + descriptor);
        }
        return null;
    }

    private Component attachComponentOnToolbar(Component component, AttachableComponentDescriptor descriptor) {
        JToolBar toolbar = this._plugable.getToolbar(descriptor.getContainerPath());
        if (toolbar == null) {
            return null;
        }
        toolbar.add(component, descriptor.getPosition());
        this._map_Component_Descriptor.put(component, descriptor);
        return component;
    }

    private Component attachComponentOnMenuBar(Component component, AttachableComponentDescriptor descriptor) {
        JMenuBar menubar = this._plugable.getJMenuBar();
        Component menu = this.getPluginMenu(menubar, descriptor.getContainerPath());
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).add(component, descriptor.getPosition());
            ((JMenuBar)menu).validate();
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).add(component, descriptor.getPosition());
        }
        this._map_Component_Descriptor.put(component, descriptor);
        return component;
    }

    private boolean detachComponent(AttachableComponentDescriptor descriptor) {
        if (descriptor.getContainerType().equals("JToolBar") ? !this.detachComponentFromToolbar(descriptor) : !descriptor.getContainerType().equals("JMenu") || !this.detachComponentFromMenuBar(descriptor)) {
            // empty if block
        }
        return true;
    }

    private boolean detachComponentFromToolbar(AttachableComponentDescriptor descriptor) {
        JToolBar toolbar = this._plugable.getToolbar(descriptor.getContainerPath());
        Component component = toolbar.getComponent(descriptor.getPosition());
        toolbar.remove(component);
        this._map_Component_Descriptor.remove(component);
        return true;
    }

    private boolean detachComponentFromMenuBar(AttachableComponentDescriptor descriptor) {
        Component menu = this.getPluginMenu(this._plugable.getJMenuBar(), descriptor.getContainerPath());
        Component component = null;
        if (menu instanceof JMenuBar) {
            component = ((JMenuBar)menu).getComponent(descriptor.getPosition());
            ((JMenuBar)menu).remove(descriptor.getPosition());
        } else if (menu instanceof JMenu) {
            component = ((JMenu)menu).getMenuComponent(descriptor.getPosition());
            ((JMenu)menu).remove(descriptor.getPosition());
        }
        this._map_Component_Descriptor.remove(component);
        return true;
    }

    private void moveComponent(AttachableComponentDescriptor descriptor, int lastPosition, int newPosition) {
        if (descriptor.getContainerType().equals("JToolBar")) {
            this.moveComponentOnToolbar(descriptor, lastPosition, newPosition);
        } else if (descriptor.getContainerType().equals("JMenu")) {
            this.moveComponentOnMenuBar(descriptor, lastPosition, newPosition);
        }
    }

    private void moveComponentOnToolbar(AttachableComponentDescriptor descriptor, int lastPosition, int newPosition) {
        JToolBar toolbar = this._plugable.getToolbar(descriptor.getContainerPath());
        Component component = toolbar.getComponent(descriptor.getPosition());
        toolbar.remove(component);
        toolbar.add(component, newPosition);
    }

    private void moveComponentOnMenuBar(AttachableComponentDescriptor descriptor, int lastPosition, int newPosition) {
        Component menu = this.getPluginMenu(this._plugable.getJMenuBar(), descriptor.getContainerPath());
        if (menu instanceof JMenuBar) {
            Component component = ((JMenuBar)menu).getComponent(lastPosition);
            ((JMenuBar)menu).remove(lastPosition);
            ((JMenuBar)menu).add(component, newPosition);
        } else if (menu instanceof JMenu) {
            Component component = ((JMenu)menu).getMenuComponent(lastPosition);
            ((JMenu)menu).remove(lastPosition);
            ((JMenu)menu).add(component, newPosition);
        }
    }

    private Component getPluginMenu(JMenuBar menubar, String containerPath) {
        JMenu menu = null;
        if (containerPath.length() == 0) {
            return menubar;
        }
        while (containerPath.length() > 0) {
            int i;
            int index = containerPath.indexOf(59);
            String menuName = "";
            if (index == -1) {
                menuName = containerPath;
                containerPath = containerPath.substring(containerPath.length());
            } else {
                menuName = containerPath.substring(0, index);
                containerPath = containerPath.substring(index + 1);
            }
            if (menu == null) {
                for (i = 0; i < menubar.getMenuCount() && !(menu = menubar.getMenu(i)).getName().equals(menuName); ++i) {
                }
                continue;
            }
            for (i = 0; i < menu.getItemCount(); ++i) {
                if (!(menu.getItem(i) instanceof JMenu) || !menu.getItem(i).getName().equals(menuName)) continue;
                menu = (JMenu)menu.getItem(i);
                break;
            }
            if (menu != null) continue;
            break;
        }
        return menu;
    }

    private void init() {
        this.makePanel();
        this.createListeners();
    }

    private void createListeners() {
        ActionButtonStateListener aListener = new ActionButtonStateListener();
        this._pluginTree.addTreeSelectionListener(aListener);
        this._treeAction.addTreeSelectionListener(aListener);
        ItemButtonStateListener iListener = new ItemButtonStateListener();
        this._pluginTree.addTreeSelectionListener(iListener);
        this._treeAction.addTreeSelectionListener(iListener);
        this._treeItem.addTreeSelectionListener(iListener);
        this._bAddJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerPanel.this.bAddJarAction(e);
            }
        });
        this._bRemoveJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerPanel.this.bRemoveJarAction(e);
            }
        });
        this._bRefreshJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerPanel.this.bRefreshJarAction(e);
            }
        });
        this._bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor(PluginManagerPanel.this);
                window.setVisible(false);
            }
        });
        this._pluginTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PluginManagerPanel.this._tfPluginName.setText("");
                PluginManagerPanel.this._tfPluginClassName.setText("");
                PluginManagerPanel.this._taPluginDescription.setText("");
                PluginManagerPanel.this._tabbedPane.setEnabledAt(1, false);
                if (PluginManagerPanel.this._pluginTree.getSelectionCount() != 1) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._pluginTree.getSelectionPath().getLastPathComponent();
                if (node instanceof PluginNode) {
                    PluginDescriptor pluginDescriptor = (PluginDescriptor)node.getUserObject();
                    PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(pluginDescriptor.getKey());
                    PluginManagerPanel.this._tfPluginName.setText(plugin.getInfo("plugin.name"));
                    PluginManagerPanel.this._tfPluginClassName.setText(pluginDescriptor.getKey());
                    PluginManagerPanel.this._taPluginDescription.setText(plugin.getInfo("plugin.description"));
                    PluginManagerPanel.this._taPluginDescription.setCaretPosition(0);
                    if (plugin.getInfo("type") == "PluginAction") {
                        PluginManagerPanel.this._tabbedPane.setEnabledAt(1, true);
                        PluginManagerPanel.this._currentPluginDescripor = pluginDescriptor;
                        PluginManagerPanel.this.updateActionTree();
                    }
                }
            }
        });
        this._pluginTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PluginManagerPanel.this._bRemoveJar.setEnabled(false);
                if (PluginManagerPanel.this._pluginTree.getSelectionCount() == 0) {
                    return;
                }
                PluginManagerPanel.this._bRemoveJar.setEnabled(true);
                for (int i = 0; i < PluginManagerPanel.this._pluginTree.getSelectionCount(); ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._pluginTree.getSelectionPaths()[i].getLastPathComponent();
                    if (node instanceof JarNode) continue;
                    PluginManagerPanel.this._bRemoveJar.setEnabled(false);
                    break;
                }
            }
        });
        this._treeAction.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PluginManagerPanel.this._currentPluginAction = null;
                if (PluginManagerPanel.this._treeAction.getSelectionCount() == 0) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeAction.getSelectionPath().getLastPathComponent();
                PluginAction action = (PluginAction)node.getUserObject();
                PluginManagerPanel.this._currentPluginAction = action;
            }
        });
        this._bAddAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._pluginTree.getSelectionCount() == 0) {
                    return;
                }
                PluginDescriptor pluginDescriptor = PluginManagerPanel.this._currentPluginDescripor;
                PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(pluginDescriptor.getKey());
                PluginManagerPanel.this.addAction(pluginDescriptor, plugin);
            }
        });
        this._bEditAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._treeAction.getSelectionCount() == 0) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeAction.getSelectionPath().getLastPathComponent();
                PluginAction action = PluginManagerPanel.this._currentPluginAction;
                PluginDescriptor pluginDescriptor = PluginManagerPanel.this._pluginManager.getPluginDescriptor(action.getPluginKey());
                PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(pluginDescriptor.getKey());
                PluginManagerPanel.this.editAction(pluginDescriptor, plugin, action);
                ((DefaultTreeModel)PluginManagerPanel.this._treeAction.getModel()).nodeChanged(node);
            }
        });
        this._bRemoveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._treeAction.getSelectionCount() == 0) {
                    return;
                }
                String msg = Messages.getString("PluginManagerPanel.26");
                if (!new ErrorManager().displayOptionDialog(PluginManagerPanel.this, Messages.getString("PluginManagerPanel.27"), msg)) {
                    return;
                }
                TreePath[] paths = PluginManagerPanel.this._treeAction.getSelectionPaths();
                boolean[] displayMessage = new boolean[]{true};
                for (int i = 0; i < paths.length; ++i) {
                    DefaultMutableTreeNode actionNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    PluginManagerPanel.this.removeAction(actionNode, displayMessage);
                }
            }
        });
        this._bAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._pluginTree.getSelectionCount() == 0) {
                    return;
                }
                if (PluginManagerPanel.this._treeAction.getSelectionCount() == 0) {
                    return;
                }
                if (PluginManagerPanel.this._treeItem.getSelectionCount() == 0) {
                    return;
                }
                ItemDescriptor descriptor = new ItemDescriptor(PluginManagerPanel.this._currentPluginAction);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                PluginManagerPanel.this.addAttachableComponent(descriptor, node);
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                TreePath[] paths = PluginManagerPanel.this._treeItem.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    if (!(node instanceof AttachableComponentNode)) continue;
                    nodes.add(node);
                }
                if (nodes.size() == 0) {
                    return;
                }
                String msg = Messages.getString("PluginManagerPanel.28");
                if (!new ErrorManager().displayOptionDialog(PluginManagerPanel.this, Messages.getString("PluginManagerPanel.29"), msg)) {
                    return;
                }
                PluginManagerPanel.this.removeAttachableComponents(nodes);
            }
        });
        this._bUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._treeItem.getSelectionCount() == 0) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                if (!(node instanceof AttachableComponentNode)) {
                    return;
                }
                DefaultMutableTreeNode containerNode = (DefaultMutableTreeNode)node.getParent();
                int position = containerNode.getIndex(node);
                if (position == 0) {
                    return;
                }
                PluginManagerPanel.this.moveAttachableComponent(node, position, position - 1);
            }
        });
        this._bDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPanel.this._treeItem.getSelectionCount() == 0) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                if (!(node instanceof AttachableComponentNode)) {
                    return;
                }
                DefaultMutableTreeNode containerNode = (DefaultMutableTreeNode)node.getParent();
                int position = containerNode.getIndex(node);
                if (position == containerNode.getChildCount() - 1) {
                    return;
                }
                PluginManagerPanel.this.moveAttachableComponent(node, position, position + 1);
            }
        });
        this._bAddSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                SeparatorDescriptor descriptor = new SeparatorDescriptor();
                PluginManagerPanel.this.addAttachableComponent(descriptor, node);
            }
        });
        this._bAddMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                Window w = SwingUtilities.getWindowAncestor(PluginManagerPanel.this);
                EditMenuDlg dialog = null;
                if (w instanceof Frame) {
                    dialog = new EditMenuDlg((Frame)w, Messages.getString("PluginManagerPanel.30"), true);
                } else if (w instanceof Dialog) {
                    dialog = new EditMenuDlg((Dialog)w, Messages.getString("PluginManagerPanel.30"), true);
                }
                dialog.setData(PluginManagerPanel.this._pluginManager, null, null, PluginManagerPanel.this);
                dialog.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(PluginManagerPanel.this));
                dialog.setDefaultCloseOperation(2);
                dialog.setVisible(true);
                dialog.dispose();
                if (!dialog.isOk()) {
                    return;
                }
                MenuDescriptor descriptor = new MenuDescriptor();
                descriptor.setName(dialog.getLabel());
                descriptor.setIconPath(dialog.getIconPath());
                PluginManagerPanel.this.addMenu(descriptor, node);
                PluginManagerPanel.this._plugable.pluginChange();
            }
        });
        this._bEditMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
                Menu menu = (Menu)node.getUserObject();
                MenuDescriptor descriptor = (MenuDescriptor)menu.getDescriptor();
                Window w = SwingUtilities.getWindowAncestor(PluginManagerPanel.this);
                EditMenuDlg dialog = null;
                if (w instanceof Frame) {
                    dialog = new EditMenuDlg((Frame)w, Messages.getString("PluginManagerPanel.15"), true);
                } else if (w instanceof Dialog) {
                    dialog = new EditMenuDlg((Dialog)w, Messages.getString("PluginManagerPanel.15"), true);
                }
                dialog.setData(PluginManagerPanel.this._pluginManager, descriptor.getName(), descriptor.getIconPath(), PluginManagerPanel.this);
                dialog.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(PluginManagerPanel.this));
                dialog.setDefaultCloseOperation(2);
                dialog.setVisible(true);
                dialog.dispose();
                if (!dialog.isOk()) {
                    return;
                }
                descriptor.setName(dialog.getLabel());
                descriptor.setIconPath(dialog.getIconPath());
                ((DefaultTreeModel)PluginManagerPanel.this._treeItem.getModel()).nodeChanged(node);
                PluginManagerPanel.this._treeItem.setSelectionPath(new TreePath(node.getPath()));
                PluginManagerPanel.this._plugable.pluginChange();
                PluginManagerPanel.this._pluginManager.write();
            }
        });
    }

    private void addAction(PluginDescriptor pluginDescriptor, PluginModel plugin) {
        Window w = SwingUtilities.getWindowAncestor(this);
        EditPluginActionDlg dialog = null;
        if (w instanceof Frame) {
            dialog = new EditPluginActionDlg((Frame)w, Messages.getString("PluginManagerPanel.34"), true);
        } else if (w instanceof Dialog) {
            dialog = new EditPluginActionDlg((Dialog)w, Messages.getString("PluginManagerPanel.34"), true);
        }
        PluginAction action = new PluginAction(pluginDescriptor.getKey(), plugin, this._pluginManager);
        Set alreadyUsedNames = this.getPuginActionNames();
        dialog.setData(this._pluginManager, action, alreadyUsedNames);
        dialog.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        dialog.dispose();
        if (!dialog.isOk()) {
            return;
        }
        action.setName(dialog.getLabel());
        action.setIconPath(dialog.getIconPath());
        action.setShortcut(dialog.getShortcut());
        action.setTooltip(dialog.getTooltip());
        if (plugin.withParameters()) {
            action.setParameters(dialog.getParameters());
        }
        DefaultTreeModel model = (DefaultTreeModel)this._treeAction.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(action);
        model.insertNodeInto(node, root, model.getChildCount(root));
        TreePath path = new TreePath(root.getPath());
        if (!this._treeAction.isExpanded(path)) {
            this._treeAction.expandPath(path);
        }
        path = new TreePath(node.getPath());
        this._treeAction.setSelectionPath(path);
        this._treeAction.scrollPathToVisible(path);
        this._pluginManager.addPluginAction(action);
        this._pluginManager.write();
    }

    private Set getPuginActionNames() {
        TreeSet<String> names = new TreeSet<String>();
        DefaultTreeModel model = (DefaultTreeModel)this._treeAction.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            names.add(((PluginAction)node.getUserObject()).getName());
        }
        return names;
    }

    private void removeAction(DefaultMutableTreeNode actionNode, boolean[] displayMessage) {
        PluginAction action = (PluginAction)actionNode.getUserObject();
        this.removeAction(action, displayMessage);
        DefaultTreeModel model = (DefaultTreeModel)this._treeAction.getModel();
        model.removeNodeFromParent(actionNode);
    }

    private void removeAction(PluginAction action, boolean[] displayMessage) {
        List items = this.getPluginItemNodes(action);
        if (items.size() > 0) {
            if (displayMessage[0]) {
                String msg = Messages.getString("PluginManagerPanel.36");
                msg = Util.FormatString(msg, action.getName());
                String whatToDo = new ErrorManager().displayOptionDialog2(this, Messages.getString("PluginManagerPanel.27"), msg);
                boolean bl = displayMessage[0] = !whatToDo.equals(ErrorManager.CONTINUE_FOR_ALL);
                if (whatToDo.equals(ErrorManager.CANCEL)) {
                    return;
                }
            }
            this.removePluginItems(items);
        }
        this._pluginManager.removePluginAction(action);
        this._pluginManager.write();
    }

    private void editAction(PluginDescriptor pluginDescriptor, PluginModel plugin, PluginAction action) {
        Window w = SwingUtilities.getWindowAncestor(this);
        EditPluginActionDlg dialog = null;
        if (w instanceof Frame) {
            dialog = new EditPluginActionDlg((Frame)w, Messages.getString("PluginManagerPanel.38"), true);
        } else if (w instanceof Dialog) {
            dialog = new EditPluginActionDlg((Dialog)w, Messages.getString("PluginManagerPanel.38"), true);
        }
        Set alreadyUsedNames = this.getPuginActionNames();
        alreadyUsedNames.remove(action.getName());
        dialog.setData(this._pluginManager, action, alreadyUsedNames);
        dialog.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        dialog.dispose();
        if (!dialog.isOk()) {
            return;
        }
        action.setName(dialog.getLabel());
        action.setIconPath(dialog.getIconPath());
        action.setShortcut(dialog.getShortcut());
        action.setTooltip(dialog.getTooltip());
        if (plugin.withParameters()) {
            action.setParameters(dialog.getParameters());
        }
        this.refreshPluginActionsOnItems();
        this._pluginManager.write();
    }

    private void addAttachableComponent(AttachableComponentDescriptor descriptor, DefaultMutableTreeNode node) {
        String containerPath = null;
        String containerType = null;
        int position = 0;
        DefaultMutableTreeNode parentNode = null;
        if (node.getUserObject() instanceof JMenu || node.getUserObject() instanceof JToolBar) {
            parentNode = node;
            position = parentNode.getChildCount();
        } else {
            parentNode = (DefaultMutableTreeNode)node.getParent();
            position = parentNode.getIndex(node);
        }
        if (parentNode.getUserObject() instanceof JMenu) {
            containerType = "JMenu";
        } else if (parentNode.getUserObject() instanceof JToolBar) {
            containerType = "JToolBar";
        }
        containerPath = this.getContainerPath(parentNode);
        descriptor.setContainerType(containerType);
        descriptor.setContainerPath(containerPath);
        descriptor.setPosition(position);
        Component attachableComponent = descriptor.createComponent();
        if (parentNode.getUserObject() instanceof JMenu) {
            JMenu menu = (JMenu)parentNode.getUserObject();
            menu.add(attachableComponent, position);
        } else if (parentNode.getUserObject() instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)parentNode.getUserObject();
            toolbar.add(attachableComponent, position);
        }
        Component component = descriptor.createComponent();
        this.attachComponent(component, descriptor);
        if (descriptor instanceof ItemDescriptor) {
            PluginAction action = ((ItemDescriptor)descriptor).getAction();
            ((AbstractButton)component).setAction(new PluginItemAction(action));
            ((AbstractButton)attachableComponent).setAction(new PluginItemAction(action));
        }
        Component copy = this.copyComponent(attachableComponent);
        AttachableComponentNode newNode = new AttachableComponentNode(copy, descriptor);
        ((DefaultTreeModel)this._treeItem.getModel()).insertNodeInto(newNode, parentNode, position);
        ((DefaultTreeModel)this._treeItem.getModel()).nodeChanged(parentNode);
        TreePath path = new TreePath(newNode.getPath());
        this._treeItem.setSelectionPath(path);
        this._treeItem.scrollPathToVisible(path);
        this._pluginManager.addAttachableComponent(descriptor);
        this._pluginManager.write();
        this._plugable.pluginChange();
    }

    private void addMenu(MenuDescriptor descriptor, DefaultMutableTreeNode node) {
        JComponent parent;
        String containerPath = null;
        String containerType = null;
        int position = 0;
        DefaultMutableTreeNode parentNode = null;
        if (node.getUserObject() instanceof JMenu || node.getUserObject() instanceof JMenuBar || node.getUserObject() instanceof JToolBar) {
            parentNode = node;
            position = parentNode.getChildCount();
        } else {
            parentNode = (DefaultMutableTreeNode)node.getParent();
            position = parentNode.getIndex(node);
        }
        containerType = "JMenu";
        containerPath = this.getContainerPath(parentNode);
        Component menu = descriptor.createComponent();
        if (parentNode.getUserObject() instanceof JMenuBar) {
            parent = (JMenuBar)parentNode.getUserObject();
            parent.add(menu, position);
        } else if (parentNode.getUserObject() instanceof JMenu) {
            parent = (JMenu)parentNode.getUserObject();
            ((JMenu)parent).add(menu, position);
        }
        descriptor.setContainerType(containerType);
        descriptor.setContainerPath(containerPath);
        descriptor.setPosition(position);
        this.attachComponent(descriptor.createComponent(), descriptor);
        Component copy = this.copyComponent(menu);
        AttachableComponentNode newNode = new AttachableComponentNode(copy, descriptor);
        ((DefaultTreeModel)this._treeItem.getModel()).insertNodeInto(newNode, parentNode, position);
        ((DefaultTreeModel)this._treeItem.getModel()).nodeChanged(parentNode);
        TreePath path = new TreePath(newNode.getPath());
        this._treeItem.setSelectionPath(path);
        this._treeItem.scrollPathToVisible(path);
        this._pluginManager.addAttachableComponent(descriptor);
        this._pluginManager.write();
        this._plugable.pluginChange();
    }

    public boolean isMenuNameAlreadyExit(String name) {
        return this.isMenuNameAlreadyExist(name, this._plugable.getJMenuBar());
    }

    private boolean isMenuNameAlreadyExist(String name, JMenuBar menubar) {
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            if (name.equals(menubar.getMenu(i).getName())) {
                return true;
            }
            if (!this.isMenuNameAlreadyExist(name, menubar.getMenu(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isMenuNameAlreadyExist(String name, JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component comp = menu.getMenuComponent(i);
            if (!(comp instanceof JMenu)) continue;
            if (name.equals(((JMenu)comp).getName())) {
                return true;
            }
            if (!this.isMenuNameAlreadyExist(name, (JMenu)comp)) continue;
            return true;
        }
        return false;
    }

    private void removePluginItems(List nodes) {
        for (AttachableComponentNode node : nodes) {
            this.removeAttachableComponent(node);
        }
        this._plugable.pluginChange();
    }

    private void removeAttachableComponents(List nodes) {
        for (AttachableComponentNode node : nodes) {
            ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!(node.getChildAt(i) instanceof AttachableComponentNode)) continue;
                childNodes.add(node.getChildAt(i));
            }
            this.removeAttachableComponents(childNodes);
            this.removeAttachableComponent(node);
        }
        this._plugable.pluginChange();
    }

    private void removeAttachableComponent(AttachableComponentNode node) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        AttachableComponentDescriptor descriptor = node.getDescriptor();
        int position = descriptor.getPosition();
        if (parentNode.getUserObject() instanceof JMenu) {
            JMenu menu = (JMenu)parentNode.getUserObject();
            menu.remove(position);
        } else if (parentNode.getUserObject() instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)parentNode.getUserObject();
            toolbar.remove(position);
        } else if (parentNode.getUserObject() instanceof JMenuBar) {
            JMenuBar menubar = (JMenuBar)parentNode.getUserObject();
            menubar.remove(position);
        }
        ((DefaultTreeModel)this._treeItem.getModel()).removeNodeFromParent(node);
        ((DefaultTreeModel)this._treeItem.getModel()).nodeChanged(parentNode);
        this.detachComponent(descriptor);
        this._pluginManager.removeAttachableComponent(descriptor);
        this._pluginManager.write();
    }

    private void refreshPluginActionsOnItems() {
        for (AttachableComponent component : this._map_Component_Descriptor.keySet()) {
            if (!(component.getDescriptor() instanceof ItemDescriptor)) continue;
            AbstractButton item = (AbstractButton)((Object)component);
            Action action = item.getAction();
            item.setAction(null);
            item.setAction(action);
        }
    }

    private void moveAttachableComponent(DefaultMutableTreeNode node, int lastPosition, int newPosition) {
        Component comp;
        JComponent menu;
        DefaultMutableTreeNode containerNode = (DefaultMutableTreeNode)node.getParent();
        AttachableComponentDescriptor descriptor = ((AttachableComponentNode)node).getDescriptor();
        if (containerNode.getUserObject() instanceof JMenuBar) {
            menu = (JMenuBar)containerNode.getUserObject();
            comp = ((JMenuBar)menu).getMenu(lastPosition);
            menu.remove(lastPosition);
            menu.add(comp, newPosition);
        }
        if (containerNode.getUserObject() instanceof JMenu) {
            menu = (JMenu)containerNode.getUserObject();
            comp = ((JMenu)menu).getMenuComponent(lastPosition);
            ((JMenu)menu).remove(lastPosition);
            ((JMenu)menu).add(comp, newPosition);
        } else if (containerNode.getUserObject() instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)containerNode.getUserObject();
            comp = toolbar.getComponent(lastPosition);
            toolbar.remove(lastPosition);
            toolbar.add(comp, newPosition);
        }
        ((DefaultTreeModel)this._treeItem.getModel()).removeNodeFromParent(node);
        ((DefaultTreeModel)this._treeItem.getModel()).insertNodeInto(node, containerNode, newPosition);
        TreePath path = new TreePath(node.getPath());
        this._treeItem.setSelectionPath(path);
        this._treeItem.scrollPathToVisible(path);
        this.moveComponent(descriptor, lastPosition, newPosition);
        this._pluginManager.moveAttachableComponent(descriptor, newPosition);
        this._pluginManager.write();
        this._plugable.pluginChange();
    }

    private String getContainerPath(DefaultMutableTreeNode containerNode) {
        String containerPath = "";
        if (containerNode.getUserObject() instanceof JMenu) {
            do {
                JMenu menu = (JMenu)containerNode.getUserObject();
                containerPath = menu.getName() + ";" + containerPath;
            } while (!((containerNode = (DefaultMutableTreeNode)containerNode.getParent()).getUserObject() instanceof JMenuBar));
            containerPath = containerPath.substring(0, containerPath.length() - 1);
        } else if (containerNode.getUserObject() instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)containerNode.getUserObject();
            containerPath = toolbar.getName();
        }
        return containerPath;
    }

    private JPanel makePanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.makeTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.makeBottomButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerPanel.this._bClose.doClick();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        return this;
    }

    private JPanel makeTopPanel() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addTab(Messages.getString("PluginManagerPanel.42"), null, this.makePluginPanel());
        this._tabbedPane.addTab(Messages.getString("PluginManagerPanel.43"), null, this.makeActionPanel());
        this._tabbedPane.addTab(Messages.getString("PluginManagerPanel.44"), null, this.makeItemPanel());
        this._tabbedPane.addTab(Messages.getString("PostProcessPluginsPanel.0"), null, this.makePostProcessPanel());
        this._tabbedPane.setEnabledAt(1, false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.setPreferredSize(new Dimension(600, 450));
        return panel;
    }

    private JPanel makeBottomButtonPanel() {
        JPanel bottomButtonPanel = new JPanel(new GridBagLayout());
        bottomButtonPanel.add((Component)this._bClose, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._bClose.setEnabled(true);
        return bottomButtonPanel;
    }

    private JPanel makePluginPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.makePluginTreePanel(), new GridBagConstraints(0, 0, 1, 1, 50.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._panelInfo = this.makePluginInfoPanel();
        panel.add((Component)this._panelInfo, new GridBagConstraints(1, 0, 1, 1, 50.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel makePluginTreePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._pluginTree = this.makePluginTree();
        JScrollPane scpane = new JScrollPane(this._pluginTree);
        panel.add((Component)scpane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._bAddJar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this._bRemoveJar, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._bRemoveJar.setEnabled(false);
        panel.setPreferredSize(new Dimension(300, 0));
        return panel;
    }

    private JPanel makePluginInfoPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._lblPluginName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._tfPluginName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._lblPluginClassName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this._tfPluginClassName, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this._lblPluginDescription, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        JScrollPane scpane = new JScrollPane(this._taPluginDescription);
        panel.add((Component)scpane, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(new TitledBorder(Messages.getString("PluginManagerPanel.45")));
        scpane.setMinimumSize(new Dimension(0, 100));
        panel.setPreferredSize(new Dimension(300, 0));
        this._taPluginDescription.setEditable(false);
        this._taPluginDescription.setBackground(this.getBackground());
        this._taPluginDescription.setLineWrap(true);
        this._taPluginDescription.setWrapStyleWord(true);
        this._tfPluginName.setText("");
        this._tfPluginClassName.setText("");
        this._taPluginDescription.setText("");
        this._tfPluginName.setEditable(false);
        this._tfPluginClassName.setEditable(false);
        return panel;
    }

    private JPanel makeActionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel bPanel = new JPanel(new GridBagLayout());
        this._treeAction = this.makeActionTree();
        panel.add((Component)new JScrollPane(this._treeAction), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        bPanel.add((Component)this._bAddAction, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bRemoveAction, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bEditAction, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._bRemoveAction.setEnabled(false);
        this._bEditAction.setEnabled(false);
        return panel;
    }

    private JTree makeActionTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        JTree result = new JTree(root);
        result.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                if (value == model.getRoot()) {
                    return label;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                PluginAction action = (PluginAction)node.getUserObject();
                label.setText(action.getName());
                Icon icon = null;
                icon = action.getIconPath() == null || action.getIconPath().length() == 0 ? PluginManagerPanel.this.getPluginIcon(action.getPluginKey(), "plugin.default") : new ImageIcon(action.getIconPath());
                label.setIcon(icon);
                return label;
            }
        });
        result.setRootVisible(false);
        return result;
    }

    private void updateActionTree() {
        if (this._currentPluginDescripor == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._treeAction.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        for (PluginAction action : this._pluginManager.getPluginActions(this._currentPluginDescripor.getKey())) {
            root.add(new DefaultMutableTreeNode(action));
        }
        model.reload();
        if (root.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(0);
            this._treeAction.setSelectionPath(new TreePath(child.getPath()));
        }
    }

    @Override
    public void changePostProcessStore(PostProcessStore store) {
        this._pluginManager.write();
    }

    private JComponent makePostProcessPanel() {
        this._postProcessPanel = new PostProcessPluginsPanel(this._pluginManager);
        this._postProcessPanel.addPostProcessStoreChangeListener(this);
        return this._postProcessPanel;
    }

    private JPanel makeItemPanel() {
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this._bAddItem, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bAddSeparator, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bAddMenu, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bEditMenu, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bRemove, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bUp, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        bPanel.add((Component)this._bDown, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._bAddItem.setEnabled(false);
        this._bAddSeparator.setEnabled(false);
        this._bAddMenu.setEnabled(false);
        this._bEditMenu.setEnabled(false);
        this._bRemove.setEnabled(false);
        this._bUp.setEnabled(false);
        this._bDown.setEnabled(false);
        this._treeItem = this.makeItemTree();
        JPanel itemPanel = new JPanel(new GridBagLayout());
        itemPanel.add((Component)new JScrollPane(this._treeItem), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        itemPanel.add((Component)bPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        return itemPanel;
    }

    private JTree makePluginTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (String jarPath : this._pluginManager.getJars()) {
            boolean found = false;
            for (int i = 0; i < root.getChildCount() && !found; ++i) {
                JarNode jarNode = (JarNode)root.getChildAt(i);
                if (!jarNode.getJarPath().equals(jarPath)) continue;
                found = true;
            }
            if (found) continue;
            JarNode jarNode = new JarNode(jarPath);
            root.add(jarNode);
        }
        Iterator plugins = this._pluginManager.getPlugins().iterator();
        while (plugins.hasNext()) {
            String pluginKey = plugins.next().toString();
            PluginDescriptor pluginDescriptor = this._pluginManager.getPluginDescriptor(pluginKey);
            PluginModel plugin = this._pluginManager.getPlugin(pluginKey);
            boolean found = false;
            JarNode jarNode = null;
            String jarPath = pluginDescriptor.getPath();
            if (jarPath == null) {
                jarPath = "_" + File.separatorChar + "_";
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                jarNode = (JarNode)root.getChildAt(i);
                if (!jarNode.getJarPath().equals(jarPath)) continue;
                found = true;
                break;
            }
            if (!found) {
                jarNode = new JarNode(jarPath);
                root.add(jarNode);
            }
            found = false;
            PluginTypeNode pluginTypeNode = null;
            for (int i = 0; i < jarNode.getChildCount(); ++i) {
                pluginTypeNode = (PluginTypeNode)jarNode.getChildAt(i);
                if (!pluginTypeNode.getPluginType().getKey().equals(plugin.getInfo("type"))) continue;
                found = true;
                break;
            }
            if (!found) {
                PluginType pluginType = this._pluginManager.getPluginType(plugin.getInfo("type"));
                pluginTypeNode = new PluginTypeNode(pluginType);
                jarNode.add(pluginTypeNode);
            }
            PluginNode pluginNode = new PluginNode(pluginDescriptor);
            pluginTypeNode.add(pluginNode);
        }
        JTree treePlugin = new JTree(root);
        treePlugin.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                DefaultMutableTreeNode node;
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
                if (value instanceof JarNode) {
                    node = (JarNode)value;
                    label.setText(((JarNode)node).getName() + " - " + ((JarNode)node).getJarLocation());
                }
                if (value instanceof PluginTypeNode) {
                    node = (PluginTypeNode)value;
                    label.setText(((PluginTypeNode)node).getText());
                    if (((PluginTypeNode)node).getIcon() != null) {
                        label.setIcon(((PluginTypeNode)node).getIcon());
                        label.setDisabledIcon(((PluginTypeNode)node).getIcon());
                    }
                } else if (value instanceof PluginNode) {
                    node = (PluginNode)value;
                    label.setText(((PluginNode)node).getText());
                    if (((PluginNode)node).getIcon() != null) {
                        label.setIcon(((PluginNode)node).getIcon());
                        label.setDisabledIcon(((PluginNode)node).getIcon());
                    } else if (((PluginTypeNode)node.getParent()).getIcon() != null) {
                        label.setIcon(((PluginTypeNode)node.getParent()).getIcon());
                        label.setDisabledIcon(((PluginTypeNode)node.getParent()).getIcon());
                    }
                }
                return label;
            }
        });
        treePlugin.setRootVisible(false);
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            TreePath path = new TreePath(node.getPath());
            treePlugin.expandPath(path);
        }
        treePlugin.setRowHeight(ResIcoAbstract.getIconSize());
        return treePlugin;
    }

    private JTree makeItemTree() {
        JTree tree = new JTree();
        return tree;
    }

    private boolean loadItemTree(JTree tree) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode toolbarTypeNode = new DefaultMutableTreeNode("Toolbars");
        DefaultMutableTreeNode menubarTypeNode = new DefaultMutableTreeNode("Menubar");
        menubarTypeNode.add(this.createMenuBarNode(this._plugable.getJMenuBar()));
        root.add(menubarTypeNode);
        List toolbars = this._plugable.getToolbars();
        if (toolbars != null) {
            for (int i = 0; i < toolbars.size(); ++i) {
                String toolbarName = (String)toolbars.get(i);
                MutableTreeNode node = this.createToolBarNode(toolbarName);
                if (node == null) continue;
                toolbarTypeNode.add(node);
            }
            root.add(toolbarTypeNode);
        }
        ((DefaultTreeModel)tree.getModel()).setRoot(root);
        tree.setRootVisible(false);
        tree.setRowHeight(24);
        tree.setCellRenderer(new ItemCellRenderer());
        tree.expandPath(new TreePath(((DefaultMutableTreeNode)menubarTypeNode.getChildAt(0)).getPath()));
        tree.expandPath(new TreePath(toolbarTypeNode.getPath()));
        return true;
    }

    private MutableTreeNode createToolBarNode(String toolbarName) {
        JToolBar toolbar = this._plugable.getToolbar(toolbarName);
        if (toolbar == null || toolbar.getComponentCount() == 0) {
            return null;
        }
        JToolBar copyToolbar = this.copyToolBar(toolbar);
        copyToolbar.setName(toolbarName);
        DefaultMutableTreeNode toolbarNode = new DefaultMutableTreeNode(copyToolbar);
        for (int i = 0; i < toolbar.getComponentCount(); ++i) {
            Component component = toolbar.getComponent(i);
            MutableTreeNode componentNode = this.createComponentNode(component);
            if (componentNode == null) continue;
            toolbarNode.add(componentNode);
        }
        return toolbarNode;
    }

    private JToolBar copyToolBar(JToolBar toolbar) {
        JToolBar toolbarCopy = new JToolBar();
        toolbarCopy.setMargin(new Insets(0, 0, 0, 0));
        toolbarCopy.setBorder(new EmptyBorder(0, 0, 0, 0));
        for (int i = 0; i < toolbar.getComponentCount(); ++i) {
            Component component = toolbar.getComponent(i);
            Component componentCopy = this.copyComponent(component);
            if (componentCopy == null) continue;
            toolbarCopy.add(componentCopy);
        }
        return toolbarCopy;
    }

    private DefaultMutableTreeNode createMenuBarNode(JMenuBar menubar) {
        JMenuBar copyMenubar = this.copyMenuBar(this._plugable.getJMenuBar());
        DefaultMutableTreeNode menubarNode = new DefaultMutableTreeNode(copyMenubar);
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            JMenu menu = menubar.getMenu(i);
            menubarNode.add(this.createMenuNode(menu));
        }
        return menubarNode;
    }

    private MutableTreeNode createMenuNode(JMenu menu) {
        DefaultMutableTreeNode menuNode;
        if (menu instanceof AttachableComponent) {
            AttachableComponentDescriptor descriptor = (AttachableComponentDescriptor)this._map_Component_Descriptor.get(menu);
            menuNode = new AttachableComponentNode(this.copyMenu(menu), descriptor);
        } else {
            menuNode = new DefaultMutableTreeNode(this.copyMenu(menu));
        }
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component component = menu.getMenuComponent(i);
            if (component instanceof JMenu) {
                menuNode.add(this.createMenuNode((JMenu)component));
                continue;
            }
            menuNode.add(this.createComponentNode(component));
        }
        return menuNode;
    }

    private MutableTreeNode createComponentNode(Component component) {
        Component copy = this.copyComponent(component);
        if (copy == null) {
            return null;
        }
        if (component instanceof AttachableComponent) {
            AttachableComponentDescriptor descriptor = (AttachableComponentDescriptor)this._map_Component_Descriptor.get(component);
            return new AttachableComponentNode(copy, descriptor);
        }
        return new DefaultMutableTreeNode(copy);
    }

    private JMenuBar copyMenuBar(JMenuBar menubar) {
        JMenuBar copy = new JMenuBar();
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            JMenu menu = menubar.getMenu(i);
            copy.add(this.copyMenu(menu));
        }
        return copy;
    }

    private JMenu copyMenu(JMenu menu) {
        JMenu menuCopy = (JMenu)this.copyComponent(menu);
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component comp = menu.getMenuComponent(i);
            if (comp instanceof JMenu) {
                JMenu submenu = this.copyMenu((JMenu)comp);
                menuCopy.add(submenu);
                continue;
            }
            Component compCopy = this.copyComponent(comp);
            if (compCopy == null) continue;
            menuCopy.add(compCopy);
        }
        return menuCopy;
    }

    private Component copyComponent(Component component) {
        if (component instanceof AttachableComponent) {
            AttachableComponent attachable = (AttachableComponent)((Object)component);
            AttachableComponentDescriptor descriptor = attachable.getDescriptor();
            Component copy = descriptor.createComponent();
            if (descriptor instanceof ItemDescriptor) {
                ((AbstractButton)copy).setAction(((AbstractButton)component).getAction());
            }
            return copy;
        }
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            JMenu copy = new JMenu(menu.getText());
            copy.setName(menu.getName());
            if (menu.getIcon() != null) {
                menu.setIcon(menu.getIcon());
            }
            return copy;
        }
        if (component instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)component;
            JMenuItem componentCopy = new JMenuItem(item.getText(), item.getIcon());
            componentCopy.setName(item.getName());
            componentCopy.setIconTextGap(item.getIconTextGap());
            if (item.getAction() instanceof PluginItemAction) {
                componentCopy.setAction(item.getAction());
            }
            return componentCopy;
        }
        if (component instanceof JButton) {
            JButton b = (JButton)component;
            JButton componentCopy = null;
            componentCopy = new JButton(b.getText(), b.getIcon());
            componentCopy.setToolTipText(b.getToolTipText());
            componentCopy.setIconTextGap(b.getIconTextGap());
            componentCopy.setPreferredSize(new Dimension(22, 22));
            return componentCopy;
        }
        if (component instanceof JToggleButton) {
            JToggleButton b = (JToggleButton)component;
            JToggleButton componentCopy = null;
            componentCopy = new JToggleButton(b.getText(), b.getIcon());
            componentCopy.setToolTipText(b.getToolTipText());
            componentCopy.setIconTextGap(b.getIconTextGap());
            componentCopy.setPreferredSize(new Dimension(22, 22));
            return componentCopy;
        }
        if (component instanceof JToolBar.Separator) {
            return new JToolBar.Separator(((JToolBar.Separator)component).getSeparatorSize());
        }
        if (component instanceof JSeparator) {
            return new JSeparator();
        }
        return null;
    }

    private Icon getPluginIcon(String pluginKey, String iconName) {
        try {
            return this._pluginManager.getPlugin(pluginKey).getIcon(iconName);
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "Error in method getPluginIcon with arguments " + pluginKey + ", " + iconName, e);
            return null;
        }
    }

    private void bAddJarAction(ActionEvent e) {
        File fileJar = new File(".");
        JFileChooser chooser = new JFileChooser(fileJar);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.isHidden()) {
                    return false;
                }
                String path = file.getAbsolutePath();
                String ext = path.substring(path.lastIndexOf(".") + 1);
                if (!ext.equalsIgnoreCase("jar") && !ext.equalsIgnoreCase("zip")) {
                    return false;
                }
                return PluginManagerPanel.this.isJarFileValid(file);
            }

            @Override
            public String getDescription() {
                return Messages.getString("PluginManagerPanel.60") + " (*.jar, *.zip)";
            }
        });
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 1) {
            return;
        }
        boolean[] displayMessage = new boolean[]{true};
        String pluginPath = this._pluginManager.getPluginPath();
        for (int i = 0; i < chooser.getSelectedFiles().length; ++i) {
            String jarPath = FileUtility.getDiffPath((String)pluginPath, (String)chooser.getSelectedFiles()[i].getPath());
            this.addJar(jarPath, displayMessage);
        }
        this._plugable.pluginChange();
    }

    public boolean isJarFileValid(File jarFile) {
        try {
            ZipFile file = new ZipFile(jarFile);
            file.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void addJar(String jarPath, boolean[] displayMessage) {
        JarNode jarNode;
        String pluginPath = this._pluginManager.getPluginPath();
        File jarFile = new File(pluginPath, jarPath);
        DefaultTreeModel model = (DefaultTreeModel)this._pluginTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        int i = root.getChildCount();
        if (this._pluginManager.isJarExist(jarFile)) {
            if (displayMessage[0]) {
                String msg = Util.FormatString(Messages.getString("PluginManagerPanel.63"), jarFile.getPath());
                String whatToDo = new ErrorManager().displayOptionDialog2(this, Messages.getString("PluginManagerPanel.64"), msg);
                boolean bl = displayMessage[0] = !whatToDo.equals(ErrorManager.CONTINUE_FOR_ALL);
                if (whatToDo.equals(ErrorManager.CANCEL)) {
                    return;
                }
            }
            for (i = 0; i < root.getChildCount(); ++i) {
                jarNode = (JarNode)root.getChildAt(i);
                if (!jarNode.getJarPath().equals(jarPath)) continue;
                this.removeJar(jarNode);
                break;
            }
        }
        jarNode = new JarNode(jarPath);
        model.insertNodeInto(jarNode, root, i);
        Iterator plugins = this._pluginManager.addPlugins(jarFile).iterator();
        while (plugins.hasNext()) {
            String pluginKey = plugins.next().toString();
            PluginDescriptor pluginDescriptor = this._pluginManager.getPluginDescriptor(pluginKey);
            PluginModel plugin = this._pluginManager.getPlugin(pluginKey);
            boolean found = false;
            PluginTypeNode pluginTypeNode = null;
            for (i = 0; i < jarNode.getChildCount(); ++i) {
                pluginTypeNode = (PluginTypeNode)jarNode.getChildAt(i);
                if (!pluginTypeNode.getPluginType().getKey().equals(plugin.getInfo("type"))) continue;
                found = true;
            }
            if (!found) {
                PluginType pluginType = this._pluginManager.getPluginType(plugin.getInfo("type"));
                pluginTypeNode = new PluginTypeNode(pluginType);
                model.insertNodeInto(pluginTypeNode, jarNode, jarNode.getChildCount());
            }
            PluginNode pluginNode = new PluginNode(pluginDescriptor);
            model.insertNodeInto(pluginNode, pluginTypeNode, pluginTypeNode.getChildCount());
            if (!(plugin instanceof PluginMAction)) continue;
            this.addDefaultPluginAction(pluginDescriptor, plugin);
        }
        this._pluginManager.write();
        if (!this._pluginTree.isExpanded(new TreePath(root.getPath()))) {
            this._pluginTree.expandPath(new TreePath(root.getPath()));
        }
        this._pluginTree.expandPath(new TreePath(jarNode.getPath()));
    }

    private void addDefaultPluginAction(PluginDescriptor pluginDescriptor, PluginModel plugin) {
        PluginAction action = new PluginAction(pluginDescriptor.getKey(), plugin, this._pluginManager);
        this._pluginManager.addPluginAction(action);
    }

    private void bRemoveJarAction(ActionEvent e) {
        String msg = Messages.getString("PluginManagerPanel.65");
        if (!new ErrorManager().displayOptionDialog(this, Messages.getString("PluginManagerPanel.66"), msg)) {
            return;
        }
        TreePath[] paths = this._pluginTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreePath selectionPath = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (!(node instanceof JarNode)) continue;
            this.removeJar((JarNode)node);
        }
        this._pluginManager.write();
        this._plugable.pluginChange();
    }

    private void removeJar(JarNode jarNode) {
        for (PluginNode pluginNode : this.getPluginNodes(jarNode)) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)pluginNode.getUserObject();
            List pluginActions = this._pluginManager.getPluginActions(pluginDescriptor.getKey());
            if (pluginActions.size() > 0) {
                for (int j = pluginActions.size() - 1; j >= 0; --j) {
                    PluginAction action = (PluginAction)pluginActions.get(j);
                    boolean[] displayMsg = new boolean[]{false};
                    this.removeAction(action, displayMsg);
                }
            }
            this._pluginManager.removePlugin(pluginDescriptor.getKey());
        }
        this._pluginManager.removeJar(jarNode.getJarPath());
        DefaultTreeModel model = (DefaultTreeModel)this._pluginTree.getModel();
        model.removeNodeFromParent(jarNode);
    }

    private void bRefreshJarAction(ActionEvent e) {
    }

    private List getPluginNodes(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node.isLeaf()) {
            if (node instanceof PluginNode) {
                nodes.add(node);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.addAll(this.getPluginNodes((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        }
        return nodes;
    }

    private List getPluginItemNodes(PluginAction action) {
        DefaultTreeModel model = (DefaultTreeModel)this._treeItem.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        return this.getPluginItemNodes(action, root);
    }

    private List getPluginItemNodes(PluginAction action, DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node.isLeaf()) {
            ItemDescriptor itemDesc;
            AttachableComponentNode pluginItemNode;
            if (node instanceof AttachableComponentNode && (pluginItemNode = (AttachableComponentNode)node).getDescriptor() instanceof ItemDescriptor && (itemDesc = (ItemDescriptor)pluginItemNode.getDescriptor()).getAction().equals(action)) {
                nodes.add(node);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.addAll(this.getPluginItemNodes(action, (DefaultMutableTreeNode)node.getChildAt(i)));
            }
        }
        return nodes;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame(Messages.getString("PluginManagerPanel.16"));
        frame.setDefaultCloseOperation(2);
        frame.setAlwaysOnTop(true);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static class ActionThread
    extends CThread {
        Plugable _plugable;
        PluginMAction _action;
        Object _parameters;

        ActionThread(Component c, Plugable plugable, PluginMAction action, Object parameters) {
            super(c);
            this._plugable = plugable;
            this._action = action;
            this._parameters = parameters;
        }

        @Override
        protected void firstDo() {
            this._action.createSession(this._plugable, this._parameters);
        }

        @Override
        protected String getIDCode() {
            return this._action.getClass().getName();
        }
    }

    private class ItemCellRenderer
    extends DefaultTreeCellRenderer {
        Font f = null;

        private ItemCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean select, boolean expanded, boolean leaf, int row, boolean focus) {
            if (this.f == null && this.getFont() != null) {
                this.f = new Font(this.getFont().getName(), 1, this.getFont().getSize());
            }
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(tree.getBackground());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof JMenuBar) {
                return (Component)node.getUserObject();
            }
            if (node.getUserObject() instanceof JMenuItem) {
                JMenuItem component = (JMenuItem)node.getUserObject();
                JMenuItem menuItem = new JMenuItem(component.getText(), component.getIcon());
                menuItem.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                menuItem.setForeground(select ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
                menuItem.setOpaque(true);
                if (node instanceof AttachableComponentNode && this.f != null) {
                    menuItem.setFont(this.f);
                }
                return menuItem;
            }
            if (node.getUserObject() instanceof JToolBar) {
                panel.add((Component)((JToolBar)node.getUserObject()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                panel.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                return panel;
            }
            if (node.getUserObject() instanceof JButton) {
                JButton b = (JButton)node.getUserObject();
                panel.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                JLabel lbl = null;
                String txt = b.getToolTipText();
                if (txt != null && txt.length() > 0) {
                    lbl = new JLabel(txt);
                    panel.add((Component)lbl, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                    lbl.setForeground(select ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
                }
                panel.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                if (lbl != null && this.f != null && node instanceof AttachableComponentNode) {
                    lbl.setFont(this.f);
                }
                return panel;
            }
            if (node.getUserObject() instanceof JToggleButton) {
                JToggleButton b = (JToggleButton)node.getUserObject();
                panel.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                JLabel lbl = null;
                String txt = b.getToolTipText();
                if (txt != null && txt.length() > 0) {
                    lbl = new JLabel(txt);
                    panel.add((Component)lbl, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                    lbl.setForeground(select ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
                }
                panel.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                if (lbl != null && this.f != null && node instanceof AttachableComponentNode) {
                    lbl.setFont(this.f);
                }
                return panel;
            }
            if (node.getUserObject() instanceof SeparatorDescriptor.MenuSeparator || node.getUserObject() instanceof SeparatorDescriptor.ToolBarSeparator) {
                JLabel label = new JLabel(Messages.getString("PluginManagerPanel.69"));
                panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                panel.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                label.setForeground(select ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
                if (this.f != null) {
                    label.setFont(this.f);
                }
                return panel;
            }
            if (node.getUserObject() instanceof JSeparator) {
                JLabel label = new JLabel(Messages.getString("PluginManagerPanel.70"));
                panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 3, 1, 2), 0, 0));
                panel.setBackground(select ? this.getBackgroundSelectionColor() : tree.getBackground());
                label.setForeground(select ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
                return panel;
            }
            return super.getTreeCellRendererComponent(tree, value, select, expanded, leaf, row, focus);
        }
    }

    class ItemButtonStateListener
    implements TreeSelectionListener {
        ItemButtonStateListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            PluginManagerPanel.this._bAddItem.setEnabled(false);
            PluginManagerPanel.this._bAddSeparator.setEnabled(false);
            PluginManagerPanel.this._bAddMenu.setEnabled(false);
            PluginManagerPanel.this._bEditMenu.setEnabled(false);
            PluginManagerPanel.this._bUp.setEnabled(false);
            PluginManagerPanel.this._bDown.setEnabled(false);
            if (PluginManagerPanel.this._treeItem.getSelectionCount() == 0) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)PluginManagerPanel.this._treeItem.getSelectionPath().getLastPathComponent();
            PluginManagerPanel.this._bAddItem.setEnabled((node.getUserObject() instanceof JMenu || node.getUserObject() instanceof JToolBar || node.getUserObject() instanceof AbstractButton) && PluginManagerPanel.this._currentPluginAction != null);
            PluginManagerPanel.this._bAddSeparator.setEnabled(node.getUserObject() instanceof JMenu || node.getUserObject() instanceof JToolBar || node.getUserObject() instanceof AbstractButton);
            PluginManagerPanel.this._bAddMenu.setEnabled(node.getUserObject() instanceof JMenuBar || node.getUserObject() instanceof JMenu || node.getUserObject() instanceof AbstractButton);
            PluginManagerPanel.this._bEditMenu.setEnabled(node.getUserObject() instanceof Menu);
            PluginManagerPanel.this._bUp.setEnabled(node instanceof AttachableComponentNode);
            PluginManagerPanel.this._bDown.setEnabled(node instanceof AttachableComponentNode);
            PluginManagerPanel.this._bRemove.setEnabled(false);
            TreePath[] paths = PluginManagerPanel.this._treeItem.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                if (!(node instanceof AttachableComponentNode)) continue;
                PluginManagerPanel.this._bRemove.setEnabled(true);
                break;
            }
        }
    }

    class ActionButtonStateListener
    implements TreeSelectionListener {
        ActionButtonStateListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            PluginManagerPanel.this._bRemoveAction.setEnabled(PluginManagerPanel.this._treeAction.getSelectionCount() > 0);
            PluginManagerPanel.this._bEditAction.setEnabled(PluginManagerPanel.this._treeAction.getSelectionCount() > 0);
        }
    }

    class PluginItemAction
    extends AbstractAction {
        private PluginAction _action;

        public PluginItemAction(PluginAction action) {
            this.setAction(action);
        }

        public void setAction(PluginAction action) {
            this._action = action;
        }

        @Override
        public Object getValue(String key) {
            if (this._action == null) {
                return null;
            }
            if (key.equals("Name")) {
                return this._action.getName();
            }
            if (key.equals("AcceleratorKey")) {
                return KeyStroke.getKeyStroke(this._action.getShortcut());
            }
            if (key.equals("ShortDescription")) {
                return this._action.getTooltip();
            }
            if (key.equals("SmallIcon")) {
                return this.getIcon();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(this._action.getPluginKey());
                Object parameters = this._action.getParameters();
                if (plugin instanceof PluginMAction) {
                    ActionThread thread = new ActionThread(PluginManagerPanel.this._plugable.getWindow(), PluginManagerPanel.this._plugable, (PluginMAction)plugin, parameters);
                    thread.realiseDo();
                } else if (plugin instanceof PluginMStepper) {
                    ((PluginMStepper)plugin).createStepper(PluginManagerPanel.this._plugable, parameters);
                } else if (plugin instanceof PluginMTranslate) {
                    ((PluginMTranslate)plugin).createTranslator(PluginManagerPanel.this._plugable, parameters);
                }
            }
            catch (Exception ex) {
                _LOG.log(Level.INFO, "Unexpected error occurred during plugin execution: " + this._action.getPluginKey(), e);
            }
        }

        public PluginAction getAction() {
            return this._action;
        }

        Icon getIcon() {
            Icon icon = new ImageIcon(this._action.getIconPath());
            if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
                return icon;
            }
            icon = PluginManagerPanel.this.getPluginIcon(this._action.getPluginKey(), "plugin.default");
            if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
                return icon;
            }
            if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
                return icon;
            }
            URL url = ResourceAccessor.getInstance().getResource("vide_pi");
            icon = url == null ? null : new ImageIcon(url);
            return icon;
        }
    }

    class AttachableComponentNode
    extends DefaultMutableTreeNode {
        private AttachableComponentDescriptor _descriptor;

        AttachableComponentNode(Object userObj, AttachableComponentDescriptor descriptor) {
            super(userObj);
            this._descriptor = descriptor;
        }

        public AttachableComponentDescriptor getDescriptor() {
            return this._descriptor;
        }
    }

    class PluginNode
    extends DefaultMutableTreeNode {
        private PluginDescriptor _pluginDescriptor;

        public PluginNode(PluginDescriptor pluginDescriptor) {
            super(pluginDescriptor);
            this._pluginDescriptor = pluginDescriptor;
        }

        public String getText() {
            PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(this._pluginDescriptor.getKey());
            return plugin == null ? "" : plugin.getInfo("plugin.name");
        }

        public Icon getIcon() {
            PluginModel plugin = PluginManagerPanel.this._pluginManager.getPlugin(this._pluginDescriptor.getKey());
            return plugin == null ? null : PluginManagerPanel.this.getPluginIcon(this._pluginDescriptor.getKey(), "plugin.default");
        }
    }

    class PluginTypeNode
    extends DefaultMutableTreeNode {
        private String text;
        private Icon icon;

        public PluginTypeNode(PluginType pluginType) {
            super(pluginType);
            this.text = "!unknown!";
            this.text = pluginType.getName();
            URL url = ResourceAccessor.getInstance().getResource(pluginType.getIconName());
            if (url != null) {
                this.icon = new ImageIcon(url);
            }
        }

        public String getText() {
            return this.text;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public PluginType getPluginType() {
            return (PluginType)this.getUserObject();
        }
    }

    class JarNode
    extends DefaultMutableTreeNode {
        private String _path;
        private String _jarPath;
        private String _name;

        public JarNode(String path) {
            super(path);
            this._path = path;
            int index = path.lastIndexOf(File.separatorChar);
            this._name = path.substring(index + 1);
            this._jarPath = path.substring(0, index);
        }

        public String getJarPath() {
            return this._path;
        }

        public String getName() {
            return this._name;
        }

        public String getJarLocation() {
            return this._jarPath;
        }
    }
}

