/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing;

import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class CaptureAction
extends AbstractAction {
    static JFileChooser _dlgCapture = null;
    protected Component _src;

    public CaptureAction(Component src) {
        this._src = src;
    }

    protected JFileChooser getFileChooser() {
        if (_dlgCapture == null) {
            String path = System.getProperty("cecilia.export.CapturePath", ".");
            _dlgCapture = new JFileChooser(path);
            _dlgCapture.setFileFilter(new FileFilterExtention("Imag (*.png)", ".png").verifyWrite(true));
        }
        return _dlgCapture;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser dlg = this.getFileChooser();
        try {
            Robot robot = new Robot();
            Dimension sz = this._src.getSize();
            Point pt = this._src.getLocationOnScreen();
            BufferedImage image = robot.createScreenCapture(new Rectangle(pt.x, pt.y, sz.width, sz.height));
            final TransferableImage transferableImage = new TransferableImage(image);
            new Thread("System Clipboard"){

                @Override
                public void run() {
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableImage, null);
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                        return;
                    }
                }
            }.start();
            if (dlg.showSaveDialog(this._src) == 1) {
                return;
            }
            if (dlg.getSelectedFile() == null) {
                return;
            }
            ImageIO.write((RenderedImage)image, "png", dlg.getSelectedFile());
        }
        catch (AWTException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static class TransferableImage
    implements Transferable {
        private Image image;

        public TransferableImage(Image uneImage) {
            this.image = uneImage;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }
    }
}

