/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.PrintPreviewCanvas;
import com.dassault.cecilia.dbobj.general.ihm.IPanelWithZoom;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrintPreviewDlg
extends JDialogCecilia
implements IPanelWithZoom {
    protected Pageable _book;
    protected int _currentPage;
    private double _currentZoom = 1.0;
    private IPanelWithZoom.ZoomDecorator _zoomDecorator;
    protected JButton _ctrlBrowseFirst;
    protected JButton _ctrlBrowseLast;
    protected JButton _ctrlBrowseNext;
    protected JButton _ctrlBrowsePrev;
    protected JLabel _ctrlLabel;
    protected PrintPreviewCanvas _ctrlPreview;
    protected JScrollPane _scrollView;
    protected JButton _ctrlPrint;

    public PrintPreviewDlg(Window owner, Pageable book) {
        super(owner, ResMsgVoc.getString("VOC_PREVIEW"), true);
        this._book = book;
        this._currentPage = 0;
        this._zoomDecorator = new IPanelWithZoom.ZoomDecorator(this);
        this.make();
        this.pack();
        Dimension dlgSize = this.getSize();
        Dimension winSize = owner.getSize();
        this.setSize(Math.min(dlgSize.width, winSize.width), Math.min(dlgSize.height, winSize.height));
    }

    private Component createBrowseButtons() {
        this._ctrlBrowseFirst = new JButton(ResMsgVoc.getString("VOC_FIRST"));
        this._ctrlBrowseFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewDlg.this._currentPage = 0;
                PrintPreviewDlg.this._ctrlPreview.changeCurrentPage(PrintPreviewDlg.this._currentPage);
                PrintPreviewDlg.this.updateBrowse();
            }
        });
        this._ctrlBrowsePrev = new JButton(ResMsgVoc.getString("VOC_PREVIOUS"));
        this._ctrlBrowsePrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                --PrintPreviewDlg.this._currentPage;
                PrintPreviewDlg.this._ctrlPreview.changeCurrentPage(PrintPreviewDlg.this._currentPage);
                PrintPreviewDlg.this.updateBrowse();
            }
        });
        this._ctrlBrowseNext = new JButton(ResMsgVoc.getString("VOC_NEXT"));
        this._ctrlBrowseNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++PrintPreviewDlg.this._currentPage;
                PrintPreviewDlg.this._ctrlPreview.changeCurrentPage(PrintPreviewDlg.this._currentPage);
                PrintPreviewDlg.this.updateBrowse();
            }
        });
        this._ctrlBrowseLast = new JButton(ResMsgVoc.getString("VOC_LAST"));
        this._ctrlBrowseLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewDlg.this._currentPage = PrintPreviewDlg.this._book.getNumberOfPages() - 1;
                PrintPreviewDlg.this._ctrlPreview.changeCurrentPage(PrintPreviewDlg.this._currentPage);
                PrintPreviewDlg.this.updateBrowse();
            }
        });
        JPanel result = new JPanel(new GridLayout(1, 4, 0, 0));
        result.add(this._ctrlBrowseFirst);
        result.add(this._ctrlBrowsePrev);
        result.add(this._ctrlBrowseNext);
        result.add(this._ctrlBrowseLast);
        return result;
    }

    protected void updateBrowse() {
        int nop = this._book.getNumberOfPages();
        this._ctrlBrowseFirst.setEnabled(nop > 1 && this._currentPage > 0);
        this._ctrlBrowsePrev.setEnabled(nop > 1 && this._currentPage > 0);
        this._ctrlBrowseNext.setEnabled(nop > 1 && this._currentPage < nop - 1);
        this._ctrlBrowseLast.setEnabled(nop > 1 && this._currentPage != nop - 1);
        this._ctrlLabel.setText("Page  " + (this._currentPage + 1) + "/" + nop);
    }

    private Component createNorth() {
        this._ctrlLabel = new JLabel("Page  xx/yy");
        this._ctrlLabel.setHorizontalAlignment(4);
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.add(this.createBrowseButtons(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(7, 10, 7, 10), 0, 0));
        resultPanel.add((Component)this._ctrlLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(7, 10, 7, 10), 0, 0));
        return resultPanel;
    }

    protected Component createCenter() {
        if (this._ctrlPreview == null) {
            this._ctrlPreview = new PrintPreviewCanvas(this._book);
        }
        this._scrollView = this._zoomDecorator.createScrollPane();
        this._scrollView.getHorizontalScrollBar().setUnitIncrement(10);
        this._scrollView.getHorizontalScrollBar().setBlockIncrement(100);
        this._scrollView.getVerticalScrollBar().setUnitIncrement(10);
        this._scrollView.getVerticalScrollBar().setBlockIncrement(100);
        return this._scrollView;
    }

    protected Component createSouth() {
        this._ctrlPrint = new JButton(ResMsgVoc.getString("VOC_PRINT"));
        this._ctrlPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewDlg.this.doPrintAction();
            }
        });
        JPanel resultPanel = new JPanel(new GridBagLayout());
        JPanel fPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        fPanel.add(this._ctrlPrint);
        fPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AbstractAction actClose = new AbstractAction(this.getLabelClose()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreviewDlg.this.doCloseAction();
            }
        };
        this._ctrlClose = new JButton(actClose);
        fPanel.add(this._ctrlClose);
        this.putAction("CECILIA_ENTER", actClose);
        this.putAction("CECILIA_CANCEL", actClose);
        resultPanel.add((Component)fPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(7, 10, 7, 10), 0, 0));
        return resultPanel;
    }

    private void make() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add(this.createNorth(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add(this.createCenter(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add(this.createSouth(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.updateBrowse();
        this.init();
    }

    protected void doPrintAction() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(this._book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    protected final void doCloseAction() {
        this.setVisible(false);
    }

    @Override
    public JComponent getContentView() {
        return this._ctrlPreview;
    }

    @Override
    public CeciliaGUI getGUI() {
        return null;
    }

    @Override
    public JComboBox getGUIZoom() {
        return null;
    }

    @Override
    public JScrollPane getScrollView() {
        return this._scrollView;
    }

    @Override
    public Rectangle getSelectionRect() {
        return null;
    }

    @Override
    public double getZoom() {
        return this._currentZoom;
    }

    @Override
    public void setZoom(double value) {
        this._currentZoom = value;
        this._ctrlPreview.setZoom(this._currentZoom);
        this._ctrlPreview.revalidate();
        this.validate();
        this.repaint();
    }
}

