/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBItem;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBFactory {
    public static final String PROP_COMPONENT_WITH_EQ_ = "cecilia.mbsa.component.AcceptFamilyStartWithEq_";
    public static final short LIMIT_NAME = 248;
    public static final short LIMIT_LOGIN = 255;
    public static final short LIMIT_PASSWD = 64;
    public static final short LIMIT_DESCRIPTION = 1023;
    public static final short LIMIT_MODULE = 10;
    public static final short LIMIT_PROPERTY_VALUE = 255;
    public static final short LIMIT_RELATION = 10;
    public static final String _REGEX_INTEGER = "[+\\-]?[0-9]+";
    private static final Pattern _PATTERN_INTEGER = Pattern.compile("[+\\-]?[0-9]+");
    public static final String _REGEX_DOUBLE = "[\\-+]?(([0-9]+([eE][\\-+]?[0-9]+)?)|([0-9]*\\.[0-9]*([eE][\\-+]?[0-9]+)?))";
    private static final Pattern _PATTERN_DOUBLE = Pattern.compile("[\\-+]?(([0-9]+([eE][\\-+]?[0-9]+)?)|([0-9]*\\.[0-9]*([eE][\\-+]?[0-9]+)?))");
    public static final String _REGEX_ID_ALTARICA = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final Pattern _PATTERN_NAME_ALTARICA = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static Set<String> _SET_RESERVED_WORD_ALTARICA = new HashSet<String>(Arrays.asList("const", "domain", "bool", "integer", "symbol", "node", "edon", "flow", "state", "local", "event", "priority", "sub", "trans", "assert", "sync", "extern", "or", "and", "imply", "true", "false", "not", "card", "ite", "if", "then", "else", "initial_state", "func", "cnuf", "in", "out", "typdef", "fedpyt", "unnamed", "equipment", "graphic", "init", "law", "link", "knil", "min", "max", "case", "float", "int", "inverse", "private", "term", "attribute", "parameter", "remark"));
    private static final Pattern _PATTERN_VERSION_OCAS = Pattern.compile("[0-9]+");
    private static Pattern _PATTERN_VERSION_ARBOR = Pattern.compile("([0-9]+)\\.([0-9]+)");
    protected static final Pattern _PATTERN_VERSION = Pattern.compile("([0-9]+)(\\.([0-9]+))?");

    private static boolean verifyChar(char car) {
        switch (car) {
            case '\t': 
            case '\n': 
            case '#': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ';': 
            case '@': 
            case '[': 
            case ']': 
            case '`': 
            case '|': 
            case '\u00b5': {
                return false;
            }
        }
        return car <= '\u0080';
    }

    public static int verifyName(String value) {
        if (value == null) {
            return -1;
        }
        if (value.isEmpty()) {
            return -1;
        }
        if (value.length() > 248) {
            return -1;
        }
        char[] ptr = value.toCharArray();
        if (Character.isWhitespace(ptr[0]) || Character.isWhitespace(ptr[ptr.length - 1])) {
            return -1;
        }
        for (int i = 0; i < ptr.length; ++i) {
            if (DBFactory.verifyChar(ptr[i])) continue;
            return ptr[i];
        }
        return 0;
    }

    public static boolean verifyName(String value, DBFolder.Family family) {
        if (DBFactory.verifyName(value) != 0) {
            return false;
        }
        switch (family) {
            case TYPE: 
            case OPERATOR: 
            case COMPONENT: 
            case EQUIPMENT: 
            case ATTRIBUTE: 
            case PARAMETER: {
                return DBFactory.verifyNameAltarica(value);
            }
        }
        return true;
    }

    public static boolean verifyName(String name, DBFolder dbFolder) {
        if (DBFactory.verifyName(name) != 0) {
            return false;
        }
        switch (dbFolder.getFamily()) {
            case COMPONENT: {
                if (!Boolean.getBoolean(PROP_COMPONENT_WITH_EQ_) && dbFolder.getDepthUntilSystem() == 1 && name.startsWith("eq_")) {
                    return false;
                }
            }
            case TYPE: 
            case OPERATOR: 
            case EQUIPMENT: 
            case ATTRIBUTE: 
            case PARAMETER: {
                if (!DBFactory.verifyNameAltarica(name)) {
                    return false;
                }
                if (!dbFolder.isModel() || !DBFactory.isReservedAltarica(name)) break;
                return false;
            }
        }
        return true;
    }

    public static String convertName(String value) {
        return DBFactory.convertName(value, DBFolder.Family.APPLICATION);
    }

    public static String convertName(String value, DBFolder.Family family) {
        boolean bAltarica = false;
        switch (family) {
            case TYPE: 
            case OPERATOR: 
            case COMPONENT: 
            case EQUIPMENT: 
            case ATTRIBUTE: 
            case PARAMETER: {
                bAltarica = true;
            }
        }
        if (!bAltarica) {
            value = value.trim();
        }
        if (value.isEmpty()) {
            return null;
        }
        int length = value.length();
        if (length > 248) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(length + 20);
        for (int i = 0; i < length; ++i) {
            Character car = Character.valueOf(value.charAt(i));
            boolean valid = false;
            if (bAltarica) {
                if (car.charValue() >= 'a' && car.charValue() <= 'z') {
                    valid = true;
                } else if (car.charValue() >= 'A' && car.charValue() <= 'Z') {
                    valid = true;
                } else if (car.charValue() == '_') {
                    valid = true;
                } else if (i > 0 && car.charValue() >= '0' && car.charValue() <= '9') {
                    valid = true;
                }
            } else {
                valid = DBFactory.verifyChar(car.charValue());
            }
            if (!valid) {
                if (bAltarica && i == 0) {
                    buffer.append("u");
                } else {
                    buffer.append("_u");
                }
                buffer.append(Integer.toHexString(car.charValue()).toUpperCase());
                buffer.append("_");
                continue;
            }
            buffer.append(car);
        }
        if (buffer.length() > 248) {
            return null;
        }
        return buffer.toString();
    }

    public static boolean verifyInteger(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return _PATTERN_INTEGER.matcher(value).matches();
    }

    public static long parseID(String value) {
        if (value.isEmpty()) {
            return -1L;
        }
        if (!_PATTERN_INTEGER.matcher(value).matches()) {
            return -1L;
        }
        long result = Long.parseLong(value);
        if (result <= 0L) {
            return -1L;
        }
        return result;
    }

    public static boolean verifyDouble(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return _PATTERN_DOUBLE.matcher(value).matches();
    }

    public static boolean verifyNameAltarica(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return _PATTERN_NAME_ALTARICA.matcher(value).matches();
    }

    public static boolean isReservedAltarica(String word) {
        return _SET_RESERVED_WORD_ALTARICA.contains(word);
    }

    public static boolean verifyVersion(String name, DBFolder.Family family, short code) {
        switch (family) {
            case PROJECT: {
                switch (code) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return DBFactory.verifyVersionTree(name);
                    }
                }
                break;
            }
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return DBFactory.verifyName(name, family);
            }
        }
        return DBFactory.verifyVersion(name);
    }

    public static boolean verifyVersion(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 248) {
            return false;
        }
        return _PATTERN_VERSION_OCAS.matcher(value).matches();
    }

    public static final boolean verifyVersionTree(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.length() > 248) {
            return false;
        }
        return _PATTERN_VERSION_ARBOR.matcher(value).matches();
    }

    public static int readMajorVersionTree(String value) {
        Matcher match = _PATTERN_VERSION_ARBOR.matcher(value);
        if (!match.matches()) {
            return -1;
        }
        return Integer.parseInt(match.group(1));
    }

    public static int readMinorVersionTree(String value) {
        Matcher match = _PATTERN_VERSION_ARBOR.matcher(value);
        if (!match.matches()) {
            return -1;
        }
        return Integer.parseInt(match.group(2));
    }

    public static boolean verifyLogin(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return value.length() <= 255;
    }

    public static boolean verifyPassword(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return value.length() <= 64;
    }

    public static boolean verifyDescription(String value) {
        return value.length() <= 1023;
    }

    public static DBFolder[] createModel(DBFolder dbFolder, DBUser dbUser, String name, String version, DBFolder.Family family, short familyFlag, short userFlag) {
        DBFolder dbModel = new DBFolder(dbFolder, dbUser);
        dbModel.setName(name);
        dbModel.setFlags(DBFolder.createFlagsModel(family, familyFlag, userFlag));
        DBFolder dbVersion = DBFactory.createVersion(dbModel, dbUser, version, family, familyFlag, userFlag);
        dbModel.setChildren(Collections.singletonList(dbVersion));
        return new DBFolder[]{dbModel, dbVersion};
    }

    public static DBFolder createVersion(DBFolder dbModel, DBUser dbUser, String name, DBFolder.Family family, short familyFlag, short userFlag) {
        DBFolder dbVersion = new DBFolder(dbModel, dbUser);
        dbVersion.setName(name);
        DBObject obj = new DBObject();
        DBObjProperty prop = new DBObjProperty().setName("object.release");
        prop.setType("Long");
        prop.setValue(Integer.toString(1));
        obj.addProperty(prop);
        dbVersion.setObject(obj);
        dbVersion.setFlags(DBFolder.createFlagsVersion(family, familyFlag, userFlag));
        return dbVersion;
    }

    public static String incrementNameVersion(DBFolder dbVersion) {
        if (dbVersion == null) {
            throw new NullPointerException();
        }
        if (!dbVersion.isVersion()) {
            return null;
        }
        String name = dbVersion.getName();
        Matcher matcher = _PATTERN_VERSION.matcher(name);
        if (matcher.matches()) {
            String decimal = matcher.group(2);
            if (decimal != null) {
                StringBuilder result = new StringBuilder();
                result.append(Long.parseLong(matcher.group(1)) + 1L);
                result.append(decimal);
                return result.toString();
            }
            long id = Long.parseLong(name) + 1L;
            return Long.toString(id);
        }
        DBItem._LOG.warning("La version n'est pas reconnue comme une version : " + name);
        return null;
    }

    public static DBFolder findLastVersion(DBFolder dbModel) {
        if (dbModel == null) {
            throw new NullPointerException();
        }
        if (!dbModel.isModel()) {
            return null;
        }
        List<DBFolder> dbChildren = dbModel.getChildren();
        if (dbChildren.isEmpty()) {
            return null;
        }
        if (dbChildren.size() == 1) {
            return dbChildren.get(0);
        }
        double max = 0.0;
        DBFolder dbSelect = null;
        for (int i = dbChildren.size() - 1; i >= 0; --i) {
            DBFolder dbVersion = dbChildren.get(i);
            String name = dbVersion.getName();
            Matcher matcher = _PATTERN_VERSION.matcher(name);
            if (matcher.matches()) {
                double cur;
                double d = cur = matcher.group(2) != null ? Double.parseDouble(name) : (double)Long.parseLong(name);
                if (!(cur > max)) continue;
                max = cur;
                dbSelect = dbVersion;
                continue;
            }
            DBItem._LOG.warning("La version n'est pas reconnue comme une version : " + name);
        }
        return dbSelect;
    }
}

