/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.mysql;

import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultSession;
import com.dassault.cecilia.db.dao.sql.mysql.MySQLFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySQLSession
extends DefaultSession {
    public MySQLSession(Connection connect, MySQLFactory factory) {
        super(connect, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(DBSession ses) {
        if (ses.isActive()) {
            int nbrLockObj = Integer.MAX_VALUE;
            try {
                PreparedStatement prepare = this._connect.prepareStatement("SELECT COUNT(*) FROM " + SQLTable.OBJECTS + " WHERE obj_ses_id = ?");
                this._factory.initStatement(prepare);
                try {
                    prepare.setLong(1, ses.getID());
                    ResultSet resultSet = prepare.executeQuery();
                    try {
                        if (resultSet.first()) {
                            nbrLockObj = resultSet.getInt(1);
                        }
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    try {
                        prepare.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SQLException e) {
                this.logSQLException(e, "MySQLSession::delete(" + ses.getID() + ")");
            }
            if (nbrLockObj > 0) {
                MySQLFactory._LOG.severe("Impossible de supprimer la session '" + ses.getID() + "' [user=" + ses.getUser().getLogin() + "] - Des objets sont toujours verouilles [nbr=" + nbrLockObj + "]");
                return false;
            }
        }
        return super.delete(ses);
    }
}

