/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.xml;

import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DAOImportXmlFolder
extends DAOFolder {
    protected DAOImportXmlFactory _factory = null;
    protected Map<String, DBFolder> _roots = null;
    long _lastTimeUpdate = 0L;
    Map<Long, DBFolder> _cacheFolder;

    public DAOImportXmlFolder(DAOImportXmlFactory factory) {
        this._factory = factory;
    }

    private synchronized void loadRoots() {
        if (this._roots != null) {
            return;
        }
        this._roots = new HashMap<String, DBFolder>();
        DBFolder dbRoot = new DBFolder(-98L);
        dbRoot.setChildren(new ArrayList<DBFolder>());
        dbRoot.setName("ROOT");
        dbRoot.setFlags(DBFolder.createFlags(0x800000, DBFolder.Family.APPLICATION, (short)0, (short)0));
        this._roots.put(dbRoot.getName(), dbRoot);
        DBFolder dbFRB = new DBFolder(-99L);
        dbFRB.setChildren(new ArrayList<DBFolder>());
        dbFRB.setName("BTP");
        dbFRB.setFlags(DBFolder.createFlags(0x800000, DBFolder.Family.APPLICATION, (short)0, (short)0));
        dbRoot.getChildren().add(dbFRB.setParent(dbRoot));
        this._roots.put(dbFRB.getName(), dbFRB);
        DBFolder dbPrefs = new DBFolder(-97L);
        dbPrefs.setChildren(new ArrayList<DBFolder>());
        dbPrefs.setName("PREFS");
        dbPrefs.setFlags(DBFolder.createFlags(0x800000, DBFolder.Family.APPLICATION, (short)0, (short)0));
        for (DBFolder.Family family : DBFolder.Family.values()) {
            if (family == DBFolder.Family.APPLICATION) continue;
            DBFolder dbFolder = new DBFolder(-100 - family.toInt());
            dbFolder.setChildren(new ArrayList<DBFolder>());
            dbFolder.setName(family.getRootName());
            dbFolder.setFlags(DBFolder.createFlags(0x800000, family, (short)0, (short)0));
            switch (family) {
                case PROJECT: 
                case EQUIPMENT: 
                case COMPONENT: 
                case OPERATOR: 
                case TYPE: 
                case IMAG: {
                    dbRoot.getChildren().add(dbFolder.setParent(dbRoot));
                    break;
                }
                case PARAMETER: 
                case ATTRIBUTE: 
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_MODEL: 
                case BTP_SUBSTANTIATION: 
                case CCF_MODEL: 
                case FMEA_MODEL: {
                    dbFRB.getChildren().add(dbFolder.setParent(dbFRB));
                    break;
                }
                default: {
                    DAOImportXmlFactory._LOG.info("Don't attach root folder:" + (Object)((Object)family));
                }
            }
            this._roots.put(dbFolder.getName(), dbFolder);
        }
    }

    @Override
    public DBFolder getRootID(String rootKey) {
        if (this._roots == null) {
            this.loadRoots();
        }
        return this._roots.get(rootKey);
    }

    @Override
    public DBFolder create(DBFolder fol) {
        this.putCache(fol.getID(), fol);
        return fol;
    }

    @Override
    public boolean delete(DBFolder folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean update(DBFolder obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBFolder find(long id) {
        return this.findCache(id);
    }

    @Override
    public boolean exist(long id) {
        return this.findCache(id) != null;
    }

    @Override
    public boolean refresh(DBFolder dbFolder) {
        return false;
    }

    @Override
    public List<DBFolder> findChildren(DBFolder parent) {
        return parent.getChildren();
    }

    @Override
    public List<DBAccess> findAccesses(DBFolder obj) {
        return obj.getAccesses();
    }

    protected DBFolder findCache(long id) {
        return this._cacheFolder.get(id);
    }

    public void putCache(long id, DBFolder folder) {
        this._cacheFolder.put(id, folder);
    }

    @Override
    public void prepareCache() {
        this._cacheFolder = new HashMap<Long, DBFolder>();
    }

    @Override
    public void updateCache(DAOFolder.UpdateListener listener) {
    }

    @Override
    public void freezeCache(boolean bFreeze) {
    }
}

