/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityTableModel;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ListCriticityTable
extends JTable {
    private static Logger _LOG = Logger.getLogger(ListCriticityTable.class.getPackage().getName());
    private final CAppl _cAppl;
    private DoubleFormat _formatter = new DoubleFormatJava();

    public ListCriticityTable(CAppl appl, ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
        super(model);
        this._cAppl = appl;
        PluginWithOptions opts = this._cAppl.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            this._formatter = ((GeneralTextPreferencies)opts).getDoubleFormat();
        }
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "supprCol");
        this.getActionMap().put("supprCol", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ListCriticityTable.this.getSelectedRows();
                if (selectedRows.length == 0) {
                    return;
                }
                ListCriticityTable.this.doDeleteCriticity();
            }
        });
    }

    public void doDeleteCriticity() {
        int[] rowsSelected = this.getSelectedRows();
        for (int i = 0; i < rowsSelected.length; ++i) {
            rowsSelected[i] = this.convertRowIndexToModel(rowsSelected[i]);
        }
        ListCriticityTableModel model = (ListCriticityTableModel)this.getModel();
        LinkedHashSet<ListCriticityUtility.CriticityIdentifier> setToDelete = new LinkedHashSet<ListCriticityUtility.CriticityIdentifier>();
        for (int i : rowsSelected) {
            setToDelete.add(model.getItem(i));
        }
        Object object = setToDelete.iterator();
        while (object.hasNext()) {
            ListCriticityUtility.CriticityIdentifier critToDelete = (ListCriticityUtility.CriticityIdentifier)object.next();
            model.getListCrits().remove(critToDelete);
        }
        ((ItemAbstractTableModel)this.getModel()).refresh(true, false);
    }

    @Override
    public TableCellRenderer getCellRenderer(final int row, final int column) {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int r, int c) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, selected, hasFocus, row, column);
                ItemAbstractTableModel model = (ItemAbstractTableModel)ListCriticityTable.this.getModel();
                if (value == null) {
                    return label;
                }
                ListCriticityUtility.CriticityIdentifier critID = (ListCriticityUtility.CriticityIdentifier)model.getItem(ListCriticityTable.this.convertRowIndexToModel(r));
                PrefFieldBoolean prefField = model.getColumnModel().getColumnField(ListCriticityTable.this.convertColumnIndexToModel(c));
                if (prefField.getIdxCode() == 5) {
                    String treeMsg = ListCriticityUtility.isConsistencyTreeMsg(ListCriticityTable.this._cAppl, critID);
                    label.setToolTipText(treeMsg);
                    label.setForeground(this.getColorFromBoolean(treeMsg == null || treeMsg.isEmpty()));
                } else if (prefField.getIdxCode() == 6) {
                    String computeMsg = ListCriticityUtility.isConsistencyComputeMsg(ListCriticityTable.this._cAppl, critID);
                    label.setToolTipText(computeMsg);
                    label.setForeground(this.getColorFromBoolean(computeMsg == null || computeMsg.isEmpty()));
                } else {
                    label.setToolTipText(String.valueOf(value));
                }
                ListCriticityUtility.CriticityResult critResult = critID.getResult();
                if (critResult != null) {
                    if (prefField.getIdxCode() == 8) {
                        label.setForeground(this.getColorFromBoolean(critResult.getProbRespected()));
                    } else if (prefField.getIdxCode() == 9) {
                        label.setForeground(this.getColorFromBoolean(critResult.getOrderCritRespected()));
                        if ((Integer)value == -1) {
                            label.setToolTipText(ResMsgArbor.getString("MSG_LIST_CRITICITY_TABLE_NO_CUTS"));
                            label.setText("-");
                        }
                    } else if (prefField.getIdxCode() == 11) {
                        Boolean isEvidentRespected = critResult.getEvidentLSRRespected();
                        label.setForeground(this.getColorFromBoolean(isEvidentRespected));
                        if (isEvidentRespected == null) {
                            label.setText("-");
                        }
                    } else if (prefField.getIdxCode() == 12) {
                        Boolean isLatentRespected = critResult.getLatentLSRRespected();
                        label.setForeground(this.getColorFromBoolean(isLatentRespected));
                        if (isLatentRespected == null) {
                            label.setText("-");
                        }
                    }
                }
                if (prefField.getIdxCode() == 8) {
                    try {
                        double val = Double.parseDouble(value.toString());
                        label.setText(ListCriticityTable.this._formatter.format(val));
                    }
                    catch (NullPointerException err) {
                        _LOG.fine(err.toString());
                    }
                    catch (NumberFormatException err) {
                        _LOG.fine(err.toString());
                    }
                } else if (prefField.getIdxCode() == 11 || prefField.getIdxCode() == 12) {
                    try {
                        String valueStr = value.toString();
                        if (valueStr != null && valueStr.contains("(")) {
                            String valueProbEvents = valueStr.substring(valueStr.indexOf(40) + 1, valueStr.indexOf(41));
                            double val = Double.parseDouble(valueProbEvents);
                            label.setText(valueStr.replace(valueProbEvents, ListCriticityTable.this._formatter.format(val)));
                        }
                    }
                    catch (NullPointerException err) {
                        _LOG.fine(err.toString());
                    }
                    catch (NumberFormatException err) {
                        _LOG.fine(err.toString());
                    }
                }
                if (prefField.getIdxCode() == 7 && critID != null && critID.getCriticityCrit() != null) {
                    StringBuilder sb = new StringBuilder();
                    CriticityCriterion crit = critID.getCriticityCrit();
                    sb.append("<html>");
                    sb.append(ResMsgVoc.getString("VOC_PROBABILITY")).append(" : ").append(crit.getProbability());
                    sb.append("<br/>").append(ResMsgVoc.getString("VOC_ORDER")).append(" : ").append(crit.getOrder());
                    if (!Double.isNaN(crit.getLSREvident())) {
                        sb.append("<br/>").append(ResMsgVoc.getString("VOC_LSR_EVIDENT")).append(" : ").append(crit.getLSREvident());
                    }
                    if (!Double.isNaN(crit.getLSRLatent())) {
                        sb.append("<br/>").append(ResMsgVoc.getString("VOC_LSR_LATENT")).append(" : ").append(crit.getLSRLatent());
                    }
                    sb.append("</html>");
                    label.setToolTipText(sb.toString());
                }
                return label;
            }

            private final Color getColorFromBoolean(Boolean bool) {
                if (bool == null) {
                    return Color.BLACK;
                }
                if (bool.booleanValue()) {
                    return new Color(0, 180, 0);
                }
                return Color.RED;
            }
        };
    }
}

