/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class ListCriticityUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void apercuFileXML(Object input) {
        InputStream istream = null;
        if (input instanceof InputStream) {
            istream = (InputStream)input;
        }
        BufferedReader br = null;
        try {
            if (istream == null) {
                istream = new FileInputStream((File)input);
            }
            br = new BufferedReader(new InputStreamReader(istream));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            System.out.println(sb.toString());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final String isConsistencyTreeMsg(CAppl appl, CriticityIdentifier critId) {
        String msgError;
        if (critId.isALoopTree()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_LOOPED_EQ");
        }
        List<DBLogs.Log> logs = critId.getEquation().getLogs().getLogs(DBLogs.DBLevel.WARNING);
        Collection relations = critId.getEquation().getUseRelations();
        for (DBRelation relation : relations) {
            DBWrap wrap;
            List<DBLogs.Log> logsRelated;
            DBFolder related = relation.getDestination();
            if (related.getFamilyFlag() != 2 && related.getFamilyFlag() != 3 && related.getFamilyFlag() != 5 || (logsRelated = (wrap = ((CECFactory)appl.getDAOFactory()).findOrCreateWrap(related)).getLogs().getLogs(DBLogs.DBLevel.WARNING)) == null || logsRelated.isEmpty()) continue;
            logs.addAll(logsRelated);
        }
        if (logs != null && !logs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (DBLogs.Log log : logs) {
                sb.append(log.getMessage()).append("<br>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        if (critId.getTreeInfo() != null && (msgError = critId.getTreeInfo().getParameters().get("tree.error")) != null && !msgError.isEmpty()) {
            return msgError;
        }
        return null;
    }

    public static final String isConsistencyComputeMsg(CAppl appl, CriticityIdentifier critID) {
        String isConsistencyTreeMsg = ListCriticityUtility.isConsistencyTreeMsg(appl, critID);
        if (isConsistencyTreeMsg != null && !isConsistencyTreeMsg.isEmpty()) {
            return isConsistencyTreeMsg;
        }
        DBFolder projectFolder = ListCriticityUtility.getDBProjectFolder(critID.getFolder());
        DBProject project = (DBProject)((CECFactory)appl.getDAOFactory()).findOrCreateWrap(projectFolder);
        if (project == null || project.getCriticityCriterium() == null || project.getCriticityCriterium().isEmpty()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_NO_CRIT_PROJ");
        }
        if (critID.getCriticityCrit() == null) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_NO_CRIT_TREE");
        }
        if (critID.getResult() == null || !critID.getResult().getCriticity().equals(critID.getCriticityCrit().getName())) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_DIFF_CRIT");
        }
        String xmlCRCOK = critID.getTreeInfo().getParameters().get("CRC.Xml.equals");
        if (xmlCRCOK == null || xmlCRCOK.equals("false")) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_OUT_OF_DATE");
        }
        if (critID.getResult() == null) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_NO_RESULT_FROM_XML");
        }
        if (!critID.getResult().isAComputeCriticity()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_NO_VALID_RESULT");
        }
        return null;
    }

    public static final DBFolder getDBProjectFolder(DBFolder folder) {
        assert (folder.getFamily() == DBFolder.Family.PROJECT);
        assert (folder.getFamilyFlag() == 2 || folder.getFamilyFlag() == 5);
        while (!folder.getParent().isSystem()) {
            folder = folder.getParent();
        }
        return folder;
    }

    public static final class CriticityIdentifier {
        private final DBFolder _folder;
        private final FTEquation _equation;
        private final CriticityResult _criticityResult;
        private final CriticityCriterion _criticityCrit;
        private final TreeInfoCompute _infoCompute;
        private boolean _isALoopTree;

        public CriticityIdentifier(DBFolder folder, FTEquation equation, CriticityResult criticityResult, CriticityCriterion criticityCrit, TreeInfoCompute infoCompute) {
            this._folder = folder;
            this._equation = equation;
            this._criticityResult = criticityResult;
            this._criticityCrit = criticityCrit;
            this._infoCompute = infoCompute;
        }

        public void setIsALoopTree(boolean isALoopTree) {
            this._isALoopTree = isALoopTree;
        }

        public boolean isALoopTree() {
            return this._isALoopTree;
        }

        public DBFolder getFolder() {
            return this._folder;
        }

        public FTEquation getEquation() {
            return this._equation;
        }

        public CriticityResult getResult() {
            return this._criticityResult;
        }

        public CriticityCriterion getCriticityCrit() {
            return this._criticityCrit;
        }

        public TreeInfoCompute getTreeInfo() {
            return this._infoCompute;
        }
    }

    public static class CriticityResult {
        private String _criticity = null;
        private Boolean _probRespected = null;
        private Double _probValue = null;
        private Boolean _orderCritRespected = null;
        private Integer _orderValue = null;
        private Boolean _evidentLSRRespected = null;
        private String _evidentLSRCutError = null;
        private Boolean _latentLSRRespected = null;
        private String _latentLSRCutError = null;
        private String _attributeCriterion = null;

        public boolean isALSRCompute() {
            return this._evidentLSRRespected != null || this._latentLSRRespected != null;
        }

        public void setCriticity(String criticity) {
            this._criticity = criticity;
        }

        public String getCriticity() {
            return this._criticity;
        }

        public void setProbRespected(Boolean probRespected) {
            this._probRespected = probRespected;
        }

        public Boolean getProbRespected() {
            return this._probRespected;
        }

        public void setProbValue(double probValue) {
            this._probValue = probValue;
        }

        public Double getProbValue() {
            return this._probValue;
        }

        public void setOrderCritRespected(Boolean orderCritRespected) {
            this._orderCritRespected = orderCritRespected;
        }

        public Boolean getOrderCritRespected() {
            return this._orderCritRespected;
        }

        public void setOrderValue(int orderValue) {
            this._orderValue = orderValue;
        }

        public Integer getOrderValue() {
            return this._orderValue;
        }

        public void setEvidentLSRCutMsg(String evidentLSRCutFailed) {
            this._evidentLSRCutError = evidentLSRCutFailed;
        }

        public void setEvidentLSRRespected(Boolean evidentLSRRespected) {
            this._evidentLSRRespected = evidentLSRRespected;
        }

        public Boolean getEvidentLSRRespected() {
            return this._evidentLSRRespected;
        }

        public String getEvidentLSRCutError() {
            return this._evidentLSRCutError;
        }

        public void setLatentLSRCutMsg(String latentLSRCutFailed) {
            this._latentLSRCutError = latentLSRCutFailed;
        }

        public void setLatentLSRRespected(Boolean latentLSRRespected) {
            this._latentLSRRespected = latentLSRRespected;
        }

        public Boolean getLatentLSRRespected() {
            return this._latentLSRRespected;
        }

        public String getLatentLSRCutError() {
            return this._latentLSRCutError;
        }

        public void setAttributeCriterion(String attributeCriterionStr) {
            this._attributeCriterion = attributeCriterionStr;
        }

        public void setAttributeCriterion(String name, String oper, String data) {
            this._attributeCriterion = name + ' ' + oper + ' ' + data;
        }

        public String getAttributeCriterion() {
            return this._attributeCriterion;
        }

        public boolean isAComputeCriticity() {
            return this.getOrderCritRespected() != null || this.getProbRespected() != null || this.getEvidentLSRRespected() != null || this.getLatentLSRRespected() != null;
        }

        public final void writeCriticityAbstract(Writer writer, String indent) throws IOException {
            writer.append(indent).append("<ftc.criticity").append(">\n");
            if (this._probRespected != null) {
                writer.append(indent).append("  <").append("ftc.criticity.proba").append(' ').append("result").append("='").append(OKKO.getEnumByValue(this._probRespected).name()).append("' ").append("value").append("='").append(String.valueOf(this._probValue)).append("' />\n");
            }
            if (this._orderCritRespected != null) {
                writer.append(indent).append("  <").append("ftc.criticity.order").append(' ').append("result").append("='").append(OKKO.getEnumByValue(this._orderCritRespected).name()).append("' ").append("value").append("='").append(String.valueOf(this._orderValue)).append("' />\n");
            }
            if (this._evidentLSRRespected != null) {
                writer.append(indent).append("  <").append("ftc.criticity.evidentLSR").append(' ').append("result").append("='").append(OKKO.getEnumByValue(this._evidentLSRRespected).name()).append("' ").append("value").append("='").append(this._evidentLSRCutError).append("' />\n");
            }
            if (this._latentLSRRespected != null) {
                writer.append(indent).append("  <").append("ftc.criticity.latentLSR").append(' ').append("result").append("='").append(OKKO.getEnumByValue(this._latentLSRRespected).name()).append("' ").append("value").append("='").append(this._latentLSRCutError).append("' />\n");
            }
            if (this._attributeCriterion != null) {
                String[] splitedAttr = this._attributeCriterion.split(" ");
                writer.append(indent).append("  <").append("ftc.criticity.attrCriterion").append(' ').append("attr").append("='").append(splitedAttr[0]).append("' ").append("oper").append("='").append(splitedAttr[1]).append("' ").append("value").append("='").append(splitedAttr[2].substring(1, splitedAttr[2].length() - 1)).append("' />\n");
            }
            writer.append(indent).append("</ftc.criticity").append(">\n");
        }

        public static enum OKKO {
            OK,
            KO,
            NaN;


            private static final OKKO getEnumByValue(Boolean bool) {
                if (bool == null) {
                    return NaN;
                }
                if (bool.booleanValue()) {
                    return OK;
                }
                return KO;
            }
        }
    }
}

