/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ImageDefinition;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBook;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBookPageRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.freehep.graphicsio.emf.EMFGraphics2D;

public class ExpFTGraphicTree
extends ExpSection {
    private static Logger _LOG = Logger.getLogger(ExpFTGraphicTree.class.getPackage().getName());
    FTEquation _ftEqu;
    boolean _bForceWithoutSubTree = false;
    private int _levelGSR = -1;

    public ExpFTGraphicTree(FTEquation ftEqu) {
        this._ftEqu = ftEqu;
    }

    public ExpFTGraphicTree configLevelGSR(int levelGSR) {
        this._levelGSR = levelGSR;
        return this;
    }

    public ExpFTGraphicTree setForceWithoutSubTree(boolean value) {
        this._bForceWithoutSubTree = value;
        return this;
    }

    @Override
    public String getTitle() {
        return ResMsgArbor.getString("KEY_0151").toUpperCase();
    }

    @Override
    protected void writeContentDocbook(DBKOutput output) throws IOException {
        ExpBook expBook = this.getBook();
        if (expBook == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        FGBook fgBook = new FGBook(this._ftEqu);
        fgBook.getContext().setLawManager(expBook.getDAOFactory().getLawManager());
        fgBook.updateFromPreferencies(expBook.getPreferencies());
        if (this._levelGSR > 0) {
            fgBook.setLimitDepth(this._levelGSR);
            fgBook.setWithLimit(true);
        }
        if (this._bForceWithoutSubTree) {
            fgBook.setWithSubTree(false);
        }
        fgBook.prepare();
        FGBookPageRenderer fgBookRenderer = new FGBookPageRenderer(fgBook);
        fgBookRenderer.updateFromPreferencies(expBook.getPreferencies());
        fgBookRenderer.setWithLogo(false).setWithCopyright(false);
        PageFormat format = expBook.getPageFormat();
        int ws = (int)format.getImageableWidth();
        int hs = (int)format.getImageableHeight();
        File pathImg = expBook.getImagPath(output.getXmlOutputFile());
        for (int i = 0; i < fgBook.getNumberOfPages(); ++i) {
            String nameFile = "Tree_" + fgBook.getPageAt(i).getTopVar().getName();
            nameFile = nameFile.replaceAll("[^A-Za-z0-9\\_\\-\\.]", "_");
            ArrayList<ImageDefinition> imags = new ArrayList<ImageDefinition>();
            imags.add(ExpFTGraphicTree.exportEMF(fgBookRenderer, i, ws, hs, nameFile, pathImg));
            imags.addAll(ExpFTGraphicTree.exportPNG(fgBookRenderer, i, ws, hs, nameFile, pathImg));
            output.insertImage("", "", imags.toArray(new ImageDefinition[imags.size()]));
        }
    }

    private static ImageDefinition exportEMF(FGBookPageRenderer fgBookRenderer, int i, int ws, int hs, String nameFile, File pathImg) {
        try {
            File tmpFile = File.createTempFile(nameFile, ".emf", pathImg);
            EMFGraphics2D graphics = new EMFGraphics2D(tmpFile, new Dimension(ws + 5, hs + 5));
            graphics.startExport();
            fgBookRenderer.display((Graphics2D)graphics, ws, hs, 2.0, i);
            graphics.endExport();
            ImageDefinition imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "EMF");
            imagDef.addAttribute("scale", "100");
            imagDef.addAttribute("width", Integer.toString(ws) + "px");
            imagDef.addAttribute("depth", Integer.toString(hs) + "px");
            return imagDef;
        }
        catch (Exception exc) {
            _LOG.log(Level.INFO, "Exception lors de la conversion EMF de la page " + i + "(TopEvent:" + fgBookRenderer.getBook().getPageAt(i).getTopVar().getName() + ") de l'arbre " + fgBookRenderer.getBook().getEquation().getDBFolder().getRefPath(), exc);
            return null;
        }
    }

    private static Collection<ImageDefinition> exportPNG(FGBookPageRenderer fgBookRenderer, int i, int ws, int hs, String nameFile, File pathImg) {
        try {
            File tmpFile = File.createTempFile(nameFile, ".png", pathImg);
            BufferedImage imgZoom = null;
            double lscale = 3.0;
            int marge = 5;
            int wsi = (int)((double)ws * lscale) + marge;
            int hsi = (int)((double)hs * lscale) + marge;
            imgZoom = new BufferedImage(wsi, hsi, 13);
            Graphics2D graphics = imgZoom.createGraphics();
            graphics.setClip(0, 0, wsi, hsi);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, wsi, hsi);
            graphics.setColor(Color.black);
            fgBookRenderer.display(graphics, wsi - marge, hsi - marge, 1.0, i);
            imgZoom.flush();
            ImageIO.write((RenderedImage)imgZoom, "png", tmpFile);
            ArrayList<ImageDefinition> result = new ArrayList<ImageDefinition>(3);
            ImageDefinition imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "PNG");
            imagDef.addAttribute("width", "100%");
            imagDef.addAttribute("scalefit", "1");
            imagDef.addAttribute("contentdepth", "100%");
            imagDef.setRole("fo");
            result.add(imagDef);
            imagDef = new ImageDefinition(pathImg.getName() + "/" + tmpFile.getName(), "PNG");
            imagDef.addAttribute("width", "800");
            imagDef.addAttribute("contentwidth", "800");
            imagDef.setRole("html");
            result.add(imagDef);
            return result;
        }
        catch (Exception exc) {
            _LOG.log(Level.INFO, "Exception lors de la conversion PNG de la page " + i + "(TopEvent:" + fgBookRenderer.getBook().getPageAt(i).getTopVar().getName() + ") de l'arbre " + fgBookRenderer.getBook().getEquation().getDBFolder().getRefPath(), exc);
            return null;
        }
    }
}

