/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDlgChooser;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FTEquationPanelSelect
extends JPanel {
    private static final Logger _LOG = Logger.getLogger(FTEquationPanelSelect.class.getPackage().getName());
    CeciliaAppl _appl;
    boolean _bReduced;
    Collection<DBFolder> _excludeFolders;
    boolean _bWithDSF = false;
    boolean _bWithTree = true;
    FTEquationAbstract _select;
    JTextField _ctrlInput;
    JButton _ctrlEdit;
    JLabel _labelLaw;
    private static final String _EMPTY_LABEL = "                  ";
    private FTEquationDlgChooser _dbFTChooser = null;
    private Object _LockerDlgChooser = new Object();
    boolean _bModified = false;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public FTEquationPanelSelect(CeciliaAppl appl, boolean reduced) {
        super(new GridBagLayout());
        this._appl = appl;
        this._bReduced = reduced;
        this.make();
    }

    public FTEquationPanelSelect defineExcludeFolders(Collection<DBFolder> excludes) {
        this._excludeFolders = excludes;
        return this;
    }

    public FTEquationPanelSelect setFilterDSF(boolean value) {
        this._bWithDSF = value;
        return this;
    }

    public FTEquationPanelSelect setFilterTree(boolean value) {
        this._bWithTree = value;
        return this;
    }

    protected void refreshWithEquation(FTEquationAbstract equation) {
        if (equation == null) {
            this._labelLaw.setText(_EMPTY_LABEL);
        } else {
            this._labelLaw.setText(equation.getAbstract());
        }
    }

    public boolean isInput() {
        String path = this._ctrlInput.getText();
        if (path == null) {
            return false;
        }
        return !path.isEmpty();
    }

    public void setEquation(FTEquationAbstract equation) {
        this._select = equation;
        if (equation != null) {
            this._ctrlInput.setText(equation.getDBFolder().getRefPath());
        } else {
            this._ctrlInput.setText("");
        }
        this.refreshWithEquation(equation);
    }

    public FTEquationAbstract getEquation() {
        DBFolder dbSelect = this.getSelectFolder();
        return this.getEquation(dbSelect);
    }

    private void make() {
        this._ctrlInput = new CTextFieldWithCallback(35){

            @Override
            protected void notifyChange() {
                FTEquationPanelSelect.this.setModified(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                FTEquationPanelSelect.this.refreshWithEquation(FTEquationPanelSelect.this.getEquation());
            }
        };
        this._ctrlEdit = new JButton("...");
        this._labelLaw = new JLabel(_EMPTY_LABEL);
        this._labelLaw.setHorizontalAlignment(0);
        if (this._bReduced) {
            this.add((Component)this._ctrlInput, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)this._ctrlEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 2, 5), 0, 0));
            this.add((Component)this._labelLaw, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        } else {
            this.add((Component)new JLabel(ResMsgVoc.getString("VOC_PATH")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0));
            this.add((Component)this._ctrlEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 2, 5), 0, 0));
            this.add((Component)this._ctrlInput, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)this._labelLaw, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        }
        this._ctrlEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTEquationPanelSelect.this.doClicAction();
            }
        });
    }

    public void setEditable(boolean editable) {
        this._ctrlInput.setEditable(editable);
        this._ctrlEdit.setEnabled(editable);
    }

    protected DBFolder getSelectFolder() {
        String path = this._ctrlInput.getText();
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return null;
        }
        DAOFolder daoFolder = this._appl.getDAOFactory().createFolderDAO();
        DBFolder rootPath = daoFolder.getRootID(DBFolder.Family.PROJECT.getRootName());
        DBFolder result = daoFolder.findFolder(rootPath, path, false);
        if (this._excludeFolders != null && this._excludeFolders.contains(result)) {
            return null;
        }
        return result;
    }

    protected FTEquationAbstract getEquation(DBFolder dbSelect) {
        if (dbSelect == null) {
            return null;
        }
        if (dbSelect.getFamily() != DBFolder.Family.PROJECT) {
            return null;
        }
        DBWrap dbWrap = this._appl.getDAOFactory().findOrCreateWrap(dbSelect);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof FTEquationAbstract)) {
            _LOG.warning("FTEquationPanelSelect: Le folder selecte n'est pas une equation: " + dbSelect);
            return null;
        }
        return (FTEquationAbstract)dbWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FTEquationDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (this._dbFTChooser == null) {
            FTEquationDlgChooser dlg = null;
            Object object = this._LockerDlgChooser;
            synchronized (object) {
                if (this._dbFTChooser == null) {
                    dlg = new FTEquationDlgChooser(win, appl);
                    dlg.setFilterDSF(this._bWithDSF);
                    dlg.setFilterTree(this._bWithTree);
                    dlg.defineExcludeFolders(this._excludeFolders);
                    dlg.getCtrlSelect().resetCache();
                }
                if (this._dbFTChooser == null) {
                    this._dbFTChooser = dlg;
                }
            }
        }
        return this._dbFTChooser;
    }

    protected void doClicAction() {
        FTEquationDlgChooser dlg = this.getDlgChooser(SwingUtilities.getWindowAncestor(this), this._appl);
        DBFolder dbSelect = this.getSelectFolder();
        dlg.setSelectFolder(dbSelect);
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        dbSelect = dlg.getSelectFolder();
        if (dbSelect == null) {
            this.refreshWithEquation(null);
        } else {
            this._ctrlInput.setText(dbSelect.getRefPath());
            this.refreshWithEquation(this.getEquation(dbSelect));
        }
        this.setModified(true);
        this.fireChangeDepends();
    }

    public JComponent getFocusableComponent() {
        return this._ctrlInput;
    }

    public void setModified(boolean bModified) {
        this._bModified = bModified;
    }

    public boolean isModified() {
        return this._bModified;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }
}

