/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.filter;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAbstract;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterLaw;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterString;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.gui.AttributeCriterionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class FilterDlgExtended
extends JDialogCecilia {
    Map<DBAttrib, Set<String>> _attributes;
    JCheckBox _projectCheck;
    JTextField _projectText;
    JCheckBox _systemCheck;
    JTextField _systemText;
    JCheckBox _treeCheck;
    JTextField _treeText;
    JCheckBox _eventSelectCheck;
    JCheckBox _evtTypeGateCheck;
    JCheckBox _evtTypeLeafCheck;
    JCheckBox _evtTypeSubTreeCheck;
    JCheckBox _evtTypeRootCheck;
    JCheckBox _evtTypeDSFCheck;
    JCheckBox _evtTypeInspectedCheck;
    JCheckBox _evtTypeTestedCheck;
    JButton _evtTypeAllBut;
    JButton _evtTypeNoneBut;
    JCheckBox _evtLawCheck;
    JComboBox _evtLawTypeCBox;
    JComboBox _evtLawOpCBox;
    JTextField _evtLawText;
    JCheckBox _evtAttrCheck;
    JTextField _evtAttrText;
    JButton _evtAttrBut;
    AttrCriterion _evtAttrSelect;
    JCheckBox _evtNameCheck;
    JTextField _evtNameText;
    JCheckBox _evtRemarkCheck;
    JTextField _evtRemarkText;
    ActionListener _updaterCtrls = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterDlgExtended.this.updateCtrls();
        }
    };
    boolean _bOnlyEventFilter = false;

    JCheckBox createCheckBox(FilterAbstract filterData) {
        return new JCheckBox(filterData.toString());
    }

    JTextField createTextField() {
        JTextField result = new JTextField("");
        result.setColumns(50);
        result.setEditable(false);
        return result;
    }

    void prepareStringFilter(JPanel owner, int idxRow, final JCheckBox check, final JTextField text) {
        owner.add((Component)check, new GridBagConstraints(0, idxRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        owner.add((Component)text, new GridBagConstraints(1, idxRow, 5, 1, 1.0, 0.0, 13, 2, new Insets(10, 5, 5, 5), 0, 0));
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                text.setEditable(check.isSelected());
            }
        });
    }

    public void copyToCtrl(FilterString filterString, JCheckBox check, JTextField text) {
        check.setSelected(filterString.isSelected());
        text.setText(filterString.getSearchString());
        text.setEditable(check.isSelected());
    }

    public void copyFromCtrl(FilterString filterString, JCheckBox check, JTextField text) {
        boolean select = check.isSelected() && text.getText().length() > 0;
        filterString.setSelected(select);
        if (select) {
            filterString.setSearchString(text.getText());
        }
    }

    protected abstract Map<DBAttrib, Set<String>> createAttributes();

    public FilterDlgExtended(Window win) {
        super(win, ResMsgVoc.getString("VOC_FILTER"), true);
    }

    public void setOnlyEventFilter(boolean value) {
        this._bOnlyEventFilter = value;
    }

    public boolean getOnlyEventFilter() {
        return this._bOnlyEventFilter;
    }

    public void create() {
        this._attributes = this.createAttributes();
        if (this._attributes == null) {
            this._attributes = new HashMap<DBAttrib, Set<String>>();
        }
        for (Map.Entry<DBAttrib, Set<String>> entry : this._attributes.entrySet()) {
            if (entry.getKey().getType() != AttrType.ENUM) continue;
            entry.getValue().addAll(entry.getKey().getEnums());
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new GridBagLayout());
        int idxRow = 0;
        if (!this._bOnlyEventFilter) {
            this._projectCheck = new JCheckBox(ResMsgVoc.getString("VOC_PROJECT"));
            this._projectText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, this._projectCheck, this._projectText);
            this._systemCheck = new JCheckBox(ResMsgVoc.getString("VOC_SYSTEM"));
            this._systemText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, this._systemCheck, this._systemText);
            this._treeCheck = new JCheckBox(ResMsgVoc.getString("VOC_TREE"));
            this._treeText = this.createTextField();
            this.prepareStringFilter(centerPanel, idxRow++, this._treeCheck, this._treeText);
        }
        JPanel eventPanel = null;
        if (!this._bOnlyEventFilter) {
            eventPanel = new JPanel(new ToggleBorderLayout());
        }
        this._eventSelectCheck = new JCheckBox(ResMsgVoc.getString("VOC_EVENT"));
        this._eventSelectCheck.addActionListener(this._updaterCtrls);
        JPanel evtContentPanel = new JPanel(new GridBagLayout());
        int idxEvtRow = 0;
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgArbor.getString("KEY_0207")));
        JPanel listTypePanel = new JPanel(new GridLayout(4, 2));
        this._evtTypeRootCheck = new JCheckBox(ResMsgVoc.getString("VOC_ROOTS"));
        listTypePanel.add(this._evtTypeRootCheck);
        this._evtTypeGateCheck = new JCheckBox(ResMsgVoc.getString("VOC_INERMEDIATES"));
        listTypePanel.add(this._evtTypeGateCheck);
        this._evtTypeLeafCheck = new JCheckBox(ResMsgVoc.getString("VOC_UNDEVELOPED"));
        listTypePanel.add(this._evtTypeLeafCheck);
        this._evtTypeSubTreeCheck = new JCheckBox(ResMsgVoc.getString("VOC_SUBTREE"));
        listTypePanel.add(this._evtTypeSubTreeCheck);
        this._evtTypeDSFCheck = new JCheckBox(ResMsgVoc.getString("VOC_DSF"));
        listTypePanel.add(this._evtTypeDSFCheck);
        this._evtTypeInspectedCheck = new JCheckBox(ResMsgVoc.getString("VOC_INSPECTED"));
        listTypePanel.add(this._evtTypeInspectedCheck);
        this._evtTypeTestedCheck = new JCheckBox(ResMsgVoc.getString("VOC_INFLIGHT_TESTED"));
        listTypePanel.add(this._evtTypeTestedCheck);
        typePanel.add((Component)listTypePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 5), 0, 0));
        JPanel butTypePanel = new JPanel(new GridLayout(2, 1));
        this._evtTypeAllBut = new JButton(ResMsgVoc.getString("VOC_ALL"));
        butTypePanel.add(this._evtTypeAllBut);
        this._evtTypeNoneBut = new JButton(ResMsgVoc.getString("VOC_NONE"));
        butTypePanel.add(this._evtTypeNoneBut);
        typePanel.add((Component)butTypePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._evtTypeGateCheck.addActionListener(this._updaterCtrls);
        this._evtTypeRootCheck.addActionListener(this._updaterCtrls);
        this._evtTypeLeafCheck.addActionListener(this._updaterCtrls);
        this._evtTypeSubTreeCheck.addActionListener(this._updaterCtrls);
        this._evtTypeDSFCheck.addActionListener(this._updaterCtrls);
        this._evtTypeInspectedCheck.addActionListener(this._updaterCtrls);
        this._evtTypeTestedCheck.addActionListener(this._updaterCtrls);
        this._evtTypeAllBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterDlgExtended.this._evtTypeGateCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeGateCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeRootCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeRootCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeLeafCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeLeafCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeSubTreeCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeSubTreeCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeDSFCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeDSFCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeInspectedCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeInspectedCheck.setSelected(true);
                }
                if (FilterDlgExtended.this._evtTypeTestedCheck.isEnabled()) {
                    FilterDlgExtended.this._evtTypeTestedCheck.setSelected(true);
                }
                FilterDlgExtended.this.updateCtrls();
            }
        });
        this._evtTypeNoneBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDlgExtended.this._evtTypeGateCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeRootCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeLeafCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeSubTreeCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeDSFCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeInspectedCheck.setSelected(false);
                FilterDlgExtended.this._evtTypeTestedCheck.setSelected(false);
                FilterDlgExtended.this.updateCtrls();
            }
        });
        evtContentPanel.add((Component)typePanel, new GridBagConstraints(0, idxEvtRow++, 6, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this._evtNameCheck = new JCheckBox(ResMsgVoc.getString("VOC_NAME"));
        this._evtNameText = this.createTextField();
        this.prepareStringFilter(evtContentPanel, idxEvtRow++, this._evtNameCheck, this._evtNameText);
        this._evtRemarkCheck = new JCheckBox(ResMsgVoc.getString("VOC_COMMENT"));
        this._evtRemarkText = this.createTextField();
        this.prepareStringFilter(evtContentPanel, idxEvtRow++, this._evtRemarkCheck, this._evtRemarkText);
        this._evtLawCheck = new JCheckBox(ResMsgVoc.getString("VOC_LAW"));
        this._evtLawTypeCBox = new JComboBox();
        this._evtLawTypeCBox.addItem(FilterLaw.Type.CST);
        this._evtLawTypeCBox.addItem(FilterLaw.Type.EXP);
        this._evtLawTypeCBox.setEditable(false);
        this._evtLawOpCBox = new JComboBox();
        this._evtLawOpCBox.addItem(FilterLaw.Op.LT);
        this._evtLawOpCBox.addItem(FilterLaw.Op.LEq);
        this._evtLawOpCBox.addItem(FilterLaw.Op.GT);
        this._evtLawOpCBox.addItem(FilterLaw.Op.GEq);
        this._evtLawOpCBox.setEditable(false);
        this._evtLawText = new JTextField(15);
        this._evtLawText.setEditable(false);
        evtContentPanel.add((Component)this._evtLawCheck, new GridBagConstraints(0, idxEvtRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        evtContentPanel.add((Component)this._evtLawTypeCBox, new GridBagConstraints(1, idxEvtRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        evtContentPanel.add((Component)this._evtLawOpCBox, new GridBagConstraints(2, idxEvtRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        evtContentPanel.add((Component)this._evtLawText, new GridBagConstraints(3, idxEvtRow, 2, 1, 1.0, 0.0, 13, 2, new Insets(10, 5, 5, 5), 0, 0));
        this._evtLawCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = FilterDlgExtended.this._evtLawCheck.isSelected();
                FilterDlgExtended.this._evtLawTypeCBox.setEnabled(selected);
                FilterDlgExtended.this._evtLawOpCBox.setEnabled(selected);
                FilterDlgExtended.this._evtLawText.setEnabled(selected);
                FilterDlgExtended.this._evtLawText.setEditable(selected);
            }
        });
        ++idxEvtRow;
        this._evtAttrCheck = new JCheckBox(ResMsgVoc.getString("VOC_ATTRIBUTE"));
        this._evtAttrText = new JTextField(15);
        this._evtAttrText.setEditable(false);
        this._evtAttrText.setEnabled(false);
        this._evtAttrBut = new JButton(ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_"));
        final ActionListener editAttribute = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSelectCriterion dlg = new DlgSelectCriterion(SwingUtilities.getWindowAncestor(FilterDlgExtended.this._evtAttrBut));
                dlg._ctrlPanel.setAttributes(FilterDlgExtended.this._attributes);
                if (FilterDlgExtended.this._evtAttrSelect != null) {
                    dlg._ctrlPanel.setCurrentAttributeCriterion(FilterDlgExtended.this._evtAttrSelect);
                }
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    FilterDlgExtended.this._evtAttrSelect = dlg._ctrlPanel.getCurrentAttributeCriterion();
                }
                FilterDlgExtended.this.refreshAttrText();
                if (FilterDlgExtended.this._evtAttrSelect == null) {
                    FilterDlgExtended.this._evtAttrCheck.setSelected(false);
                }
            }
        };
        this._evtAttrBut.addActionListener(editAttribute);
        this._evtAttrCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean select = FilterDlgExtended.this._evtAttrCheck.isSelected();
                if (select && FilterDlgExtended.this._evtAttrSelect == null) {
                    editAttribute.actionPerformed(e);
                }
                FilterDlgExtended.this._evtAttrBut.setEnabled(FilterDlgExtended.this._evtAttrCheck.isSelected());
            }
        });
        evtContentPanel.add((Component)this._evtAttrCheck, new GridBagConstraints(0, idxEvtRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        evtContentPanel.add((Component)this._evtAttrText, new GridBagConstraints(1, idxEvtRow, 4, 1, 2.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        evtContentPanel.add((Component)this._evtAttrBut, new GridBagConstraints(5, idxEvtRow, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        ++idxEvtRow;
        if (this._bOnlyEventFilter) {
            eventPanel = evtContentPanel;
        } else {
            ToggleBorderLayout.configure(eventPanel, this._eventSelectCheck, evtContentPanel);
        }
        centerPanel.add((Component)eventPanel, new GridBagConstraints(0, idxRow++, 6, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(true), "South");
        this.pack();
    }

    public void refreshAttrText() {
        if (this._evtAttrSelect == null) {
            this._evtAttrText.setText("");
        } else {
            this._evtAttrText.setText(this._evtAttrSelect.toString());
        }
    }

    public void updateCtrls() {
        int nbrTypeSelect = 0;
        int nbrLawSelect = 0;
        if (this._evtTypeGateCheck.isSelected()) {
            ++nbrTypeSelect;
        }
        if (this._evtTypeRootCheck.isSelected()) {
            ++nbrTypeSelect;
        }
        if (this._evtTypeLeafCheck.isSelected()) {
            ++nbrTypeSelect;
            ++nbrLawSelect;
        }
        if (this._evtTypeSubTreeCheck.isSelected()) {
            ++nbrTypeSelect;
        }
        if (this._evtTypeDSFCheck.isSelected()) {
            ++nbrTypeSelect;
            ++nbrLawSelect;
        }
        if (this._evtTypeInspectedCheck.isSelected()) {
            ++nbrTypeSelect;
            ++nbrLawSelect;
        }
        if (this._evtTypeTestedCheck.isSelected()) {
            ++nbrTypeSelect;
            ++nbrLawSelect;
        }
        boolean nbrGT0 = nbrTypeSelect > 0;
        boolean eventSelect = this._eventSelectCheck.isSelected();
        if (!this._bOnlyEventFilter) {
            this._evtTypeGateCheck.setEnabled(eventSelect);
            this._evtTypeRootCheck.setEnabled(eventSelect);
            this._evtTypeLeafCheck.setEnabled(eventSelect);
            this._evtTypeSubTreeCheck.setEnabled(eventSelect);
            this._evtTypeDSFCheck.setEnabled(eventSelect);
            this._evtTypeInspectedCheck.setEnabled(eventSelect);
            this._evtTypeTestedCheck.setEnabled(eventSelect);
        }
        this._evtTypeAllBut.setEnabled(eventSelect && nbrTypeSelect < 6);
        if (!eventSelect) {
            nbrGT0 = false;
        }
        this._evtTypeNoneBut.setEnabled(nbrGT0);
        this._evtNameCheck.setEnabled(nbrGT0);
        this._evtNameText.setEnabled(nbrGT0);
        this._evtNameText.setEditable(nbrGT0 && this._evtNameCheck.isSelected());
        this._evtRemarkCheck.setEnabled(nbrGT0);
        this._evtRemarkText.setEnabled(nbrGT0);
        this._evtRemarkText.setEditable(nbrGT0 && this._evtRemarkCheck.isSelected());
        boolean terminalSelect = eventSelect && nbrLawSelect > 0;
        this._evtLawCheck.setEnabled(terminalSelect);
        if (!terminalSelect && this._evtLawCheck.isSelected()) {
            this._evtLawCheck.setSelected(false);
        }
        boolean lawSelect = terminalSelect && this._evtLawCheck.isSelected();
        this._evtLawTypeCBox.setEnabled(lawSelect);
        this._evtLawOpCBox.setEnabled(lawSelect);
        this._evtLawText.setEnabled(lawSelect);
        this._evtLawText.setEditable(lawSelect);
        this._evtAttrCheck.setEnabled(terminalSelect && this._attributes.size() > 0);
        if (this._attributes.size() == 0) {
            this._evtAttrCheck.setSelected(false);
        }
        if (!terminalSelect && this._evtAttrCheck.isSelected()) {
            this._evtAttrCheck.setSelected(false);
        }
        if (this._evtAttrSelect == null) {
            this._evtAttrCheck.setSelected(false);
        }
        this._evtAttrBut.setEnabled(terminalSelect && this._evtAttrCheck.isSelected());
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    public JCheckBox getEventSelectCheck() {
        return this._eventSelectCheck;
    }

    public JCheckBox getEvtTypeGateCheck() {
        return this._evtTypeGateCheck;
    }

    public JCheckBox getEvtTypeRootCheck() {
        return this._evtTypeRootCheck;
    }

    public JCheckBox getEvtTypeLeafCheck() {
        return this._evtTypeLeafCheck;
    }

    public JCheckBox getEvtTypeSubTreeCheck() {
        return this._evtTypeSubTreeCheck;
    }

    public JCheckBox getEvtTypeDSFCheck() {
        return this._evtTypeDSFCheck;
    }

    public JCheckBox getEvtTypeInspectedCheck() {
        return this._evtTypeInspectedCheck;
    }

    public JCheckBox getEvtTypeTestedCheck() {
        return this._evtTypeTestedCheck;
    }

    public JCheckBox getEvtLawCheck() {
        return this._evtLawCheck;
    }

    public FilterLaw.Type getEvtLawType() {
        return (FilterLaw.Type)((Object)this._evtLawTypeCBox.getSelectedItem());
    }

    public FilterLaw.Op getEvtLawOp() {
        return (FilterLaw.Op)((Object)this._evtLawOpCBox.getSelectedItem());
    }

    public double getEvtLawValue() {
        return Double.parseDouble(this._evtLawText.getText());
    }

    public void setEvtLawType(FilterLaw.Type value) {
        this._evtLawTypeCBox.setSelectedItem((Object)value);
    }

    public void setEvtLawOp(FilterLaw.Op value) {
        this._evtLawOpCBox.setSelectedItem((Object)value);
    }

    public void setEvtLawValue(double value) {
        this._evtLawText.setText(Double.toString(value));
    }

    public JCheckBox getEvtAttrCheck() {
        return this._evtAttrCheck;
    }

    public AttrCriterion getEvtAttrSelect() {
        return this._evtAttrSelect;
    }

    public void setEvtAttrSelect(AttrCriterion criter) {
        this._evtAttrSelect = criter;
        this.refreshAttrText();
    }

    public JCheckBox getEvtNameCheck() {
        return this._evtNameCheck;
    }

    public JTextField getEvtNameText() {
        return this._evtNameText;
    }

    public JCheckBox getEvtRemarkCheck() {
        return this._evtRemarkCheck;
    }

    public JTextField getEvtRemarkText() {
        return this._evtRemarkText;
    }

    public JCheckBox getProjectCheck() {
        return this._projectCheck;
    }

    public JTextField getProjectText() {
        return this._projectText;
    }

    public JCheckBox getSystemCheck() {
        return this._systemCheck;
    }

    public JTextField getSystemText() {
        return this._systemText;
    }

    public JCheckBox getTreeCheck() {
        return this._treeCheck;
    }

    public JTextField getTreeText() {
        return this._treeText;
    }

    protected static class DlgSelectCriterion
    extends JDialogCecilia {
        AttributeCriterionPanel _ctrlPanel = new AttributeCriterionPanel(null);

        DlgSelectCriterion(Window win) {
            super(win, ResMsgArbor.getString("KEY_1102"), true);
            this.setLayout(new BorderLayout());
            this.add((Component)this._ctrlPanel, "Center");
            this.add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(win));
        }

        @Override
        protected boolean verifyParameters() {
            return this._ctrlPanel.verifyParameters();
        }
    }
}

