/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.filter;

import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAbstract;
import java.util.List;
import java.util.Vector;

public abstract class FilterString<T>
extends FilterAbstract<T> {
    boolean _isSelect = false;
    String _strFilter = "";
    List<SearchString> _searchs;

    public FilterString(String strLabel) {
        super(strLabel);
    }

    public boolean isSelected() {
        return this._isSelect;
    }

    public void setSelected(boolean value) {
        this._isSelect = value;
    }

    public String getSearchString() {
        return this._strFilter;
    }

    public void setSearchString(String value) {
        this._strFilter = value;
        this._searchs = this._strFilter.length() > 0 ? FilterString.buildTabSearchString(this._strFilter) : null;
    }

    public abstract String getString(T var1);

    @Override
    public boolean filter(T row) {
        return !this._isSelect || this._searchs == null || FilterString.isASearchEvent(this.getString(row), this._searchs);
    }

    public static boolean isASearchEvent(String eventName, List<SearchString> tabSearchString) {
        String localEventName = new String(eventName);
        boolean before = false;
        for (SearchString searchString : tabSearchString) {
            int position;
            if (searchString.getValue().equals("") && searchString.isStringBefore()) {
                return true;
            }
            if (searchString.isStringAfter()) {
                position = localEventName.indexOf(searchString.getValue());
                if (position == -1) {
                    return false;
                }
                if (!searchString.isStringBefore() && (before || position != 0)) {
                    return false;
                }
            } else {
                position = localEventName.lastIndexOf(searchString.getValue());
                if (position == -1) {
                    return false;
                }
                if (!searchString.isStringBefore() && (before || position != 0)) {
                    return false;
                }
                if (position + searchString.getValue().length() < localEventName.length()) {
                    return false;
                }
            }
            localEventName = localEventName.substring(position + searchString.getValue().length());
            before = true;
        }
        return true;
    }

    public static Vector<SearchString> buildTabSearchString(String searchString) {
        Vector<SearchString> listSearchString = new Vector<SearchString>();
        char[] searchBuffer = searchString.toCharArray();
        boolean before = false;
        boolean after = false;
        String searchSubString = new String("");
        for (int i = 0; i < searchBuffer.length; ++i) {
            if (searchBuffer[i] == '*') {
                if (!before) {
                    if (!searchSubString.equals("")) {
                        after = true;
                        listSearchString.add(new SearchString(searchSubString, before, after));
                        searchSubString = new String("");
                        after = false;
                    }
                    before = true;
                    continue;
                }
                if (searchSubString.equals("")) continue;
                after = true;
                listSearchString.add(new SearchString(searchSubString, before, after));
                searchSubString = new String("");
                after = false;
                continue;
            }
            searchSubString = new String(searchSubString + searchBuffer[i]);
        }
        if (!searchSubString.equals("")) {
            listSearchString.add(new SearchString(searchSubString, before, after));
            searchSubString = new String("");
        } else if (listSearchString.size() == 0) {
            listSearchString.add(new SearchString("", true, false));
        }
        return listSearchString;
    }

    public static class SearchString {
        private String _value;
        private boolean _before;
        private boolean _after;

        public SearchString(String value, boolean before, boolean after) {
            this._value = new String(value);
            this._before = before;
            this._after = after;
        }

        public String getValue() {
            return this._value;
        }

        public boolean isStringBefore() {
            return this._before;
        }

        public boolean isStringAfter() {
            return this._after;
        }
    }
}

