/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io;

import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MCSResultHandler
extends DefaultHandler {
    private static Logger _LOG = Logger.getLogger(MCSResultHandler.class.getPackage().getName());
    FTEquation _ftEqu;
    int _nbrError = 0;
    boolean _withIF;

    public MCSResultHandler(FTEquation ftEqu) {
        this._ftEqu = ftEqu;
    }

    @Override
    public void startDocument() throws SAXException {
        this._ftEqu.clearResults();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this._nbrError > 0) {
            this._ftEqu.clearResults();
            throw new SAXException("Error during read results");
        }
        super.endDocument();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eltName;
        if (attrs == null) {
            return;
        }
        String string = eltName = "".equals(sName) ? qName : sName;
        if (eltName.equals("pr")) {
            this.readParameters(attrs);
        } else if (eltName.equals("if")) {
            this._withIF = true;
        } else if (eltName.equals("ftc.probability")) {
            this.readProbability(attrs);
        }
    }

    private void readParameters(Attributes attrs) throws SAXException {
        TypeProbability prType = null;
        int idx = attrs.getIndex("type");
        if (idx == -1) {
            throw new SAXException("No attribute 'type' for element 'pr' !");
        }
        String type = attrs.getValue(idx);
        try {
            prType = TypeProbability.valueOf(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (prType != null) {
            idx = attrs.getIndex("mission-time");
            if (idx == -1) {
                throw new SAXException("No attribute 'mission-time' for element 'pr' !");
            }
            String missionTime = attrs.getValue(idx);
            try {
                FTComputeParameters params = this._ftEqu.getComputeParameters();
                params.setTime(Double.parseDouble(missionTime));
                params.setType(prType);
                params.setAverageAttribute(null);
                if ((prType == TypeProbability.ARP1 || prType == TypeProbability.ARP2) && (idx = attrs.getIndex("average-risk-approach-attribute")) != -1) {
                    params.setAverageAttribute(attrs.getValue(idx));
                }
                if ((idx = attrs.getIndex("average-flight-duration")) != -1) {
                    params.setFlightDuration(Double.parseDouble(attrs.getValue(idx)));
                }
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
        }
    }

    private void readProbability(Attributes attrs) throws SAXException {
        FTVariableAbstract ftVar = null;
        int idx = attrs.getIndex("name");
        if (idx == -1) {
            throw new SAXException("No attribute 'name' for element 'ftc.probability' !");
        }
        String name = attrs.getValue(idx);
        ftVar = this._ftEqu.getVariable(name);
        if (ftVar == null && ++this._nbrError <= 5) {
            _LOG.fine("Unknown variable during read results : " + name);
        }
        if (ftVar != null) {
            block10: {
                idx = attrs.getIndex("pr");
                if (idx == -1) {
                    throw new SAXException("No attribute 'pr' for element 'ftc.probability' !");
                }
                String proba = attrs.getValue(idx);
                try {
                    ftVar.setProbability(Double.parseDouble(proba));
                }
                catch (NumberFormatException nfe) {
                    if (++this._nbrError > 5) break block10;
                    _LOG.fine("Double probability format error '" + ftVar.getName() + "' : " + proba);
                }
            }
            if (this._withIF && ftVar.getEvent() != null) {
                for (FTEvent.IF thisIF : FTEvent.IF.values()) {
                    int idx2 = attrs.getIndex(thisIF.toString().toLowerCase());
                    if (idx2 == -1) continue;
                    String proba = attrs.getValue(idx2);
                    try {
                        ftVar.getEvent().addIF(thisIF, Double.parseDouble(proba));
                    }
                    catch (NumberFormatException nfe) {
                        if (++this._nbrError > 5) continue;
                        _LOG.fine("Double importance-factor format error '" + ftVar.getName() + "' : " + proba);
                    }
                }
            }
        }
    }
}

