/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolBigNode;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolBigParser;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolNode;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EquBoolBigStore
implements EquBoolStore {
    private static Logger _LOG = Logger.getLogger(EquBoolBigStore.class.getPackage().getName());
    private Map<String, EquBoolBigNode> _variables = new LinkedHashMap<String, EquBoolBigNode>();
    private Map<String, String> _parameters = new LinkedHashMap<String, String>();
    private List<String> _syntaxError = new ArrayList<String>();
    private static final boolean __COPY_READER = false;

    public void clearAll() {
        this._variables.clear();
        this._parameters.clear();
        this._syntaxError.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFile(String name) {
        Reader br = null;
        try {
            File f = new File(name);
            br = new FileReader(f);
            _LOG.fine("Lecture de " + name + " .");
            boolean bl = this.parseFile(br);
            return bl;
        }
        catch (FileNotFoundException fnf) {
            _LOG.log(Level.WARNING, "Le fichier " + name + " est introuvable.", fnf);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    _LOG.log(Level.FINE, "Exception during close stream", e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadStream(Reader in) {
        try {
            boolean bl = this.parseFile(in);
            return bl;
        }
        finally {
            try {
                in.close();
                _LOG.finest("Close EquBoolBigStore::loadStream(...)");
            }
            catch (Exception e) {
                _LOG.log(Level.INFO, "Exception during close stream", e);
            }
        }
    }

    public boolean parseFile(Reader br) {
        Object copy = null;
        EquBoolBigParser parse = null;
        parse = new EquBoolBigParser(br, this);
        try {
            parse.yyparse();
            if (this._syntaxError.size() > 0) {
                return false;
            }
            return this.separateNodes();
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Line " + parse.getCurrentLine() + " : Internal lexer error [" + e.getMessage() + "]", e);
            this.clearAll();
            return false;
        }
    }

    private boolean separateNodes() {
        for (EquBoolBigNode var : this._variables.values()) {
            var.setFlag(0);
        }
        for (EquBoolBigNode var : this._variables.values()) {
            if (this.separateNodes_rec(var)) continue;
            return false;
        }
        for (EquBoolBigNode var : this._variables.values()) {
            var.setFlag(0);
            if (var.getDepends() == null) {
                var.setLeaf();
                continue;
            }
            if (var.isRight()) {
                var.setGate();
                continue;
            }
            var.setRoot();
        }
        return true;
    }

    private boolean separateNodes_rec(EquBoolBigNode var) {
        if (var.getFlag() == 1) {
            return true;
        }
        if (var.getFlag() == 2) {
            String msg = "Loop equations: " + var.getName();
            _LOG.severe(msg);
            this.addSyntaxError(msg);
            return false;
        }
        var.setFlag(2);
        if (var.getDepends() != null) {
            for (EquBoolBigNode child : var.getDepends()) {
                child.setRight();
                if (this.separateNodes_rec(child)) continue;
                return false;
            }
        }
        var.setFlag(1);
        return true;
    }

    public EquBoolBigNode createUniqueVariable(String name) {
        EquBoolBigNode node = null;
        try {
            node = this._variables.get(name);
            if (node == null) {
                node = new EquBoolBigNode(name);
                this._variables.put(name, node);
            }
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Error creating variable " + name, e);
        }
        return node;
    }

    void setLawToVariables(Collection<String> variables, String law) {
        for (String id : variables) {
            EquBoolBigNode node = this._variables.get(id);
            if (node == null) {
                _LOG.info("Variable [" + id + "] unknow");
                continue;
            }
            node.addAttribute("#Law", law);
        }
    }

    void setAttributesToVariable(Collection<String> variables, String name, String value) {
        for (String id : variables) {
            EquBoolBigNode node = this._variables.get(id);
            if (node == null) {
                _LOG.info("Variable [" + id + "] unknow");
                continue;
            }
            node.addAttribute(name, value);
        }
    }

    void setParameter(String parameter, String value) {
        this._parameters.put(parameter, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    public void printNodes(Writer out) throws IOException {
        TreeMap<String, String> parameters = new TreeMap<String, String>(this._parameters);
        for (Map.Entry param : parameters.entrySet()) {
            out.write("parameter set ");
            out.write((String)param.getKey());
            out.write(" ");
            out.write((String)param.getValue());
            out.write(";\n");
        }
        TreeMap<String, EquBoolBigNode> variables = new TreeMap<String, EquBoolBigNode>(this._variables);
        for (EquBoolBigNode node : variables.values()) {
            if (node.isRoot()) {
                out.write("/* root : ");
                out.write(node.getName());
                out.write(" */\n");
            }
            if (!node.isLeaf()) continue;
            node.printLeaf(out, true);
        }
    }

    public void printStatistics(Writer out) throws IOException {
        int nbrRoots = 0;
        int nbrLeaves = 0;
        int nbrGates = 0;
        for (EquBoolBigNode node : this._variables.values()) {
            if (node.isRoot()) {
                ++nbrRoots;
                continue;
            }
            if (node.isLeaf()) {
                ++nbrLeaves;
                continue;
            }
            ++nbrGates;
        }
        out.write("/* Statistics\n");
        out.write("\tVariables : ");
        out.write(Integer.toString(this._variables.size()));
        out.write("\n");
        out.write("\t\tRoots : ");
        out.write(Integer.toString(nbrRoots));
        out.write("\n");
        out.write("\t\tLeaves : ");
        out.write(Integer.toString(nbrLeaves));
        out.write("\n");
        out.write("\t\tGates : ");
        out.write(Integer.toString(nbrGates));
        out.write("\n");
        out.write(" */\n");
    }

    public void saveFile(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write(filename);
            bw.flush();
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<EquBoolBigNode> getVariables() {
        ArrayList<EquBoolBigNode> result = new ArrayList<EquBoolBigNode>();
        for (EquBoolBigNode node : this._variables.values()) {
            if (node.isGate()) continue;
            result.add(node);
        }
        return result;
    }

    Set<String> getAllNames() {
        return this._variables.keySet();
    }

    @Override
    public List<String> getSyntaxError() {
        return this._syntaxError;
    }

    public void addSyntaxError(String error) {
        this._syntaxError.add(error);
    }

    @Override
    public boolean verify() {
        StringBuilder buffer = new StringBuilder();
        int nbrRoot = 0;
        for (EquBoolNode equBoolNode : this.getVariables()) {
            if (!equBoolNode.isRoot()) continue;
            if (nbrRoot <= 11) {
                if (nbrRoot == 11) {
                    buffer.append(", ...");
                } else {
                    if (nbrRoot > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(equBoolNode.getName());
                }
            }
            ++nbrRoot;
        }
        if (nbrRoot == 0) {
            _LOG.warning("No root (!?!)");
        }
        if (nbrRoot > 1) {
            _LOG.warning("Too many roots (" + nbrRoot + "): " + buffer.toString());
        }
        return nbrRoot == 1;
    }
}

